////////////////////////////////////////////////////////////////////////////
// CUndoListMgr 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "UndoListMgr.h"
#include "TaEditShell.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CUndoListMgr::CUndoListMgr() :
	MaxUndoCount( 1000 )
{
	Clear();
}

CUndoListMgr::~CUndoListMgr()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// Undoǽʺ
void CUndoListMgr::SetMaxUndoCount( int argCnt )
{
	assert( NULL != this && argCnt > 0 && argCnt <= INT_MAX );
	MaxUndoCount = argCnt;
}

// ɥǽݤ
bool CUndoListMgr::EnableUndo() const
{
	assert( NULL != this );
	return ( listUndo.begin() != itrUndo );
}

// ɥǽݤ
bool CUndoListMgr::EnableRedo() const
{
	assert( NULL != this );
	return ( listUndo.end() != itrUndo );
}

// UndoѤԽޥɥ֥Ȥ
VClsPtr< CEditCommand > CUndoListMgr::GetUndoObj()
{
	assert( NULL != this && EnableUndo() );
	itrUndo--;
	VClsPtr< CEditCommand > r = (*itrUndo);
	UpdateMenuStatus();
	return r;
}

// RedoѤԽޥɥ֥Ȥ
VClsPtr< CEditCommand > CUndoListMgr::GetRedoObj()
{
	assert( NULL != this && EnableRedo() );
	VClsPtr< CEditCommand > r = (*itrUndo);
	itrUndo++;
	UpdateMenuStatus();
	return r;
}

// Խޥɥ֥Ȥɲä
void CUndoListMgr::PushBack( VClsPtr< CEditCommand > pObj )
{
	assert( NULL != this );

	// UndoꥹȤθȾʬ
	if ( itrUndo != listUndo.end() )
		listUndo.erase( itrUndo, listUndo.end() );

	// Ǥɲä
	listUndo.push_back( pObj );

	// ꥹȤĶϡƬΤΤ
	if ( listUndo.size() > MaxUndoCount ) {
		list< VClsPtr< CEditCommand > >::iterator wItr = listUndo.begin();
		wItr++;
		listUndo.erase( listUndo.begin(), wItr );
	}

	// ݥȤ
	itrUndo = listUndo.end();

	UpdateMenuStatus();
}

// 
void CUndoListMgr::Clear()
{
	assert( NULL != this );
	listUndo.clear();
	itrUndo = listUndo.end();
}

// Undo/Redo˥塼ξ֤򹹿
void CUndoListMgr::UpdateMenuStatus() const
{
	assert( NULL != this );
	m_TaEditShell->SetEnableUndoMenu( EnableUndo() );
	m_TaEditShell->SetEnableRedoMenu( EnableRedo() );
}

