////////////////////////////////////////////////////////////////////////////
// CTxtColorMgr_cpp 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TxtColorMgr_cpp.h"

using namespace NLangExt;
using namespace NLangExt_cpp;

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTxtColorMgr_cpp::CTxtColorMgr_cpp()
{
	int i;
	for ( i = 0; i < 78; i++ ) IndexTable[i] = 0;
	IndexTable[ CCT_ALPHANUMERIC ] = 0;
	IndexTable[ CCT_KEYWORD ] = 1;
	IndexTable[ CCT_COM1_LEFT ] = 2;
	IndexTable[ CCT_COM1_RIGHT ] = 2;
	IndexTable[ CCT_COM1_TEXT ] = 2;
	IndexTable[ CCT_COM2_LEFT ] = 2;
	IndexTable[ CCT_COM2_RIGHT ] = 2;
	IndexTable[ CCT_COM2_TEXT ] = 2;
	IndexTable[ CCT_DQUOTE_LEFT ] = 3;
	IndexTable[ CCT_DQUOTE_RIGHT ] = 3;
	IndexTable[ CCT_DQUOTE_TEXT ] = 3;
	IndexTable[ CCT_SQUOTE_LEFT ] = 3;
	IndexTable[ CCT_SQUOTE_RIGHT ] = 3;
	IndexTable[ CCT_SQUOTE_TEXT ] = 3;
	IndexTable[ CCT_OTHER ] = 0;
	IndexTable[ CCT_NULL ] = 0;
}

CTxtColorMgr_cpp::~CTxtColorMgr_cpp()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
bool CTxtColorMgr_cpp::Initialize( VClsPtr< CConfigInfo > pConf )
{
	vColor[0] = pConf->RefCPP_NormalTextF_Color();
	vColor[1] = pConf->RefCPP_KeywordF_Color();
	vColor[2] = pConf->RefCPP_CommentF_Color();
	vColor[3] = pConf->RefCPP_SringF_Color();
	return true;
}

// Ѥ뿧ο
int CTxtColorMgr_cpp::GetColorCount() const
{
	return 4;
}

// 
Pixel CTxtColorMgr_cpp::GetColor( int idx ) const
{
	assert( idx >= 0 && idx < 4 );
	return vColor[idx];
}

// 󤫤鿧ΥǥåѴ
int CTxtColorMgr_cpp::TranseToIdx( unsigned char c ) const
{
	assert( c >= 0 && c < 78 );
	return IndexTable[c];
}

// ֤ǹ
void CTxtColorMgr_cpp::InitiUpdate( T_LineData &rData ) const
{
	CLinePseudoPtr_txt pSTxt( &rData );
	CLinePseudoPtr_txt pETxt( &rData );
	CLinePseudoPtr_clr pSCB( &rData );
	pETxt.SetEnd();
	m_HM.FullUpdate( pSTxt, pETxt, pSCB );
}

// ʸιȼι
void CTxtColorMgr_cpp::Update( T_LineData &rData, const T_SelRange &range ) const
{
	CLinePseudoPtr_txt pSTxt( &rData );
	CLinePseudoPtr_txt pETxt( &rData );
	CLinePseudoPtr_txt pUpdateSTxt( &rData );
	CLinePseudoPtr_txt pUpdateETxt( &rData );
	CLinePseudoPtr_clr pUpdateSPosCB( &rData );
	pETxt.SetEnd();
	pUpdateSTxt.SetPos( range.GetSPos() );
	pUpdateETxt.SetPos( range.GetEPos() );
	pUpdateSPosCB.SetPos( range.GetSPos() );
	m_HM.UpdateWidthChange( pSTxt, pETxt, pUpdateSTxt, pUpdateSPosCB, pUpdateETxt );
}
