#include "com_shizentai_app_arcam_JNIutils.h"
#include "com_shizentai_app_arcam_ARtk.h"
#include "com_shizentai_app_arcam_ARtk_MarkerInfo.h"
#include <android/log.h>
#include <stdio.h>
#include <pthread.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <errno.h>

#include <AR/ar.h>
#include <AR/matrix.h>
#include <AR/param.h>

#include "modeler/modeler.h"

//------------------------------------------------------------------------------

#define JNIVER									JNI_VERSION_1_4
enum
{
	PIXELFORMAT_RGBA_4444 =7,
	PIXELFORMAT_RGBA_5551 =6,
	PIXELFORMAT_RGBA_8888 =1,
	PIXELFORMAT_RGBX_8888 =2,
	PIXELFORMAT_RGB_332 =11,
	PIXELFORMAT_RGB_565 =4,
	PIXELFORMAT_RGB_888 =3,
};

//------------------------------------------------------------------------------

static JavaVM* g_VM;
//static jobject g_callbackListener;

static int g_width;
static int g_height;

static void** g_mqoModel = NULL;	// MQOモデル
static int g_nModels = 0;

//------------------------------------------------------------------------------

#define LOG( XX )  			putlog( __FUNCTION__, __FILE__, __LINE__, XX )
#define LOG1( XX, AA )	putlog( __FUNCTION__, __FILE__, __LINE__, XX, AA )
#define LOG2( XX, AA, BB )	putlog( __FUNCTION__, __FILE__, __LINE__, XX, AA, BB )
void putlog( const char* func, const char* file, int line, const char* fmt, ... )
{
	char buf[ 256 ];
	va_list args;
	int rv;
	
	rv = snprintf( buf, sizeof(buf)-1, "%s %s(%d): ", func, file, line );
	va_start( args, fmt );
	rv += vsnprintf( &buf[ rv ], sizeof(buf)-1-rv, fmt, args );
	va_end( args );
	__android_log_print( ANDROID_LOG_DEBUG, "arcamJNI", buf );
}
void putlogsimple( const char* fmt, ... )
{
	char buf[ 256 ];
	va_list args;
	
	va_start( args, fmt );
	vsnprintf( buf, sizeof(buf)-1, fmt, args );
	va_end( args );
	__android_log_print( ANDROID_LOG_DEBUG, "arcamJNI", buf );
}

#define MAX(A,B) (((A)>=(B))?(A):(B))
#define MIN(A,B) (((A)<(B))?(A):(B))
static int ALIGN_PAGE( int size )
{
	if ( size & ~PAGE_MASK )
		size = (size & PAGE_MASK) + PAGE_SIZE;
	return size;
}

//------------------------------------------------------------------------------

JNIEXPORT jint JNI_OnLoad( JavaVM* vm, void* reserved )
{
	LOG1( "%08x", (unsigned int)vm );
	g_VM = vm;

	g_width = 320;
	g_height = 240;

	return JNIVER;
}

JNIEXPORT void JNICALL Java_com_shizentai_app_arcam_JNIutils_decodeYUV420SP_1RGB565( JNIEnv *env, jclass cls, jshortArray rgb, jbyteArray yuv420sp, jint width, jint height, jint rectwidth, jint rectheight )
{
	jboolean b;
	jshort* prgb = (*env)->GetShortArrayElements( env, rgb, &b );
	jbyte* pyuv = (*env)->GetByteArrayElements( env, yuv420sp, &b );
	int frameSize = width * height;
	int i,j,yp;

	for ( j=0; j<rectheight; j++ ) 
	{
		int uvp = frameSize + (j>>1)*width;
		int u=0, v=0;
		for ( i=0, yp=j*width; i<rectwidth; i++,yp++ ) 
		{
			int y = (0xff & pyuv[ yp ]) - 16;
			if ( y < 0 )
				y = 0;
			if ( (i & 1) == 0 )
			{
				v = (0xff & pyuv[ uvp++ ]) - 128;
				u = (0xff & pyuv[ uvp++ ]) - 128;
			}
			
			int y1192 = 1192*y;
			int r = y1192 + 1634*v;
			int g = y1192 - 833*v - 400*u;
			int b = y1192 + 2066*u;
			r = MAX( 0, MIN( (1<<18)-1, r ) );
			g = MAX( 0, MIN( (1<<18)-1, g ) );
			b = MAX( 0, MIN( (1<<18)-1, b ) );
			
			prgb[ yp ] = (short)(((r>>2) & 0xf800) | ((g>>7) & 0x07e0) | (b>>13)); 
		}
	}
	
	(*env)->ReleaseByteArrayElements( env, yuv420sp, pyuv, JNI_ABORT );
	(*env)->ReleaseShortArrayElements( env, rgb, prgb, 0 );
}

JNIEXPORT void JNICALL Java_com_shizentai_app_arcam_JNIutils_decodeYUV420SP_1ARGB8888( JNIEnv *env, jclass cls, jintArray rgb, jbyteArray yuv420sp, jint width, jint height, jint rectwidth, jint rectheight )
{
	jboolean b;
	jint* prgb = (*env)->GetIntArrayElements( env, rgb, &b );
	jbyte* pyuv = (*env)->GetByteArrayElements( env, yuv420sp, &b );
	int frameSize = width * height;
	int i,j,yp;

	for ( j=0; j<rectheight; j++ ) 
	{
		int uvp = frameSize + (j>>1)*width;
		int u=0, v=0;
		for ( i=0, yp=j*width; i<rectwidth; i++,yp++ ) 
		{
			int y = (0xff & pyuv[ yp ]) - 16;
			if ( y < 0 )
				y = 0;
			if ( (i & 1) == 0 )
			{
				v = (0xff & pyuv[ uvp++ ]) - 128;
				u = (0xff & pyuv[ uvp++ ]) - 128;
			}
			
			int y1192 = 1192*y;
			int r = y1192 + 1634*v;
			int g = y1192 - 833*v - 400*u;
			int b = y1192 + 2066*u;
			r = MAX( 0, MIN( (1<<18)-1, r ) );
			g = MAX( 0, MIN( (1<<18)-1, g ) );
			b = MAX( 0, MIN( (1<<18)-1, b ) );
			
 			prgb[ yp ] = 0xff000000 | ((b << 6) & 0xff0000) | ((g >> 2) & 0xff00) | (r >> 10);
		}
	}

	(*env)->ReleaseByteArrayElements( env, yuv420sp, pyuv, JNI_ABORT );
	(*env)->ReleaseIntArrayElements( env, rgb, prgb, 0 );
}

JNIEXPORT jboolean JNICALL Java_com_shizentai_app_arcam_JNIutils_loadModel( JNIEnv* env, jclass cls, jobjectArray pathes )
{
	jboolean b;
	const char* ps;
	int i;
	
	if ( !pathes )
		return JNI_FALSE;

	modelerInit();
	g_nModels = (*env)->GetArrayLength( env, pathes );
	g_mqoModel = (void*)malloc( sizeof(void*)*g_nModels );

	for ( i=0; i<g_nModels; i++ )
	{
		jstring str = (*env)->GetObjectArrayElement( env, pathes, i );
		ps = (*env)->GetStringUTFChars( env, str, &b );

		g_mqoModel[ i ] = modelerLoadModel( ps );

		(*env)->ReleaseStringUTFChars( env, str, ps );
		(*env)->DeleteLocalRef( env, str );
		
		if ( !g_mqoModel[ i ] )
		{
			while ( --i > 0 )
				modelerUnloadModel( g_mqoModel[ i ] );
			free( g_mqoModel );
			g_mqoModel = NULL;
			g_nModels = 0;
			break;
		}
	}
	return (g_mqoModel != NULL)? JNI_TRUE : JNI_FALSE;
}

JNIEXPORT void JNICALL Java_com_shizentai_app_arcam_JNIutils_unloadModel( JNIEnv* env, jclass cls )
{
	if ( g_mqoModel )
	{
		int i;
		for ( i=0; i<g_nModels; i++ )
			modelerUnloadModel( g_mqoModel[ i ] );
		free( g_mqoModel );
		g_mqoModel = NULL;
		g_nModels = 0;
		modelerExit();
	}
}

JNIEXPORT void JNICALL Java_com_shizentai_app_arcam_JNIutils_drawModel( JNIEnv* env, jclass cls, jint n )
{
	if ( g_mqoModel  &&  g_nModels > n )
	{
//LOG2( "%08x %d", g_mqoModel, n );
		mqoCallModel( g_mqoModel[ n ] );
	}
}

//----------------------------------------------------------------------------

static void argConvGlpara( ARVAL para[3][4], int gl_para[16] )
{
    int     i, j;

    for( j = 0; j < 3; j++ ) {
        for( i = 0; i < 4; i++ ) {
            gl_para[i*4+j] = (int)(para[j][i] >> (REALBITS_ARVAL-16));
        }
    }
    gl_para[0*4+3] = gl_para[1*4+3] = gl_para[2*4+3] = 0;
    gl_para[3*4+3] = 1<<16;
}
static void argConvPara( int gl_para[16], ARVAL para[3][4] )
{
    int     i, j;

    for( j = 0; j < 3; j++ ) {
        for( i = 0; i < 4; i++ ) {
            para[j][i] = ((ARVAL)gl_para[i*4+j]) << (REALBITS_ARVAL-16);
        }
    }
}
static int argConvGLcpara2( double cparam[3][4], int width, int height, double gnear, double gfar, double m[16] )
{
		double	 icpara[3][4];
		double	 trans[3][4];
		double	 p[3][3], q[4][4];
		int 		 i, j;

		if ( arParamDecompMat(cparam, icpara, trans) < 0 ) 
		{
				//DbgTrace("gConvGLcpara: Parameter error!!\n");
				return -1;
		}

		for( i = 0; i < 3; i++ ) {
				for( j = 0; j < 3; j++ ) {
						p[i][j] = icpara[i][j] / icpara[2][2];
				}
		}
		q[0][0] = (2.0 * p[0][0] / width);
		q[0][1] = (2.0 * p[0][1] / width);
		q[0][2] = ((2.0 * p[0][2] / width)	- 1.0);
		q[0][3] = 0.0;

		q[1][0] = 0.0;
		q[1][1] = (2.0 * p[1][1] / height);
		q[1][2] = ((2.0 * p[1][2] / height) - 1.0);
		q[1][3] = 0.0;

		q[2][0] = 0.0;
		q[2][1] = 0.0;
		q[2][2] = (gfar + gnear)/(gfar - gnear);
		q[2][3] = -2.0 * gfar * gnear / (gfar - gnear);

		q[3][0] = 0.0;
		q[3][1] = 0.0;
		q[3][2] = 1.0;
		q[3][3] = 0.0;

		for( i = 0; i < 4; i++ ) {
				for( j = 0; j < 3; j++ ) {
						m[i+j*4] = q[i][0] * trans[0][j]
										 + q[i][1] * trans[1][j]
										 + q[i][2] * trans[2][j];
				}
				m[i+3*4] = q[i][0] * trans[0][3]
								 + q[i][1] * trans[1][3]
								 + q[i][2] * trans[2][3]
								 + q[i][3];
		}
		
		return 0;
}


JNIEXPORT jdoubleArray JNICALL Java_com_shizentai_app_arcam_ARtk_arInit( JNIEnv* env, jclass cls, jbyteArray cam_param, jint width, jint height )
{
	jboolean b;
	jbyte* p;
	jdoubleArray mat = NULL;
	ARParam wparam, cparam;
	
	if ( !cam_param )
		return NULL;
	if ( (*env)->GetArrayLength( env, cam_param ) < sizeof(ARParamFile) )
		return NULL;
	
	p = (*env)->GetByteArrayElements( env, cam_param, &b );
	if ( arParamLoadFromImage( p, 1, &wparam ) >= 0 )
	{
		if ( arParamChangeSize( &wparam, width, height, &cparam ) >= 0 )
		{
			double cam_matrix[ 3 ][ 4 ];
			double cam_gl_matrix[ 16 ];
			int i;
			jdouble* d;
			
			g_width = width;
			g_height = height;
			arInitCparam( &cparam );
			memcpy( cam_matrix, cparam.mat, sizeof(cam_matrix) );
			for( i=0; i<4; i++ )
				cam_matrix[ 1 ][ i ] = (cparam.ysize-1)*(cam_matrix[ 2 ][ i ]) - cam_matrix[ 1 ][ i ];
			
			if ( argConvGLcpara2( cam_matrix, cparam.xsize, cparam.ysize, AR_GL_CLIP_NEAR, AR_GL_CLIP_FAR, cam_gl_matrix ) >= 0 )
			{
				mat = (*env)->NewDoubleArray( env, 16 );
				d = (*env)->GetDoubleArrayElements( env, mat, &b );
				memcpy( d, cam_gl_matrix, sizeof(cam_gl_matrix) );
				(*env)->ReleaseDoubleArrayElements( env, mat, d, 0 );
			}
		}
	}
	
	(*env)->ReleaseByteArrayElements( env, cam_param, p, JNI_ABORT );
	return mat;
}

JNIEXPORT void JNICALL Java_com_shizentai_app_arcam_ARtk_arExit( JNIEnv* env, jclass cls )
{
}


JNIEXPORT void JNICALL Java_com_shizentai_app_arcam_ARtk_arSetPattMode( JNIEnv* env, jclass cls, jint mode )
{
	arSetPattMode( mode );
}

JNIEXPORT jint JNICALL Java_com_shizentai_app_arcam_ARtk_arLoadPatt( JNIEnv* env, jclass cls, jbyteArray data )
{
	jboolean b;
	jbyte* p;
	int r;
	
	if ( !data )
		return -1;
	p = (*env)->GetByteArrayElements( env, data, &b );
	
	r = arLoadPattFromImage( p, (*env)->GetArrayLength( env, data ) );
	
	(*env)->ReleaseByteArrayElements( env, data, p, JNI_ABORT );
	return r;
}

JNIEXPORT void JNICALL Java_com_shizentai_app_arcam_ARtk_arFreePatt( JNIEnv* env, jclass cls, jint patt )
{
	arFreePatt( patt );
}

JNIEXPORT jint JNICALL Java_com_shizentai_app_arcam_ARtk_arActivatePatt( JNIEnv* env, jclass cls, jint patt )
{
	return arActivatePatt( patt );
}

JNIEXPORT void JNICALL Java_com_shizentai_app_arcam_ARtk_arDeactivatePatt( JNIEnv* env, jclass cls, jint patt )
{
	arDeactivatePatt( patt );
}

// imgはdirect配列であるのが望ましい
jobjectArray detectMarker( JNIEnv* env, jclass cls, jintArray img, jint threshold, int isLite )
{
	jboolean b;
	jint* p;
	int i, k, r, markers;
	ARMarkerInfo* inf;
	jobjectArray marker_info = NULL;
	
	if ( !img )
		return NULL;
	if ( (*env)->GetArrayLength( env, img ) < g_width*g_height )
		return NULL;
	p = (*env)->GetIntArrayElements( env, img, &b );

	r = isLite? arDetectMarkerLite( (ARUint8*)p, threshold, &inf, &markers ) : arDetectMarker( (ARUint8*)p, threshold, &inf, &markers );
	(*env)->ReleaseIntArrayElements( env, img, p, JNI_ABORT );
	
	if ( r >= 0 )
	{
		jclass clsmk = (*env)->FindClass( env, "com/shizentai/app/arcam/ARtk$MarkerInfo" );
		jmethodID mid = (*env)->GetMethodID( env, clsmk, "<init>", "(Lcom/shizentai/app/arcam/ARtk;)V" );
		marker_info = (*env)->NewObjectArray( env, markers, clsmk, NULL );

		for ( i=0; i<markers; i++ )
		{
			jobject objmk;
			jfieldID fid;
			jintArray objvertex;
			jint* parray;
			jlongArray objraw;
			jlong* praw;
			
			ARMarkerInfo* mi = &inf[ i ];
//for ( k=0; k<4; k++ ) LOG2( "%f, %f", ARVALtoDouble( mi->vertex[ k ][ 0 ] ), ARVALtoDouble( mi->vertex[ k ][ 1 ] ) );
			
			// MarkerInfoを生成
			objmk = (*env)->NewObject( env, clsmk, mid, cls );
			
			// データメンバ設定
			fid = (*env)->GetFieldID( env, clsmk, "area", "I" );
			(*env)->SetIntField( env, objmk, fid, mi->area );
			
			fid = (*env)->GetFieldID( env, clsmk, "dir", "I" );
			(*env)->SetIntField( env, objmk, fid, mi->dir );
			
			fid = (*env)->GetFieldID( env, clsmk, "id", "J" );
			(*env)->SetLongField( env, objmk, fid, mi->id );

			fid = (*env)->GetFieldID( env, clsmk, "cf", "I" );
			(*env)->SetIntField( env, objmk, fid, (jint)(mi->cf >> (REALBITS_ARVAL-16)) );

			fid = (*env)->GetFieldID( env, clsmk, "posx", "I" );
			(*env)->SetIntField( env, objmk, fid, ARVALtoInt( mi->pos[ 0 ] ) );

			fid = (*env)->GetFieldID( env, clsmk, "posy", "I" );
			(*env)->SetIntField( env, objmk, fid, ARVALtoInt( mi->pos[ 1 ] ) );

			fid = (*env)->GetFieldID( env, clsmk, "vertex", "[I" );
			objvertex = (jintArray)(*env)->GetObjectField( env, objmk, fid );
			parray = (*env)->GetIntArrayElements( env, objvertex, &b );
			for ( k=0; k<8; k+=2 )
			{
				parray[ k   ] = ARVALtoInt( mi->vertex[ k>>1 ][ 0 ] );
				parray[ k+1 ] = ARVALtoInt( mi->vertex[ k>>1 ][ 1 ] );
			}
			(*env)->ReleaseIntArrayElements( env, objvertex, parray, 0 );
			(*env)->DeleteLocalRef( env, (jobject)objvertex );	// 必要？

			fid = (*env)->GetFieldID( env, clsmk, "raw", "[J" );
			objraw = (jlongArray)(*env)->GetObjectField( env, objmk, fid );
			praw = (*env)->GetLongArrayElements( env, objraw, &b );
			memcpy( praw, mi, sizeof(ARMarkerInfo) );
			(*env)->ReleaseLongArrayElements( env, objraw, praw, 0 );
			(*env)->DeleteLocalRef( env, (jobject)objraw );	// 必要？

			(*env)->SetObjectArrayElement( env, marker_info, i, objmk );
			(*env)->DeleteLocalRef( env, objmk );
		}

		(*env)->DeleteLocalRef( env, clsmk );	// 必要？
	}
	
	return marker_info;
}


JNIEXPORT jobjectArray JNICALL Java_com_shizentai_app_arcam_ARtk_arDetectMarker( JNIEnv* env, jclass cls, jintArray img, jint threshold )
{
	return detectMarker( env, cls, img, threshold, FALSE );
}

JNIEXPORT jobjectArray JNICALL Java_com_shizentai_app_arcam_ARtk_arDetectMarkerLite( JNIEnv* env, jclass cls, jintArray img, jint threshold )
{
	return detectMarker( env, cls, img, threshold, TRUE );
}

JNIEXPORT jint JNICALL Java_com_shizentai_app_arcam_ARtk_arGetTransMat( JNIEnv* env, jclass cls, jobject marker_info, jint cx, jint cy, jint width, jintArray conv )
{
	ARVAL r;
	ARVAL center[ 2 ];
	ARVAL c[ 3 ][ 4 ];
	
	jboolean b;
	jclass clsmk;
	jfieldID fid;
	jlongArray objraw;
	jlong* praw;
	jint* pconv;
	
	if ( !marker_info || !conv || width<=0 )
		return 0;
	clsmk = (*env)->GetObjectClass( env, marker_info );
	fid = (*env)->GetFieldID( env, clsmk, "raw", "[J" );
	objraw = (jlongArray)(*env)->GetObjectField( env, marker_info, fid );
	praw = (*env)->GetLongArrayElements( env, objraw, &b );

	center[ 0 ] = IntToARVAL( cx );
	center[ 1 ] = IntToARVAL( cy );
	r = arGetTransMat( (ARMarkerInfo*)praw, center, IntToARVAL( width ), c );
	
	(*env)->ReleaseLongArrayElements( env, objraw, praw, JNI_ABORT );
	
	pconv = (*env)->GetIntArrayElements( env, conv, &b );
	argConvGlpara( c, pconv );
	(*env)->ReleaseIntArrayElements( env, conv, pconv, 0 );
	
	(*env)->DeleteLocalRef( env, (jobject)objraw );	// 必要？
	(*env)->DeleteLocalRef( env, clsmk );	// 必要？
	return (int)(r >> (REALBITS_ARVAL-16));
}

JNIEXPORT jint JNICALL Java_com_shizentai_app_arcam_ARtk_arGetTransMatCont( JNIEnv* env, jclass cls, jobject marker_info, jintArray prev_conv, jint cx, jint cy, jint width, jintArray conv )
{
	ARVAL r;
	ARVAL center[ 2 ];
	ARVAL c[ 3 ][ 4 ];
	ARVAL cprev[ 3 ][ 4 ];
	
	jboolean b;
	jclass clsmk;
	jfieldID fid;
	jlongArray objraw;
	jlong* praw;
	jint* pconv;
	
	if ( !prev_conv || !marker_info || !conv || width<=0 )
		return 0;
	clsmk = (*env)->GetObjectClass( env, marker_info );
	fid = (*env)->GetFieldID( env, clsmk, "raw", "[J" );
	objraw = (jlongArray)(*env)->GetObjectField( env, marker_info, fid );
	praw = (*env)->GetLongArrayElements( env, objraw, &b );

	pconv = (*env)->GetIntArrayElements( env, prev_conv, &b );
	argConvPara( pconv, cprev );
	(*env)->ReleaseIntArrayElements( env, prev_conv, pconv, JNI_ABORT );
	center[ 0 ] = IntToARVAL( cx );
	center[ 1 ] = IntToARVAL( cy );
	r = arGetTransMatCont( (ARMarkerInfo*)praw, cprev, center, IntToARVAL( width ), c );
	
	(*env)->ReleaseLongArrayElements( env, objraw, praw, JNI_ABORT );
	
	pconv = (*env)->GetIntArrayElements( env, conv, &b );
	argConvGlpara( c, pconv );
	(*env)->ReleaseIntArrayElements( env, conv, pconv, 0 );
	
	(*env)->DeleteLocalRef( env, (jobject)objraw );	// 必要？
	(*env)->DeleteLocalRef( env, clsmk );	// 必要？
	return (int)(r >> (REALBITS_ARVAL-16));
}

