package com.shizentai.app.arcam;

/**
  * int版ARtoolkitをJNI経由でハンドルするクラス。
  *
  * @author Shizentai Factory Co.
  * @version 1.00
  * @since 1.00
  */
public class ARtk
{

	/**
	  * マーカー情報を管理するクラス。
	  *
	  * @author Shizentai Factory Co.
	  * @version 1.00
	  * @since 1.00
	  */
	public class MarkerInfo
	{
    int  area;
    int  dir;
		long id;
    int  cf;
    int  posx, posy;
    int[] vertex;
    long[] raw;
    
    public MarkerInfo()
    {
      vertex = new int [ 4*2 ];
      raw = new long [ 24 + 1 ];
    }
    
  	/**
  	 * パターン番号または数値コードを取得する。
  	 */
    public long get_id()
    {
			return id;
		}
    
  	/**
  	 * 相関度を取得する。
  	 */
    public double get_cf()
    {
			return cf;
		}

  	/**
  	 * マーカーの向きを取得する。
  	 */
    public int get_dir()
		{
			return dir;
    }

  	/**
  	 * マーカーの位置をスクリーン座標系で取得する。
  	 */
    public int[] get_pos()
		{
			return new int[]{ posx, posy };
    }
    
  	/**
  	 * マーカーの外縁4頂点をスクリーン座標系で取得する。
  	 */
    public int[][] get_vertex()
    {
			int[][] v = new int [ 4 ][ 2 ];
			for ( int i=0; i<8; i+=2 )
			{
				v[ i ][ 0 ] = vertex[ i ];
				v[ i ][ 1 ] = vertex[ i+1 ];
			}
			return v;
		}
    
	}
	
	
	//
	// ネイティブライブラリ宣言
	//
	static 
	{
		System.loadLibrary( "arcamLib" );
	}

	/**
	 * カメラパラメータをロードしてARライブラリを初期化し、ARライブラリの使用を開始する。
	 * @param data パラメータファイルイメージ
	 * @param width カメラ横ピクセル数
	 * @param height カメラ縦ピクセル数
	 * @return カメラ投影行列(double[16])、nullなら失敗
	 */
  static native double[] arInit( byte[] cam_param, int width, int height );
  
	/**
	 * ARライブラリの使用を終了する。
	 */
  static native void arExit();
  
	/**
	 * マーカーパターン検出モードを設定する。
	 * @param mode 0なら画像検出、1なら数値コード検出 デフォルトは0
	 */
	static native void arSetPattMode( int mode );
	
	/**
	 * マーカー画像パターンをロードする。
	 * @param data パターンファイルイメージ
	 * @return パターン番号 0未満なら失敗
	 */
	static native int arLoadPatt( byte[] data );
	
	/**
	 * 画像パターンファイルをアンロードする。
	 * @param patt パターン番号
	 */
	static native void arFreePatt( int patt );

	/**
	 * 指定したマーカー画像の検出を有効にする。
	 * @param patt パターン番号
	 * @return 0未満なら失敗
	 */
	static native int arActivatePatt( int pattt );

	/**
	 * 指定したマーカー画像の検出を無効にする。
	 * @param patt パターン番号
	 */
	static native void arDeactivatePatt( int pattt );
	
	/**
	 * ビットマップ画像からマーカーを検出する。
	 * @param dataPtr ビットマップ画像
	 * @param threshold 白黒判定閾値 0～255
	 * @return マーカー情報 検出したパターン数だけある nullなら失敗
	 */
	static native MarkerInfo[] arDetectMarker( int[] img, int threshold );

	/**
	 * ビットマップ画像からマーカーを検出する。arDetectMarkerよりも簡易に処理を行う(前回の検出情報を利用しない)。
	 * @param dataPtr ビットマップ画像
	 * @param threshold 白黒判定閾値 0～255
	 * @return マーカー情報 検出したパターン数だけある nullなら失敗
	 */
	static native MarkerInfo[] arDetectMarkerLite( int[] img, int threshold );

	/**
	 * マーカー情報からマーカーの位置および角度を示す行列を取得する。
	 * @param marker_info マーカー情報
	 * @param cx マーカー中心x位置[mm]
	 * @param cy マーカー中心y位置[mm]
	 * @param width マーカーの一辺の長さ[mm]
	 * @param conv 行列を受け取る配列([16])
	 * @return 検出誤差*2^16
	 */
	static native int arGetTransMat( MarkerInfo marker_info, int cx, int cy, int width, int[] conv );

	/**
	 * マーカー情報からマーカーの位置および角度を示す行列を、前回取得した行列を参考にしたうえで取得する。
	 * @param marker_info マーカー情報
	 * @param prev_conv 前回取得した変換行列([16])
	 * @param cx マーカー中心x位置[mm]
	 * @param cy マーカー中心y位置[mm]
	 * @param width マーカーの一辺の長さ[mm]
	 * @param conv 行列を受け取る配列([16])
	 * @return 検出誤差*2^16
	 */
	static native int arGetTransMatCont( MarkerInfo marker_info, int[] prev_conv, int cx, int cy, int width, int[] conv );

}
