/*
 * Decompiled with CFR 0.152.
 */
package tdoclet;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import tdoclet.TestItem;
import tdoclet.TestReport;

public class JUnitTestReport
implements TestReport {
    private String reportPath;
    private Map table;

    public JUnitTestReport(String path) {
        this.reportPath = path;
        this.table = new HashMap();
    }

    public int getResult(TestItem item) {
        Map results = this.getResultMap(item);
        if (results == null) {
            return 3;
        }
        String result = (String)results.get(item.getTestMethod());
        if (result == null) {
            return 3;
        }
        if (result.equals("success")) {
            return 0;
        }
        if (result.equals("failure")) {
            return 1;
        }
        if (result.equals("error")) {
            return 2;
        }
        return 3;
    }

    public Date getDate(TestItem item) {
        File file = this.getResultXmlFile(item);
        if (file.exists()) {
            return new Date(file.lastModified());
        }
        return null;
    }

    private File getResultXmlFile(TestItem item) {
        String fileName = this.reportPath + "TEST-" + item.getTestClass() + ".xml";
        return new File(fileName);
    }

    private Map getResultMap(TestItem item) {
        HashMap<String, String> results = (HashMap<String, String>)this.table.get(item.getTestClass());
        if (results != null) {
            return results;
        }
        Object testedDate = null;
        results = new HashMap<String, String>();
        File file = this.getResultXmlFile(item);
        if (!file.exists()) {
            return results;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(file);
            Element element = document.getDocumentElement();
            NodeList resultsElement = element.getElementsByTagName("testcase");
            int j = 0;
            while (j < resultsElement.getLength()) {
                Element testCase = (Element)resultsElement.item(j);
                String methodName = testCase.getAttribute("name");
                NodeList failureList = testCase.getElementsByTagName("failure");
                if (failureList.getLength() > 0) {
                    results.put(methodName, "failure");
                } else {
                    NodeList errorList = testCase.getElementsByTagName("error");
                    if (errorList.getLength() > 0) {
                        results.put(methodName, "error");
                    } else {
                        results.put(methodName, "success");
                    }
                }
                ++j;
            }
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return results;
    }
}

