/*
 * Decompiled with CFR 0.152.
 */
package tdoclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import tdoclet.TestItem;
import tdoclet.TestSupervisor;
import tdoclet.Xmls;

public class TDoclet {
    public static final String DEFAULT_TAG_TEST = "test";
    public static final String DEFAULT_TAG_TARGET = "target";
    private String junitReportDirectory;
    private String outFileName;

    public static boolean start(RootDoc root) {
        try {
            TDoclet doclet = new TDoclet(root.options());
            doclet.startGeneration(root.classes());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            return false;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            return false;
        }
        catch (SAXException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            return false;
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            return false;
        }
        return true;
    }

    public static int optionLength(String option) {
        if (option.equals("-reportdir")) {
            return 2;
        }
        if (option.equals("-destfile")) {
            return 2;
        }
        return 0;
    }

    public TDoclet(String[][] options) {
        int i = 0;
        while (i < options.length) {
            if (options[i][0].equals("-reportdir")) {
                this.junitReportDirectory = options[i][1] + File.separator;
            }
            if (options[i][0].equals("-destfile")) {
                this.outFileName = options[i][1];
            }
            ++i;
        }
        if (this.junitReportDirectory == null) {
            this.junitReportDirectory = "";
        }
        if (this.outFileName == null) {
            this.outFileName = "testlist.xml";
        }
    }

    private void startGeneration(ClassDoc[] classes) throws ParserConfigurationException, TransformerException, IOException, SAXException, ParseException {
        TestSupervisor supervisor = new TestSupervisor(this.outFileName, this.junitReportDirectory);
        this.generateTestItems(supervisor, classes);
        Document doc = supervisor.generateTestDomTree();
        Xmls.generateXmlFile(doc, this.outFileName);
    }

    private void generateTestItems(TestSupervisor supervisor, ClassDoc[] classes) throws ParserConfigurationException, SAXException, IOException, ParseException {
        int i = 0;
        while (i < classes.length) {
            String author = null;
            Tag[] authors = classes[i].tags("author");
            if (authors.length > 0) {
                author = authors[0].text();
            }
            MethodDoc[] methods = classes[i].methods();
            int j = 0;
            while (j < methods.length) {
                String target = null;
                Tag[] targets = methods[j].tags(DEFAULT_TAG_TARGET);
                if (targets.length > 0) {
                    target = targets[0].text();
                }
                Tag[] descriptions = methods[j].tags(DEFAULT_TAG_TEST);
                int k = 0;
                while (k < descriptions.length) {
                    TestItem item;
                    String name;
                    StringTokenizer tokenizer = new StringTokenizer(descriptions[k].text(), ":");
                    String des = name = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        des = tokenizer.nextToken();
                    }
                    if ((item = supervisor.getTestItem(classes[i].toString(), methods[j].name(), name)) == null) {
                        item = supervisor.createTestItem(classes[i].toString(), methods[j].name(), name, des);
                        item.setTarget(target);
                        item.setAuthor(author);
                    }
                    supervisor.getJUnitReport(item);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    static {
        DEFAULT_TAG_TEST = DEFAULT_TAG_TEST;
        DEFAULT_TAG_TARGET = DEFAULT_TAG_TARGET;
    }
}

