<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output encoding="EUC-JP" indent="yes"/>

	<xsl:template match="/test">
		<html>
			<head>
				<title>Test List</title>
			</head>
			<body>
				<h1>Test List</h1>
				<table border="1">
					<tr>
						<td>Class</td>
						<td>Method</td>
						<td>name</td>
						<td>target</td>
						<td>author</td>
						<td>description</td>
						<td>status</td>
						<td>result</td>
						<td>date</td>
					</tr>
					<xsl:apply-templates/>
				</table>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="*">
	</xsl:template>

	<xsl:template match="TestList">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="TestList/item">
		<tr>
			<td><xsl:value-of select="@testClass" /></td>
			<td><xsl:value-of select="@testMethod" /></td>
			<td><xsl:value-of select="@name" /></td>
			<td><xsl:value-of select="target"/></td>
			<td><xsl:value-of select="author"/></td>
			<td><xsl:value-of select="description"/></td>
			<td><xsl:value-of select="state"/></td>
			<xsl:apply-templates select="history"/>
		</tr>
	</xsl:template>

	<xsl:template match="history">
		<xsl:if test="position() = last()" >
			<td><xsl:value-of select="@result"/></td>
			<td><xsl:value-of select="@date"/></td>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>

