/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.wizard;

import java.util.Iterator;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;

public class WizardPageSupport {
    private WizardPage wizardPage;
    private DataBindingContext dbc;
    private AggregateValidationStatus aggregateStatus;
    private boolean uiChanged = false;
    private IChangeListener uiChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            WizardPageSupport.this.handleUIChanged();
        }
    };
    private IListChangeListener bindingsListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] differences = diff.getDifferences();
            int i = 0;
            while (i < differences.length) {
                ListDiffEntry listDiffEntry = differences[i];
                Binding binding = (Binding)listDiffEntry.getElement();
                if (listDiffEntry.isAddition()) {
                    binding.getTarget().addChangeListener(WizardPageSupport.this.uiChangeListener);
                } else {
                    binding.getTarget().removeChangeListener(WizardPageSupport.this.uiChangeListener);
                }
                ++i;
            }
        }
    };
    private IStatus currentStatus;

    public static WizardPageSupport create(WizardPage wizardPage, DataBindingContext dbc) {
        return new WizardPageSupport(wizardPage, dbc);
    }

    private WizardPageSupport(WizardPage wizardPage, DataBindingContext dbc) {
        this.wizardPage = wizardPage;
        this.dbc = dbc;
        this.init();
    }

    protected void init() {
        this.aggregateStatus = new AggregateValidationStatus((IObservableCollection)this.dbc.getBindings(), 2);
        this.aggregateStatus.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                WizardPageSupport.this.currentStatus = (IStatus)event.diff.getNewValue();
                WizardPageSupport.this.handleStatusChanged();
            }
        });
        this.currentStatus = (IStatus)this.aggregateStatus.getValue();
        this.handleStatusChanged();
        this.dbc.getBindings().addListChangeListener(this.bindingsListener);
        Iterator it = this.dbc.getBindings().iterator();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            binding.getTarget().addChangeListener(this.uiChangeListener);
        }
    }

    protected void handleUIChanged() {
        this.uiChanged = true;
        if (this.currentStatus != null) {
            this.handleStatusChanged();
        }
        this.dbc.getBindings().removeListChangeListener(this.bindingsListener);
        Iterator it = this.dbc.getBindings().iterator();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            binding.getTarget().removeChangeListener(this.uiChangeListener);
        }
    }

    protected void handleStatusChanged() {
        if (this.currentStatus != null && this.currentStatus.getSeverity() == 4) {
            this.wizardPage.setPageComplete(false);
            this.wizardPage.setErrorMessage(this.uiChanged ? this.currentStatus.getMessage() : null);
        } else {
            this.wizardPage.setPageComplete(true);
            this.wizardPage.setErrorMessage(null);
        }
    }

    public void dispose() {
        this.aggregateStatus.dispose();
        if (!this.uiChanged) {
            Iterator it = this.dbc.getBindings().iterator();
            while (it.hasNext()) {
                Binding binding = (Binding)it.next();
                binding.getTarget().removeChangeListener(this.uiChangeListener);
            }
            this.dbc.getBindings().removeListChangeListener(this.bindingsListener);
        }
        this.aggregateStatus = null;
        this.dbc = null;
        this.uiChangeListener = null;
        this.bindingsListener = null;
        this.wizardPage = null;
    }
}

