/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Collection;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class ObservableListContentProvider
implements IStructuredContentProvider {
    private IObservableList observableList;
    private Viewer viewer;
    private IListChangeListener listener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            if (ObservableListContentProvider.this.viewer.getControl().isDisposed()) {
                return;
            }
            ListDiffEntry[] differences = event.diff.getDifferences();
            int i = 0;
            while (i < differences.length) {
                ListDiffEntry entry = differences[i];
                if (entry.isAddition()) {
                    ObservableListContentProvider.this.knownElements.add(entry.getElement());
                    if (ObservableListContentProvider.this.viewer instanceof AbstractListViewer) {
                        ((AbstractListViewer)ObservableListContentProvider.this.viewer).add(entry.getElement());
                    } else {
                        ((TableViewer)ObservableListContentProvider.this.viewer).insert(entry.getElement(), entry.getPosition());
                    }
                } else {
                    if (ObservableListContentProvider.this.viewer instanceof AbstractListViewer) {
                        ((AbstractListViewer)ObservableListContentProvider.this.viewer).remove(entry.getElement());
                    } else {
                        ((TableViewer)ObservableListContentProvider.this.viewer).remove(entry.getElement());
                    }
                    ObservableListContentProvider.this.knownElements.remove(entry.getElement());
                }
                ++i;
            }
        }
    };
    private IObservableSet knownElements;

    public ObservableListContentProvider() {
        this.observableList = new WritableList(SWTObservables.getRealm(Display.getDefault()));
        this.knownElements = new WritableSet(SWTObservables.getRealm(Display.getDefault()));
    }

    public Object[] getElements(Object inputElement) {
        return this.observableList.toArray();
    }

    public void dispose() {
        this.observableList.removeListChangeListener(this.listener);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (!(viewer instanceof TableViewer) && !(viewer instanceof AbstractListViewer)) {
            Class<?> abstractTableViewerClass = null;
            try {
                abstractTableViewerClass = Class.forName("org.eclipse.jface.viewers.AbstractTableViewer");
            }
            catch (Exception exception) {}
            if (abstractTableViewerClass == null || !abstractTableViewerClass.isInstance(viewer)) {
                throw new IllegalArgumentException("This content provider only works with (Abstract)TableViewer or AbstractListViewer");
            }
        }
        if (newInput != null && !(newInput instanceof IObservableList)) {
            throw new IllegalArgumentException("This content provider only works with input of type IObservableList");
        }
        this.setInput((IObservableList)newInput);
    }

    private void setInput(IObservableList list) {
        if (list == null) {
            list = new WritableList(SWTObservables.getRealm(Display.getDefault()));
        }
        if (this.observableList != null) {
            this.observableList.removeListChangeListener(this.listener);
        }
        this.knownElements.clear();
        this.observableList = list;
        this.knownElements.addAll((Collection)list);
        this.observableList.addListChangeListener(this.listener);
    }

    public IObservableSet getKnownElements() {
        return this.knownElements;
    }
}

