/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.dialogs.PatternFilter;

class CategoryPatternFilter
extends PatternFilter {
    private boolean filterCategories;
    final Category uncategorized;

    public CategoryPatternFilter(boolean filterCategories, Category c) {
        this.uncategorized = c;
        this.filterCategories(filterCategories);
    }

    public void filterCategories(boolean b) {
        this.filterCategories = b;
        if (this.filterCategories) {
            this.setPattern("org.eclipse.ui.keys.optimization.false");
        } else {
            this.setPattern("org.eclipse.ui.keys.optimization.true");
        }
    }

    public boolean isFilteringCategories() {
        return this.filterCategories;
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        if (this.filterCategories) {
            ParameterizedCommand cmd = this.getCommand(element);
            try {
                if (cmd != null && cmd.getCommand().getCategory() == this.uncategorized) {
                    return false;
                }
            }
            catch (NotDefinedException notDefinedException) {
                return false;
            }
        }
        return super.isLeafMatch(viewer, element);
    }

    private ParameterizedCommand getCommand(Object element) {
        if (element instanceof ParameterizedCommand) {
            return (ParameterizedCommand)element;
        }
        if (element instanceof Binding) {
            return ((Binding)element).getParameterizedCommand();
        }
        return null;
    }
}

