/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.CommandLineArgs;
import org.eclipse.equinox.internal.app.EclipseAppContainer;
import org.eclipse.equinox.internal.app.EclipseAppDescriptor;
import org.eclipse.equinox.internal.app.IBranding;
import org.eclipse.equinox.internal.app.Messages;
import org.eclipse.osgi.service.runnable.ApplicationRunnable;
import org.eclipse.osgi.service.runnable.StartupMonitor;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationHandle;

public class EclipseAppHandle
extends ApplicationHandle
implements ApplicationRunnable,
IApplicationContext {
    private static final int FLAG_STARTING = 1;
    private static final int FLAG_ACTIVE = 2;
    private static final int FLAG_STOPPING = 4;
    private static final int FLAG_STOPPED = 8;
    private static final String STARTING = "org.eclipse.equinox.app.starting";
    private static final String STOPPED = "org.eclipse.equinox.app.stopped";
    private static final String PROP_ECLIPSE_EXITCODE = "eclipse.exitcode";
    private volatile ServiceRegistration handleRegistration;
    private int status = 1;
    private final Map arguments;
    private Object application;
    private final Boolean defaultAppInstance;
    private Object result;
    private boolean setResult = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    EclipseAppHandle(String instanceId, Map arguments, EclipseAppDescriptor descriptor) {
        super(instanceId, descriptor);
        this.defaultAppInstance = arguments == null || arguments.get("eclipse.application.default") == null ? Boolean.FALSE : (Boolean)arguments.remove("eclipse.application.default");
        this.arguments = arguments == null ? new HashMap(2) : new HashMap(arguments);
    }

    public synchronized String getState() {
        switch (this.status) {
            case 1: {
                return STARTING;
            }
            case 2: {
                return "RUNNING";
            }
            case 4: {
                return "STOPPING";
            }
        }
        if (this.handleRegistration == null) {
            throw new IllegalStateException(NLS.bind((String)Messages.application_error_state_stopped, (Object)this.getInstanceId()));
        }
        return STOPPED;
    }

    protected void destroySpecific() {
        this.setAppStatus(4);
        IApplication app = this.getApplication();
        if (app != null) {
            app.stop();
        }
        this.setAppStatus(8);
    }

    synchronized void setServiceRegistration(ServiceRegistration sr) {
        this.handleRegistration = sr;
    }

    ServiceReference getServiceReference() {
        ServiceRegistration reg = this.handleRegistration;
        if (reg == null) {
            return null;
        }
        try {
            return reg.getReference();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    Dictionary getServiceProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>(6);
        ((Dictionary)props).put("service.pid", this.getInstanceId());
        ((Dictionary)props).put("application.state", this.getState());
        ((Dictionary)props).put("application.descriptor", this.getApplicationDescriptor().getApplicationId());
        ((Dictionary)props).put("eclipse.application.type", ((EclipseAppDescriptor)this.getApplicationDescriptor()).getThreadTypeString());
        if (this.defaultAppInstance.booleanValue()) {
            ((Dictionary)props).put("eclipse.application.default", this.defaultAppInstance);
        }
        return props;
    }

    private synchronized void setAppStatus(int status) {
        if (this.status == status) {
            return;
        }
        if ((status & 1) != 0) {
            throw new IllegalArgumentException("Cannot set app status to ACTIVE");
        }
        if ((status & 4) != 0 && (this.status & 0xC) != 0) {
            return;
        }
        this.status = status;
        if (this.handleRegistration == null) {
            return;
        }
        this.handleRegistration.setProperties(this.getServiceProperties());
        if ((this.status & 8) != 0) {
            ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().unlock(this);
            this.handleRegistration.unregister();
            this.handleRegistration = null;
        }
    }

    public Map getArguments() {
        return this.arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(Object context) throws Exception {
        int exitCode;
        Object tempResult;
        block20: {
            if (context != null) {
                this.arguments.put("application.args", context);
            } else {
                context = this.arguments.get("application.args");
                if (context == null) {
                    context = CommandLineArgs.getApplicationArgs();
                    this.arguments.put("application.args", context);
                }
            }
            tempResult = null;
            try {
                Object app;
                EclipseAppHandle eclipseAppHandle = this;
                synchronized (eclipseAppHandle) {
                    app = this.application = this.getConfiguration().createExecutableExtension("run");
                }
                if (app instanceof IApplication) {
                    tempResult = ((IApplication)app).start(this);
                    break block20;
                }
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                tempResult = EclipseAppContainer.callMethod(app, "run", classArray, new Object[]{context});
            }
            catch (Throwable throwable) {
                EclipseAppHandle eclipseAppHandle = this;
                synchronized (eclipseAppHandle) {
                    this.result = tempResult;
                    this.setResult = true;
                    this.application = null;
                    this.notify();
                    this.setAppStatus(8);
                }
                throw throwable;
            }
        }
        EclipseAppHandle eclipseAppHandle = this;
        synchronized (eclipseAppHandle) {
            this.result = tempResult;
            this.setResult = true;
            this.application = null;
            this.notify();
            this.setAppStatus(8);
        }
        int n = exitCode = this.result instanceof Integer ? (Integer)this.result : 0;
        if (this.isDefault()) {
            System.getProperties().setProperty(PROP_ECLIPSE_EXITCODE, Integer.toString(exitCode));
        }
        if (Activator.DEBUG) {
            System.out.println(NLS.bind((String)Messages.application_returned, (Object[])new String[]{this.getApplicationDescriptor().getApplicationId(), this.result == null ? "null" : this.result.toString()}));
        }
        return this.result;
    }

    public void stop() {
        try {
            this.destroy();
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void applicationRunning() {
        this.setAppStatus(2);
        final ServiceReference[] monitors = this.getStartupMonitors();
        if (monitors == null) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
            }

            public void run() throws Exception {
                int i = 0;
                while (i < monitors.length) {
                    StartupMonitor monitor = (StartupMonitor)Activator.getContext().getService(monitors[i]);
                    if (monitor != null) {
                        monitor.applicationRunning();
                        Activator.getContext().ungetService(monitors[i]);
                    }
                    ++i;
                }
            }
        });
    }

    private ServiceReference[] getStartupMonitors() {
        ServiceReference[] refs = null;
        try {
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.osgi.service.runnable.StartupMonitor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            refs = bundleContext.getServiceReferences(clazz.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (refs == null || refs.length == 0) {
            return null;
        }
        Arrays.sort(refs, new Comparator(){

            public int compare(Object o1, Object o2) {
                int rank2;
                ServiceReference ref1 = (ServiceReference)o1;
                ServiceReference ref2 = (ServiceReference)o2;
                Object property = ref1.getProperty("service.ranking");
                int rank1 = property instanceof Integer ? (Integer)property : 0;
                property = ref2.getProperty("service.ranking");
                int n = rank2 = property instanceof Integer ? (Integer)property : 0;
                if (rank1 != rank2) {
                    return rank1 > rank2 ? -1 : 1;
                }
                long id1 = (Long)ref1.getProperty("service.id");
                long id2 = (Long)ref2.getProperty("service.id");
                return id2 > id1 ? -1 : 1;
            }
        });
        return refs;
    }

    private synchronized IApplication getApplication() {
        return (IApplication)(this.application instanceof IApplication ? this.application : null);
    }

    private IConfigurationElement getConfiguration() {
        IExtension applicationExtension = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getAppExtension(this.getApplicationDescriptor().getApplicationId());
        if (applicationExtension == null) {
            throw new RuntimeException(NLS.bind((String)Messages.application_notFound, (Object)this.getApplicationDescriptor().getApplicationId(), (Object)((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getAvailableAppsMsg()));
        }
        IConfigurationElement[] configs = applicationExtension.getConfigurationElements();
        if (configs.length == 0) {
            throw new RuntimeException(NLS.bind((String)Messages.application_invalidExtension, (Object)this.getApplicationDescriptor().getApplicationId()));
        }
        return configs[0];
    }

    public String getBrandingApplication() {
        IBranding branding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return branding == null ? null : branding.getApplication();
    }

    public Bundle getBrandingBundle() {
        IBranding branding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return branding == null ? null : branding.getDefiningBundle();
    }

    public String getBrandingDescription() {
        IBranding branding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return branding == null ? null : branding.getDescription();
    }

    public String getBrandingId() {
        IBranding branding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return branding == null ? null : branding.getId();
    }

    public String getBrandingName() {
        IBranding branding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return branding == null ? null : branding.getName();
    }

    public String getBrandingProperty(String key) {
        IBranding branding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return branding == null ? null : branding.getProperty(key);
    }

    boolean isDefault() {
        return this.defaultAppInstance;
    }

    synchronized Object waitForResult(int timeout) {
        if (!this.setResult) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.result;
    }
}

