/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.xmlcli.builder;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import jp.sourceforge.talisman.xmlcli.OptionsBuilder;
import jp.sourceforge.talisman.xmlcli.builder.SaxOptionsBuilder;

public class OptionsBuilderFactory {
    private static OptionsBuilderFactory factory;

    private OptionsBuilderFactory() {
    }

    public static OptionsBuilderFactory getInstance() {
        if (factory == null) {
            factory = new OptionsBuilderFactory();
        }
        return factory;
    }

    public OptionsBuilder createBuilder(File file) throws IOException {
        return this.createBuilder(new FileInputStream(file));
    }

    public OptionsBuilder createBuilder(URL url) throws IOException {
        return this.createBuilder(url.openStream());
    }

    public OptionsBuilder createBuilder(String string) throws IOException {
        return this.createBuilder(new ByteArrayInputStream(string.getBytes()));
    }

    public OptionsBuilder createBuilder(InputStream in) {
        return new SaxOptionsBuilder(in);
    }

    public OptionsBuilder createBuilder(String type, File file) throws IOException {
        return this.createBuilder(type, new FileInputStream(file));
    }

    public OptionsBuilder createBuilder(String type, URL url) throws IOException {
        return this.createBuilder(type, url.openStream());
    }

    public OptionsBuilder createBuilder(String type, String string) throws IOException {
        return this.createBuilder(type, new ByteArrayInputStream(string.getBytes()));
    }

    public OptionsBuilder createBuilder(String type, InputStream in) {
        return new SaxOptionsBuilder(in);
    }
}

