/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.cluster;

import jp.sourceforge.talisman.mds.CalculationFailException;
import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.cluster.Cluster;
import jp.sourceforge.talisman.mds.cluster.ClusteringMethod;
import jp.sourceforge.talisman.mds.cluster.ClusteringParameter;
import jp.sourceforge.talisman.mds.cluster.InvalidParameterException;
import jp.sourceforge.talisman.mds.distance.ItemDistanceCalculator;

public abstract class AbstractClusteringMethod
implements ClusteringMethod {
    private ClusteringParameter param;

    public AbstractClusteringMethod(ClusteringParameter param) {
        this.param = param;
        if (param == null) {
            throw new NullPointerException();
        }
    }

    public ItemDistanceCalculator getDistanceCalculator() {
        return this.param.getDistanceCalculator();
    }

    public final Cluster[] clustering(Item[] items) throws CalculationFailException {
        return this.clustering(items, this.param);
    }

    public final Cluster[] clustering(Item[] items, ClusteringParameter param) throws CalculationFailException {
        if (!param.isValid(items)) {
            throw new InvalidParameterException(param.toString());
        }
        return this.doClustering(items, param);
    }

    protected abstract Cluster[] doClustering(Item[] var1, ClusteringParameter var2);
}

