/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import jp.sourceforge.talisman.csvio.CsvLine;
import jp.sourceforge.talisman.csvio.CsvParser;
import jp.sourceforge.talisman.mds.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdsTableParser {
    public CsvParser parser;
    private boolean header = true;

    public MdsTableParser(CsvParser parser) {
        this.parser = parser;
    }

    public MdsTableParser(InputStream in) {
        this(new InputStreamReader(in));
    }

    public MdsTableParser(Reader in) {
        this(new CsvParser(new BufferedReader(in)));
    }

    public boolean hasHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public Table<String> parse() throws IOException {
        CsvLine[] lines = this.parser.getAllLines();
        Table<String> table = new Table<String>();
        String[] names = null;
        int index = 0;
        if (this.hasHeader()) {
            index = 1;
            names = lines[0].getValues();
        }
        for (int i = index; i < lines.length; ++i) {
            int j;
            String[] values = lines[i].getValues();
            if (this.hasHeader()) {
                for (j = 1; j < values.length; ++j) {
                    if (values[j].trim().equals("")) continue;
                    table.addValue(values[0], names[j], new Double(values[j]));
                }
                continue;
            }
            for (j = 0; j < values.length; ++j) {
                if (values[j].trim().equals("")) continue;
                table.addValue(String.valueOf(i), String.valueOf(j), new Double(values[j]));
            }
        }
        return table;
    }
}

