/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import jp.sourceforge.talisman.i18n.MessageManager;
import jp.sourceforge.talisman.i18n.Messages;
import jp.sourceforge.talisman.i18n.ResourceNotFoundException;
import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.MdsMethod;
import jp.sourceforge.talisman.mds.Table;
import jp.sourceforge.talisman.mds.io.MdsTableParser;
import jp.sourceforge.talisman.mds.ui.MdsGraphSetting;
import jp.sourceforge.talisman.mds.ui.swing.CurrentDirectoryHandler;
import jp.sourceforge.talisman.mds.ui.swing.ItemsOpenEvent;
import jp.sourceforge.talisman.mds.ui.swing.ItemsOpenListener;
import jp.sourceforge.talisman.mds.ui.swing.MdsPane;
import jp.sourceforge.talisman.mds.ui.swing.actions.AntiClockwiseRotateAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.ClearAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.ClockwiseRotateAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.ClusteringAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.HorizontalFlipAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.ShowItemsAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.ShowRelationDataAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.StoreItemsAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.StoreMdsImageAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.VerticalFlipAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.ZoomEnabler;
import jp.sourceforge.talisman.mds.ui.swing.actions.ZoomInAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.ZoomOutAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdsViewerPane
extends JPanel
implements CurrentDirectoryHandler,
ZoomEnabler,
MessageManager {
    private static final long serialVersionUID = -2182628098288103652L;
    private static final int[] ZOOM_PATTERN = new int[]{30, 40, 50, 75, 100, 125, 150, 200, 300, 400};
    private MdsMethod<?> mds;
    private MdsPane mdspane;
    private MdsGraphSetting setting;
    private Messages messages;
    private int currentZoomPattern = 4;
    private boolean userInputtedValue = false;
    private JTextField zoomRatio;
    private ZoomInAction zoomin;
    private ZoomOutAction zoomout;
    private JScrollPane scroll;
    private File currentDirectory;

    public MdsViewerPane(MdsMethod<?> mds) throws ResourceNotFoundException {
        this(mds, new MdsGraphSetting());
    }

    public MdsViewerPane(MdsMethod<?> mds, MdsGraphSetting setting) throws ResourceNotFoundException {
        this(mds, setting, new Messages("jp.sourceforge.talisman.mds.ui.MdsViewerPane"));
    }

    public MdsViewerPane(MdsMethod<?> mds, MdsGraphSetting setting, Messages messages) throws ResourceNotFoundException {
        this.setMessages(messages);
        this.setMdsMethod(mds);
        this.setSetting(setting);
        this.initLayout();
        this.initListeners();
    }

    public Item[] getSelectedItems() {
        return this.mdspane.getSelectedItems();
    }

    public Item[] getItems() {
        return this.mdspane.getItems();
    }

    public void setMdsMethod(MdsMethod<?> mds) {
        if (mds == null) {
            throw new NullPointerException();
        }
        this.mds = mds;
        if (this.mdspane != null) {
            this.mdspane.setMdsMethod(mds);
        }
    }

    public void setMessages(Messages messages) throws ResourceNotFoundException {
        if (messages == null) {
            throw new ResourceNotFoundException();
        }
        this.messages = messages;
        if (this.mdspane != null) {
            this.mdspane.setMessages(messages);
        }
    }

    @Override
    public Messages getMessages() {
        return this.messages;
    }

    public MdsMethod<?> getMdsMethod() {
        return this.mds;
    }

    public void setSetting(MdsGraphSetting setting) {
        if (setting == null) {
            throw new NullPointerException();
        }
        this.setting = setting;
    }

    public MdsGraphSetting getSetting() {
        return this.setting;
    }

    @Override
    public void setCurrentDirectory(File directory) {
        this.currentDirectory = directory;
    }

    @Override
    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    @Override
    public void zoomIn() {
        ++this.currentZoomPattern;
        this.userInputtedValue = false;
        this.zoom(ZOOM_PATTERN[this.currentZoomPattern]);
    }

    @Override
    public void zoomOut() {
        if (!this.userInputtedValue) {
            --this.currentZoomPattern;
        }
        this.userInputtedValue = false;
        this.zoom(ZOOM_PATTERN[this.currentZoomPattern]);
    }

    @Override
    public void zoom(int ratio) {
        for (int i = 0; i < ZOOM_PATTERN.length; ++i) {
            if (ratio > ZOOM_PATTERN[i]) continue;
            this.currentZoomPattern = i;
            break;
        }
        if (this.userInputtedValue && ratio < ZOOM_PATTERN[0]) {
            this.currentZoomPattern = -1;
        }
        if (this.userInputtedValue && ratio > ZOOM_PATTERN[ZOOM_PATTERN.length - 1]) {
            this.currentZoomPattern = ZOOM_PATTERN.length - 1;
        }
        this.zoomin.setEnabled(this.currentZoomPattern < ZOOM_PATTERN.length - 1);
        this.zoomout.setEnabled(this.currentZoomPattern != 0);
        this.zoomRatio.setText(ratio + " %");
        this.mdspane.setZoomRatio(ratio);
    }

    private void initLayout() throws ResourceNotFoundException {
        this.setLayout(new BorderLayout());
        this.mdspane = new MdsPane(this.getMdsMethod(), this.getSetting(), this.messages);
        JToolBar toolbar = new JToolBar();
        toolbar.add(new ClockwiseRotateAction(this.mdspane));
        toolbar.add(new AntiClockwiseRotateAction(this.mdspane));
        toolbar.add(new HorizontalFlipAction(this.mdspane));
        toolbar.add(new VerticalFlipAction(this.mdspane));
        this.zoomin = new ZoomInAction(this, this);
        toolbar.add(this.zoomin);
        this.zoomout = new ZoomOutAction(this, this);
        toolbar.add(this.zoomout);
        toolbar.add(new ClearAction(this.mdspane));
        this.zoomRatio = new JTextField("100%", 5);
        toolbar.add(this.zoomRatio);
        Box south = Box.createHorizontalBox();
        south.add(Box.createHorizontalGlue());
        south.add(new JButton(new ShowItemsAction(this.mdspane)));
        south.add(Box.createHorizontalGlue());
        south.add(new JButton(new ShowRelationDataAction(this.mdspane)));
        south.add(Box.createHorizontalGlue());
        south.add(new JButton(new StoreItemsAction(this)));
        south.add(Box.createHorizontalGlue());
        south.add(new JButton(new StoreMdsImageAction(this)));
        south.add(Box.createHorizontalGlue());
        south.add(new JButton(new ClusteringAction(this.mdspane)));
        south.add(Box.createHorizontalGlue());
        this.scroll = new JScrollPane(22, 32);
        this.scroll.setViewportView(this.mdspane);
        this.add((Component)this.scroll, "Center");
        this.add((Component)toolbar, "North");
        this.add((Component)south, "South");
    }

    private void initListeners() {
        this.mdspane.addItemsOpenListener(new ItemsOpenListener(){

            public void itemOpened(ItemsOpenEvent e) {
                Item[] c = e.getItems();
                StringBuilder sb = new StringBuilder("<html><body><ul>");
                for (int i = 0; i < c.length; ++i) {
                    sb.append("<li>").append(c[i].toString(3)).append("</li>");
                }
                sb.append("</ul></body></html>");
                if (MdsViewerPane.this.messages != null) {
                    JOptionPane.showMessageDialog(MdsViewerPane.this, new String(sb), MdsViewerPane.this.getMessages().get("selected.coordinates.title"), 1);
                }
            }
        });
        this.zoomRatio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String label = MdsViewerPane.this.zoomRatio.getText();
                    if (label.endsWith("%")) {
                        label = label.substring(0, label.lastIndexOf(37));
                    }
                    label = label.trim();
                    int ratio = Integer.parseInt(label);
                    MdsViewerPane.this.userInputtedValue = true;
                    MdsViewerPane.this.zoom(ratio);
                }
                catch (NumberFormatException exception) {
                    MdsViewerPane.this.zoomRatio.setText(MdsViewerPane.this.mdspane.getZoomRatio() + " %");
                }
            }
        });
    }

    public static void main(String[] args) throws Exception {
        Table<Object> table;
        if (args.length == 1) {
            MdsTableParser parser = new MdsTableParser(new FileReader(args[0]));
            table = parser.parse();
        } else {
            table = new Table<String>();
            table.addValue("Atlanta", "Chicago", 587);
            table.addValue("Atlanta", "Denver", 1212);
            table.addValue("Atlanta", "Houston", 701);
            table.addValue("Atlanta", "Los Angeles", 1936);
            table.addValue("Atlanta", "Miami", 604);
            table.addValue("Atlanta", "New York", 748);
            table.addValue("Atlanta", "San Francisco", 2139);
            table.addValue("Atlanta", "Seattle", 2182);
            table.addValue("Atlanta", "Washington D.C.", 543);
            table.addValue("Chicago", "Denver", 920);
            table.addValue("Chicago", "Houston", 940);
            table.addValue("Chicago", "Los Angeles", 1745);
            table.addValue("Chicago", "Miami", 1188);
            table.addValue("Chicago", "New York", 713);
            table.addValue("Chicago", "San Francisco", 1858);
            table.addValue("Chicago", "Seattle", 1737);
            table.addValue("Chicago", "Washington D.C.", 597);
            table.addValue("Denver", "Houston", 879);
            table.addValue("Denver", "Los Angeles", 831);
            table.addValue("Denver", "Miami", 1726);
            table.addValue("Denver", "New York", 1631);
            table.addValue("Denver", "San Francisco", 949);
            table.addValue("Denver", "Seattle", 1021);
            table.addValue("Denver", "Washington D.C.", 1494);
            table.addValue("Houston", "Los Angeles", 1374);
            table.addValue("Houston", "Miami", 968);
            table.addValue("Houston", "New York", 1420);
            table.addValue("Houston", "San Francisco", 1645);
            table.addValue("Houston", "Seattle", 1891);
            table.addValue("Houston", "Washington D.C.", 1220);
            table.addValue("Los Angeles", "Miami", 2339);
            table.addValue("Los Angeles", "New York", 2451);
            table.addValue("Los Angeles", "San Francisco", 347);
            table.addValue("Los Angeles", "Seattle", 959);
            table.addValue("Los Angeles", "Washington D.C.", 2300);
            table.addValue("Miami", "New York", 1092);
            table.addValue("Miami", "San Francisco", 2592);
            table.addValue("Miami", "Seattle", 2734);
            table.addValue("Miami", "Washington D.C.", 923);
            table.addValue("New York", "San Francisco", 2571);
            table.addValue("New York", "Seattle", 2408);
            table.addValue("New York", "Washington D.C.", 205);
            table.addValue("San Francisco", "Seattle", 678);
            table.addValue("San Francisco", "Washington D.C.", 2442);
            table.addValue("Seattle", "Washington D.C.", 2329);
        }
        MdsMethod mds = new MdsMethod(table);
        MdsViewerPane viewer = new MdsViewerPane(mds);
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add((Component)viewer, "Center");
        f.pack();
        f.setVisible(true);
    }
}

