/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.jexl.Script;
import org.apache.commons.jexl.ScriptImpl;
import org.apache.commons.jexl.parser.ASTJexlScript;
import org.apache.commons.jexl.parser.ParseException;
import org.apache.commons.jexl.parser.Parser;
import org.apache.commons.jexl.parser.SimpleNode;
import org.apache.commons.jexl.parser.TokenMgrError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptFactory {
    protected static Log log = LogFactory.getLog("org.apache.commons.jexl.ScriptFactory");
    protected static Parser parser = new Parser(new StringReader(";"));
    protected static ScriptFactory factory = new ScriptFactory();

    private ScriptFactory() {
    }

    protected static ScriptFactory getInstance() {
        return factory;
    }

    public static Script createScript(String scriptText) throws Exception {
        return ScriptFactory.getInstance().createNewScript(scriptText);
    }

    public static Script createScript(File scriptFile) throws Exception {
        if (scriptFile == null) {
            throw new NullPointerException("scriptFile is null");
        }
        if (!scriptFile.canRead()) {
            throw new IOException("Can't read scriptFile (" + scriptFile.getCanonicalPath() + ")");
        }
        BufferedReader reader = new BufferedReader(new FileReader(scriptFile));
        return ScriptFactory.createScript(ScriptFactory.readerToString(reader));
    }

    public static Script createScript(URL scriptUrl) throws Exception {
        if (scriptUrl == null) {
            throw new NullPointerException("scriptUrl is null");
        }
        URLConnection connection = scriptUrl.openConnection();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        return ScriptFactory.createScript(ScriptFactory.readerToString(reader));
    }

    protected Script createNewScript(String scriptText) throws Exception {
        SimpleNode script;
        String cleanText = this.cleanScript(scriptText);
        Parser parser = ScriptFactory.parser;
        synchronized (parser) {
            log.debug("Parsing script: " + cleanText);
            try {
                script = ScriptFactory.parser.parse(new StringReader(cleanText));
            }
            catch (TokenMgrError tme) {
                throw new ParseException(tme.getMessage());
            }
        }
        if (script instanceof ASTJexlScript) {
            return new ScriptImpl(cleanText, (ASTJexlScript)script);
        }
        throw new IllegalStateException("Parsed script is not an ASTJexlScript");
    }

    private String cleanScript(String script) {
        String expr = script.trim();
        if (!expr.endsWith(";")) {
            expr = expr + ";";
        }
        return expr;
    }

    private static String readerToString(BufferedReader reader) throws IOException {
        String string;
        StringBuffer buffer = new StringBuffer();
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line).append('\n');
            }
            string = buffer.toString();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        return string;
    }
}

