//-*- Mode: C++ -*-
#ifndef _TEOPP_TEOANYIMAGE_H_
#define _TEOPP_TEOANYIMAGE_H_
extern "C++" {
  /* $B2hA|Am>N%/%i%9(B */
  class TeoAnyImage :protected TEOIMAGE {
  public:
    friend class TeoFile;
    TeoAnyImage();
    TeoAnyImage(const TeoAnyImage &);
    TeoAnyImage(int width, int height,
		int xoffset, int yoffset,
		int type, int bit, int plane);
    TeoAnyImage(const char *file_name, int num_of_frame=0);
    virtual ~TeoAnyImage();
  
    int Width()const;
    int Height()const;
    int Type()const;
    int Bit()const;
    int Plane()const;
    int Fsize()const;
  
    int Xoffset()const;
    int Yoffset()const;
    int Xstart()const;
    int Xend()const;
    int Ystart()const;
    int Yend()const;
    void *Data()const;

    void *Address(int x,int y,int p=0)const;

    virtual TeoAnyImage &operator=(const TeoAnyImage &image);
    virtual void Write(const char *file_name)const;

  protected:
    int *ref;

    virtual void MakeImage(int width, int height,
			   int xoffset, int yoffset,
			   int type, int bit, int plane);
  };
} // extern "C++"
// $B%$%s%i%$%s4X?t$NDj5A(B
#include <teopp/teoanyimage_inline.h>
#endif
