//-*- Mode: C++ -*-
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include "define.h"
#include "teopp.h"

#include "teopp/util.h"

template<>
TeoImage<TeoBin> Binarize(const TeoImage<TeoUint32> &xim,TeoUint32 th){
 TeoImage<TeoBin> ret(xim.Width(),xim.Height(),
		       xim.Xoffset(),xim.Yoffset(),xim.Plane());
  for(int y=ret.Ystart();y<=ret.Yend();y++)
    for(int x=ret.Xstart();x<=ret.Xend();x++)
      for(int p=0;p<ret.Plane();p++)
	if(xim(x,y,p) >= th) ret(x,y,p) = 1;
	else  ret(x,y,p) = 0;
  return ret;
}

template<>
TeoUint32 MaxPixel(const TeoImage<TeoUint32> &xim){
  TeoUint32 tmp,max = xim(xim.Xstart(),xim.Ystart(),0);
  for(int y=xim.Ystart();y<=xim.Yend();y++)
    for(int x=xim.Xstart();x<=xim.Xend();x++)
      for(int p=0;p<xim.Plane();p++){
	tmp = xim(x,y,p);
	if(tmp>max) max = tmp;
      }
  return max;
}

template<>
TeoUint32 MinPixel(const TeoImage<TeoUint32> &xim){
  TeoUint32 tmp,min = xim(xim.Xstart(),xim.Ystart(),0);
  for(int y=xim.Ystart();y<=xim.Yend();y++)
    for(int x=xim.Xstart();x<=xim.Xend();x++)
      for(int p=0;p<xim.Plane();p++){
	tmp = xim(x,y,p);
	if(tmp<min) min = tmp;
      }
  return min;
}

template<>
TeoImage<TeoFloat64> 
Range(const TeoImage<TeoUint32> &xim,
      TeoFloat64 smin, TeoFloat64 smax,
      TeoFloat64 dmin, TeoFloat64 dmax){
  TeoImage<TeoFloat64> ret(xim.Width(),xim.Height(),
			   xim.Xoffset(),xim.Yoffset(),xim.Plane());
  TeoFloat64 max,min;
  if(smax==smin) return ret;

  if(dmax>=dmin){
    max = dmax;
    min = dmin;
  } else {
    max = dmin;
    min = dmax;
  }

  TeoFloat64 step = (dmax-dmin)/(smax-smin);
  TeoFloat64 tmp;

  for(int y=xim.Ystart();y<=xim.Yend();y++)
    for(int x=xim.Xstart();x<=xim.Xend();x++)
      for(int p=0;p<xim.Plane();p++){
	tmp = (TeoFloat64(xim(x,y,p))-smin)*step + dmin;
	if(tmp>max) tmp = max;
	else if(tmp<min) tmp = min;
	ret(x,y,p) = tmp;
      }
  return ret;
}

template<>
TeoImage<TeoFloat64>
Convolution(const TeoImage<TeoUint32> &image,
	    const TeoImage<TeoFloat64> &mask){
  TeoImage<TeoFloat64> ret(image.Width() - (mask.Width() - 1),
			   image.Height() - (mask.Height() - 1),
			   image.Xoffset() - mask.Xoffset(),
			   image.Yoffset() - mask.Yoffset(),
			   image.Plane());
  for(int y=ret.Ystart();y<=ret.Yend();y++)
    for(int x=ret.Xstart();x<=ret.Xend();x++)
      for(int p=0;p<ret.Plane();p++){
	TeoFloat64 val=0.0;
	for(int my=mask.Ystart();my<=mask.Yend();my++)
	  for(int mx=mask.Xstart();mx<=mask.Xend();mx++)
	    val += mask(mx,my)*(TeoFloat64(image(x+mx,y+my,p)));
	ret(x,y,p) = val;
      }
  return ret;
}

template<>
TeoImage<TeoUint32> &operator|=(TeoImage<TeoUint32> &xim,
			    const TeoImage<TeoUint32> &yim){
  char *ptr1=(char *)xim.Data();
  char *ptr2=(char *)yim.Data();
  int size = xim.Fsize();
  for(int i=0;i<size;i++)
    *(ptr1++) |= *(ptr2++);
  return xim;
}

template<>
TeoImage<TeoUint32> &operator&=(TeoImage<TeoUint32> &xim,
			    const TeoImage<TeoUint32> &yim){
  char *ptr1=(char *)xim.Data();
  char *ptr2=(char *)yim.Data();
  int size = xim.Fsize();
  for(int i=0;i<size;i++)
    *(ptr1++) &= *(ptr2++);
  return xim;
}
template<>
TeoImage<TeoUint32> operator|(const TeoImage<TeoUint32> &xim,
			  const TeoImage<TeoUint32> &yim){
  TeoImage<TeoBin> ret(xim);
  char *ptr1=(char*)xim.Data();
  char *ptr2=(char*)yim.Data();
  char *ptr3=(char*)ret.Data();
  int size=xim.Fsize();
  for(int i=0;i<size;i++)
    *(ptr3++) = *(ptr1++) | *(ptr2++);
  return ret;
}
template<>
TeoImage<TeoUint32> operator&(const TeoImage<TeoUint32> &xim,
			  const TeoImage<TeoUint32> &yim){
  TeoImage<TeoBin> ret(xim);
  char *ptr1=(char*)xim.Data();
  char *ptr2=(char*)yim.Data();
  char *ptr3=(char*)ret.Data();
  int size=xim.Fsize();
  for(int i=0;i<size;i++)
    *(ptr3++) = *(ptr1++) & *(ptr2++);
  return ret;
}

template<>
TeoImage<TeoFloat64> operator*(const TeoImage<TeoUint32> &image,
			       TeoFloat64 val){
  TeoImage<TeoFloat64> ret(image.Width(),image.Height(),
			   image.Xoffset(),image.Yoffset(),image.Plane());
  for(int y=ret.Ystart();y<=ret.Yend();y++)
    for(int x=ret.Xstart();x<=ret.Xend();x++)
      for(int p=0;p<ret.Plane();p++)
	ret(x,y,p) = TeoFloat64(image(x,y,p)) * val;
  return ret;
}
template<>
TeoImage<TeoFloat64> operator/(const TeoImage<TeoUint32> &image,
			       TeoFloat64 val){
  TeoImage<TeoFloat64> ret(image.Width(),image.Height(),
			   image.Xoffset(),image.Yoffset(),image.Plane());
  for(int y=ret.Ystart();y<=ret.Yend();y++)
    for(int x=ret.Xstart();x<=ret.Xend();x++)
      for(int p=0;p<ret.Plane();p++)
	ret(x,y,p) = TeoFloat64(image(x,y,p)) / val;
  return ret;
}
