#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <define.h>
#include "teopp/teoanyimage.h"
#include "teopp/teosequence.h"
#include "teopp/teofile.h"
#include "teopp/error.h"

extern char TEO_ERROR_MESSAGE[];
TeoFile::Error::Error():TeoErr(TEO_ERROR_CODE,TEO_ERROR_MESSAGE,"TeoFile"){}

TeoFile::TeoFile(const char *fname)
  :teofile(NULL),ref(new int){
  (*ref) = 1;
  teofile = TeoOpenFile((char*)fname);
  if(teofile==NULL) throw Error();
}

TeoFile::TeoFile(const char *fname,
			int w,int h,int x,int y,
			int t,int b,int p,int f,
			int ec,const char *const *ev)
  :teofile(NULL),ref(new int){
  (*ref) = 1;
  teofile = TeoCreateFileWithUserExtension((char *)fname,
					   w,h,x,y,t,b,p,f,
					   ec,(char **)ev);
  if(teofile==NULL) throw Error();
}

TeoFile::TeoFile(const char *fname,const TeoFile &seq)
  :teofile(NULL),ref(new int){
  (*ref) = 1;
  teofile = TeoCreateFileWithUserExtension((char *)fname,
					   seq.Width(),seq.Height(),
					   seq.Xoffset(),seq.Yoffset(),
					   seq.Type(),seq.Bit(),
					   seq.Plane(),seq.Frame(),
					   seq.Extc(),seq.Extv());
  if(teofile==NULL) throw Error();
}

TeoFile::TeoFile(const char *fname,const TeoAnyImage &img,
			int fnum,int ec,const char *const *ev)
  :teofile(NULL),ref(new int){
  (*ref) = 1;
  teofile = TeoCreateFileWithUserExtension((char *)fname,
					   img.Width(),img.Height(),
					   img.Xoffset(),img.Yoffset(),
					   img.Type(),img.Bit(),
					   img.Plane(),fnum,
					   ec,(char **)ev);
  if(teofile==NULL) throw Error();
}

TeoFile::TeoFile(const char *fname,
			const TeoAnyImage &img,
			int ec,
			const char *const *ev)
  :teofile(NULL),ref(new int){
  (*ref) = 1;
  teofile = TeoCreateFileWithUserExtension((char *)fname,
					   img.Width(),img.Height(),
					   img.Xoffset(),img.Yoffset(),
					   img.Type(),img.Bit(),
					   img.Plane(),1,
					   ec,(char **)ev);
  if(teofile==NULL) throw Error();
}

TeoFile::~TeoFile(){
  if((--(*ref)) == 0){
    Close();
    delete ref;
  }
}

TeoFile &TeoFile::operator=(const TeoFile &seq){
  if((--(*ref)) == 0){
    Close();
    delete ref;
  }
  teofile = seq.teofile;
  ref = seq.ref;

  (*ref)++;
  return (*this);
}

TeoAnyImage TeoFile::GetImage(int fnum){
  if(fnum >= 0){
    if(!SetAbsFrame(fnum)) throw Error();
  }
  if(Current() >= Frame())
    return TeoAnyImage();

  TeoAnyImage img(Width(),Height(),Xoffset(),Yoffset(),Type(),Bit(),Plane());
  if(TeoReadFrame(teofile,(TEOIMAGE*)img)==0) throw Error();
  return img;
}

void TeoFile::PutImage(const TeoAnyImage &img,int fnum){
  if(fnum >= 0){
    if(Current() >= Frame())
      return;
    if(!SetAbsFrame(fnum)) throw Error();
  } else if(Current() >= Frame())
    return;
  if(TeoWriteFrame(teofile,(TEOIMAGE*)(img))==0) throw Error();
}
