/* ************************************************************ sample.c *** *
 * TEOʳβɤ߹TEOѴ륵ץץ
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-12-05 10:56:14 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <teo.h>
#include <teo2gdk-pixbuf.h>

/* ************************************************************************* */
int
main (int	argc,
      char	**argv) {
  TEOFILE	*teofp;
  TEOIMAGE	*img;
  GdkPixbuf	*pix;
  int		has_alpha;
  char		*extv[1] = {"hasAlphaPlane yes"};
  
  /* Υå */
  if (argc != 3) {
    fprintf (stderr, "Usage: %s in.jpg out.teo\n", argv[0]);
    exit (1);
  }
  /* ϲɤ߹ */
  pix = gdk_pixbuf_new_from_file (argv[1]);
  has_alpha = gdk_pixbuf_get_has_alpha (pix);
  
  /* ϲ */
  teofp = TeoCreateFileWithUserExtension (argv[2],
					  gdk_pixbuf_get_width (pix),
					  gdk_pixbuf_get_height(pix),
					  0, 0,
					  TEO_UNSIGNED, 8, 3+has_alpha, 1,
					  has_alpha,
					  (has_alpha) ? extv : NULL);
  img = teo2gdk_pixbuf_convert_to_teoimage (pix, has_alpha);
  TeoWriteFrame (teofp, img);

  TeoCloseFile (teofp);
  TeoFreeImage (img);
  gdk_pixbuf_unref (pix);
  
  return 0;
}

/* ***************************************************** End of sample.c *** */
