/* **************************************************** teo2gdk-pixbuf.h *** *
 * teogdk-pixbuf֤Ѵ饤֥ إåե
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA, <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-20 08:21:21 sugaya>
 * ************************************************************************* */
#ifndef	_TEO2GDK_PIXBUF_H_
#define	_TEO2GDK_PIXBUF_H_

#include <teo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

GdkPixbuf*
teo2gdk_pixbuf_new_from_file		(char			*filename,
					 int			frame,
					 TEO_FLOAT64		min,
					 TEO_FLOAT64		max,
					 int			has_alpha);

GdkPixbuf*
teo2gdk_pixbuf_new_from_teofile 	(TEOFILE		*teo,
					 int			frame,
					 TEO_FLOAT64		min,
					 TEO_FLOAT64		max,
					 int			has_alpha);

GdkPixbuf*
teo2gdk_pixbuf_new_from_teoimage	(TEOIMAGE		*img,
					 TEO_FLOAT64		min,
					 TEO_FLOAT64		max,
					 int			has_alpha);

void
teo2gdk_pixbuf_copy_to_pixbuf		(TEOIMAGE		*img,
					 GdkPixbuf		*pbuf,
					 double			min,
					 double			max,
					 int			has_alpha);

TEOIMAGE*
teo2gdk_pixbuf_convert_to_teoimage	(GdkPixbuf		*pix,
					 int			has_alpha);

#endif	/* _TEO2GDK_PIXBUF_H_ */

/* ********************************************* End of teo2gdk-pixbuf.h *** */
