/* ***************************************************** teo_composite.c *** *
 * ιؿ
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-10-10 00:01:02 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <teo.h>

/* Ʃطʲ ****************************************************** */
TEOIMAGE*
TeoCreateAlphaBackground (int		width,
			  int		height,
			  int		xoffset,
			  int		yoffset,
			  int		check_size,
			  unsigned int	color1,
			  unsigned int	color2) {
  TEOIMAGE	*dst;
  unsigned char	r[2], g[2], b[2];
  int		index, row, col;

  /* Ʃطʿγ */  
  r[0] = (color1 >> 16) & 0x0000ff;
  g[0] = (color1 >> 8) & 0x0000ff;  
  b[0] =  color1 & 0x0000ff;

  r[1] = (color2 >> 16) & 0x0000ff;
  g[1] = (color2 >> 8) & 0x0000ff;  
  b[1] =  color2 & 0x0000ff;

  /* ϲΰ */
  dst = TeoAllocImage (width, height, xoffset, yoffset, TEO_UNSIGNED, 8, 3);

  /* Ʃطʤ */
  for (row = TeoYstart (dst); row <= TeoYend (dst); row++) {
    for (col = TeoXstart (dst); col <= TeoXend (dst); col++) {
      index = ((int) (col / check_size) + (int) (row / check_size)) % 2;      
      TeoPutPixel (dst, col, row, 0, TEO_UINT8, r[index]);
      TeoPutPixel (dst, col, row, 1, TEO_UINT8, g[index]);
      TeoPutPixel (dst, col, row, 2, TEO_UINT8, b[index]);
    }
  }
  return dst;
}

/* ƩطʤȤι ********************************************** */
TEOIMAGE*
TeoCreateAlphaImage (TEOIMAGE		*src,
		     unsigned char	alpha,
		     int		check_size,
		     unsigned int	color1,
		     unsigned int	color2) {
  TEOIMAGE	*dst;
  unsigned char	r[2], g[2], b[2];
  unsigned char	br, bg, bb;
  unsigned char	alpha_;	  
  int		index, row, col;


  /* եץ졼󤬤ʤв⤷ʤ */
  if (TeoPlane (src) < 4) {
    fprintf (stderr, "Src img has not alpha plane.\n");
    return NULL;
  }

  /* Ʃطʿγ */
  r[0] = (color1 >> 16) & 0x0000ff;
  g[0] = (color1 >> 8) & 0x0000ff;  
  b[0] =  color1 & 0x0000ff;

  r[1] = (color2 >> 16) & 0x0000ff;
  g[1] = (color2 >> 8) & 0x0000ff;  
  b[1] =  color2 & 0x0000ff;

  /* ϲΰ */
  dst = TeoAllocImage (TeoWidth   (src), TeoHeight  (src),
		       TeoXoffset (src), TeoYoffset (src),
		       TEO_UNSIGNED, 8, 3);

  /* ͤ */
  alpha_ = 255 - alpha;

  /* Ʃطʤ */
  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      index = ((int) (col / check_size) + (int) (row / check_size)) % 2;      
      if (TeoGetPixel (src, col, row, 3, TEO_UINT8) != 0) {
	br = (TEO_UINT8)
	  ((TeoGetPixel (src, col, row, 0, TEO_UINT8) * alpha / 255) +
	   (r[index] * alpha_ / 255));
	bg = (TEO_UINT8)
	  ((TeoGetPixel (src, col, row, 1, TEO_UINT8) * alpha / 255) +
	   (g[index] * alpha_ / 255));
	bb = (TEO_UINT8)
	  ((TeoGetPixel (src, col, row, 2, TEO_UINT8) * alpha / 255) +
	   (b[index] * alpha_ / 255));
	TeoPutPixel (dst, col, row, 0, TEO_UINT8, br);
	TeoPutPixel (dst, col, row, 1, TEO_UINT8, bg);
	TeoPutPixel (dst, col, row, 2, TEO_UINT8, bb);
      } else {
	TeoPutPixel (dst, col, row, 0, TEO_UINT8, r[index]);
	TeoPutPixel (dst, col, row, 1, TEO_UINT8, g[index]);
	TeoPutPixel (dst, col, row, 2, TEO_UINT8, b[index]);
      }
    }
  }
  return dst;
}

/* ƩطʤȤι (ץ졼ν񤭹ߤ) ******************* */
TEOIMAGE*
TeoCreateAlphaImageWithMask (TEOIMAGE		*src,
			     unsigned char	alpha,
			     int		check_size,
			     unsigned int	color1,
			     unsigned int	color2) {
  TEOIMAGE	*dst;
  unsigned char	r[2], g[2], b[2];
  unsigned char	br, bg, bb;
  unsigned char	alpha_;
  int		index, row, col;

  /* եץ졼󤬤ʤв⤷ʤ */
  if (TeoPlane (src) < 4) {
    fprintf (stderr, "Src img has not alpha plane.\n");
    return NULL;
  }

  /* Ʃطʿγ */
  r[0] = (color1 >> 16) & 0x0000ff;
  g[0] = (color1 >> 8) & 0x0000ff;  
  b[0] =  color1 & 0x0000ff;

  r[1] = (color2 >> 16) & 0x0000ff;
  g[1] = (color2 >> 8) & 0x0000ff;  
  b[1] =  color2 & 0x0000ff;

  /* ϲΰ */  
  dst = TeoAllocImage (TeoWidth   (src), TeoHeight  (src),
		       TeoXoffset (src), TeoYoffset (src),
		       TEO_UNSIGNED, 8, 4);

  /* ͤ */
  alpha_ = 255 - alpha;

  /* Ʃطʤ */
  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      index = ((int) (col / check_size) + (int) (row / check_size)) % 2;      
      if (TeoGetPixel (src, col, row, 3, TEO_UINT8) != 0) {
	br = (TEO_UINT8)
	  ((TeoGetPixel (src, col, row, 0, TEO_UINT8) * alpha / 255) +
	   (r[index] * alpha_ / 255));
	bg = (TEO_UINT8)
	  ((TeoGetPixel (src, col, row, 1, TEO_UINT8) * alpha / 255) +
	   (g[index] * alpha_ / 255));
	bb = (TEO_UINT8)
	  ((TeoGetPixel (src, col, row, 2, TEO_UINT8) * alpha / 255) +
	   (b[index] * alpha_ / 255));
	TeoPutPixel (dst, col, row, 0, TEO_UINT8, br);
	TeoPutPixel (dst, col, row, 1, TEO_UINT8, bg);
	TeoPutPixel (dst, col, row, 2, TEO_UINT8, bb);
      } else {
	TeoPutPixel (dst, col, row, 0, TEO_UINT8, r[index]);
	TeoPutPixel (dst, col, row, 1, TEO_UINT8, g[index]);
	TeoPutPixel (dst, col, row, 2, TEO_UINT8, b[index]);
      }
      TeoPutPixel (dst, col, row, 3, TEO_UINT8,
		   TeoGetPixel (src, col, row, 3, TEO_UINT8));
    }
  }
  return dst;
}

/* Ʃطʲ ****************************************************** */
void
TeoAlphaBackground (TEOIMAGE		*dst,
		    int			check_size,
		    unsigned int	color1,
		    unsigned int	color2) {
  unsigned char	r[2], g[2], b[2];
  int		index, row, col;

  /* Ʃطʿγ */  
  r[0] = (color1 >> 16) & 0x0000ff;
  g[0] = (color1 >> 8) & 0x0000ff;  
  b[0] =  color1 & 0x0000ff;

  r[1] = (color2 >> 16) & 0x0000ff;
  g[1] = (color2 >> 8) & 0x0000ff;  
  b[1] =  color2 & 0x0000ff;

  /* Ʃطʤ */
  for (row = TeoYstart (dst); row <= TeoYend (dst); row++) {
    for (col = TeoXstart (dst); col <= TeoXend (dst); col++) {
      index = ((int) (col / check_size) + (int) (row / check_size)) % 2;      
      TeoPutPixel (dst, col, row, 0, TEO_UINT8, r[index]);
      TeoPutPixel (dst, col, row, 1, TEO_UINT8, g[index]);
      TeoPutPixel (dst, col, row, 2, TEO_UINT8, b[index]);
    }
  }
}

/* ƩطʤȤι ********************************************** */
void
TeoAlphaImage (TEOIMAGE		*src,
	       TEOIMAGE		*dst,
	       unsigned char	alpha,
	       int		check_size,
	       unsigned int	color1,
	       unsigned int	color2) {
  unsigned char	r[2], g[2], b[2];
  unsigned char	br, bg, bb;
  unsigned char	alpha_;  
  int		index, row, col;

  /* եץ졼󤬤ʤв⤷ʤ */
  if (TeoPlane (src) < 4) {
    fprintf (stderr, "Src img has not alpha plane.\n");
    return;
  }

  /* Ʃطʿγ */  
  r[0] = (color1 >> 16) & 0x0000ff;
  g[0] = (color1 >> 8) & 0x0000ff;  
  b[0] =  color1 & 0x0000ff;

  r[1] = (color2 >> 16) & 0x0000ff;
  g[1] = (color2 >> 8) & 0x0000ff;  
  b[1] =  color2 & 0x0000ff;

  /* ϲΰ */  
  dst = TeoAllocImage (TeoWidth   (src), TeoHeight  (src),
		       TeoXoffset (src), TeoYoffset (src),
		       TEO_UNSIGNED, 8, 3);

  /* ͤ */
  alpha_ = 255 - alpha;

  /* Ʃطʤ */
  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      index = ((int) (col / check_size) + (int) (row / check_size)) % 2;      
      if (TeoGetPixel (src, col, row, 3, TEO_UINT8) != 0) {
	br = (TEO_UINT8)
	  ((TeoGetPixel (src, col, row, 0, TEO_UINT8) * alpha / 255) +
	   (r[index] * alpha_ / 255));
	bg = (TEO_UINT8)
	  ((TeoGetPixel (src, col, row, 1, TEO_UINT8) * alpha / 255) +
	   (g[index] * alpha_ / 255));
	bb = (TEO_UINT8)
	  ((TeoGetPixel (src, col, row, 2, TEO_UINT8) * alpha / 255) +
	   (b[index] * alpha_ / 255));
	TeoPutPixel (dst, col, row, 0, TEO_UINT8, br);
	TeoPutPixel (dst, col, row, 1, TEO_UINT8, bg);
	TeoPutPixel (dst, col, row, 2, TEO_UINT8, bb);
      } else {
	TeoPutPixel (dst, col, row, 0, TEO_UINT8, r[index]);
	TeoPutPixel (dst, col, row, 1, TEO_UINT8, g[index]);
	TeoPutPixel (dst, col, row, 2, TEO_UINT8, b[index]);
      }
    }
  }
  return;
}

/* ƩطʤȤι (ץ졼ν񤭹ߤ) ******************* */
void
TeoAlphaImageWithMask (TEOIMAGE		*src,
		       TEOIMAGE		*dst,
		       unsigned char	alpha,
		       int		check_size,
		       unsigned int	color1,
		       unsigned int	color2) {
  unsigned char	r[2], g[2], b[2];
  unsigned char	br, bg, bb;
  unsigned char	alpha_;  
  int		index, row, col;


  /* եץ졼󤬤ʤв⤷ʤ */
  if (TeoPlane (src) < 4) {
    fprintf (stderr, "Src img has not alpha plane.\n");
    return;
  }
  if (TeoPlane (dst) < 4) {
    fprintf (stderr, "Dst img has not alpha plane.\n");
    return;
  }

  /* Ʃطʿγ */  
  r[0] = (color1 >> 16) & 0x0000ff;
  g[0] = (color1 >> 8) & 0x0000ff;  
  b[0] =  color1 & 0x0000ff;

  r[1] = (color2 >> 16) & 0x0000ff;
  g[1] = (color2 >> 8) & 0x0000ff;  
  b[1] =  color2 & 0x0000ff;

  /* ͤ */
  alpha_ = 255 - alpha;

  /* Ʃطʤ */
  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      index = ((int) (col / check_size) + (int) (row / check_size)) % 2;      
      if (TeoGetPixel (src, col, row, 3, TEO_UINT8) != 0) {
	br = (TEO_UINT8)
	  ((TeoGetPixel (src, col, row, 0, TEO_UINT8) * alpha / 255) +
	   (r[index] * alpha_ / 255));
	bg = (TEO_UINT8)
	  ((TeoGetPixel (src, col, row, 1, TEO_UINT8) * alpha / 255) +
	   (g[index] * alpha_ / 255));
	bb = (TEO_UINT8)
	  ((TeoGetPixel (src, col, row, 2, TEO_UINT8) * alpha / 255) +
	   (b[index] * alpha_ / 255));
	TeoPutPixel (dst, col, row, 0, TEO_UINT8, br);
	TeoPutPixel (dst, col, row, 1, TEO_UINT8, bg);
	TeoPutPixel (dst, col, row, 2, TEO_UINT8, bb);
      } else {
	TeoPutPixel (dst, col, row, 0, TEO_UINT8, r[index]);
	TeoPutPixel (dst, col, row, 1, TEO_UINT8, g[index]);
	TeoPutPixel (dst, col, row, 2, TEO_UINT8, b[index]);
      }
      TeoPutPixel (dst, col, row, 3, TEO_UINT8,
		   TeoGetPixel (src, col, row, 3, TEO_UINT8));
    }
  }
  return;
}

/* ι ************************************************************** */
void
TeoCompositeImage (TEOIMAGE		*src,
		   TEOIMAGE		*dst,
		   int			offset_x,
		   int			offset_y,
		   int			has_alpha,
		   unsigned char	alpha) {
  unsigned char	r[2], g[2], b[2];
  unsigned char	br, bg, bb;
  unsigned char	alpha_;  
  int		index, row, col;
  int		x, y;
  
  /* ͤ */
  alpha_ = 255 - alpha;
  
  /* եåȤη׻ */
  offset_x = offset_x + TeoXoffset (dst) - TeoXoffset (src);
  offset_y = offset_y + TeoYoffset (dst) - TeoYoffset (src);

  /*  */
  if (has_alpha && TeoPlane (src) > 3) {
    for (row = TeoYstart (src); row <= TeoYend (src); row++) {
      for (col = TeoXstart (src); col <= TeoXend (src); col++) {
	if (TeoGetPixel (src, col, row, 3, TEO_UINT8) == 0) continue;
	x = col + offset_x;
	y = row + offset_y;
	if (x >= TeoXstart (dst) && x <= TeoXend (dst) &&
	    y >= TeoYstart (dst) && y <= TeoYend (dst)) {

	  br = (TEO_UINT8)
	    ((TeoGetPixel (src, col, row, 0, TEO_UINT8) * alpha / 255) +
	     (TeoGetPixel (dst, x, y, 0, TEO_UINT8) * alpha_ / 255));
	  bg = (TEO_UINT8)
	    ((TeoGetPixel (src, col, row, 1, TEO_UINT8) * alpha / 255) +
	     (TeoGetPixel (dst, x, y, 1, TEO_UINT8) * alpha_ / 255));
	  bb = (TEO_UINT8)
	    ((TeoGetPixel (src, col, row, 2, TEO_UINT8) * alpha / 255) +
	     (TeoGetPixel (dst, x, y, 2, TEO_UINT8) * alpha_ / 255));

	  TeoPutPixel (dst, x, y, 0, TEO_UINT8, br);
	  TeoPutPixel (dst, x, y, 1, TEO_UINT8, bg);
	  TeoPutPixel (dst, x, y, 2, TEO_UINT8, bb);
	}
      }
    }
  } else {
    for (row = TeoYstart (src); row <= TeoYend (src); row++) {
      for (col = TeoXstart (src); col <= TeoXend (src); col++) {
	x = col + offset_x;
	y = row + offset_y;
	if (x >= TeoXstart (dst) && x <= TeoXend (dst) &&
	    y >= TeoYstart (dst) && y <= TeoYend (dst)) {

	  br = (TEO_UINT8)
	    ((TeoGetPixel (src, col, row, 0, TEO_UINT8) * alpha / 255) +
	     (TeoGetPixel (dst, x, y, 0, TEO_UINT8) * alpha_ / 255));
	  bg = (TEO_UINT8)
	    ((TeoGetPixel (src, col, row, 1, TEO_UINT8) * alpha / 255) +
	     (TeoGetPixel (dst, x, y, 1, TEO_UINT8) * alpha_ / 255));
	  bb = (TEO_UINT8)
	    ((TeoGetPixel (src, col, row, 2, TEO_UINT8) * alpha / 255) +
	     (TeoGetPixel (dst, x, y, 2, TEO_UINT8) * alpha_ / 255));

	  TeoPutPixel (dst, x, y, 0, TEO_UINT8, br);
	  TeoPutPixel (dst, x, y, 1, TEO_UINT8, bg);
	  TeoPutPixel (dst, x, y, 2, TEO_UINT8, bb);
	}
      }
    }
  }
}

/* ********************************************** End of teo_composite.c *** */
