/* ********************************************************* teo_range.h *** *
 * This library is a auxiliary teo library
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-09-14 22:49:15 sugaya>
 * ************************************************************************* */
#ifndef _TEO_RANGE_H_
#define _TEO_RANGE_H_

int	TeoCheckRangeFile		(TEOFILE	*teo, 
					 int 		col,
					 int 		row);

int	TeoCheckRangeImage 		(TEOIMAGE	*teo, 
					 int		col,
					 int 		row);

void	B_TeoGetPixelRange 		(TEOIMAGE 	*img,
					 double 	*min,
					 double 	*max);

void	U_TeoGetPixelRange		(TEOIMAGE 	*img,
					 double 	*min,
					 double 	*max);

void	S_TeoGetPixelRange 		(TEOIMAGE 	*img,
					 double 	*min,
					 double 	*max);

void	F_TeoGetPixelRange		(TEOIMAGE 	*img,
					 double 	*min,
					 double 	*max);

void 	TeoGetPixelRange		(TEOIMAGE 	*img,
					 double 	*min,
					 double 	*max);

void	B_TeoGetPixelRangePlane		(TEOIMAGE	*img,
					 int		p,
					 double 	*min,
					 double 	*max);

void	U_TeoGetPixelRangePlane 	(TEOIMAGE 	*img,
					 int 		p,
					 double 	*min,
					 double 	*max);

void 	S_TeoGetPixelRangePlane 	(TEOIMAGE 	*img,
					 int 		p,
					 double 	*min,
					 double 	*max);

void	F_TeoGetPixelRangePlane 	(TEOIMAGE 	*img,
					 int 		p,
					 double 	*min,
					 double 	*max);

void 	TeoGetPixelRangePlane 		(TEOIMAGE 	*img,
					 int 		p,
					 double 	*min,
					 double 	*max);

#endif	/* _TEO_RANGE_H_ */

/* ************************************************** End of teo_range.h *** */
