/* ====================================================== */
/*  $B2hAGCM$N7?$r5$$K$;$:(B get/put$B$G$-$k%k!<%A%s(B            */
/*                                            Y.Mukaigaw  */
/* ====================================================== */

#include <stdio.h>
#include <stdlib.h>
#include <teo.h>

TEO_FLOAT64 TeoUtilGetAnyPixel(TEOIMAGE *image, int x, int y, int p){

  if (TeoType(image)==TEO_UNSIGNED){
    switch(TeoBit(image)){
    case 8:
      return (TEO_FLOAT64)TeoGetPixel(image, x, y, p, TEO_UINT8);
    case 16:
      return (TEO_FLOAT64)TeoGetPixel(image, x, y, p, TEO_UINT16);
    case 32:
      return (TEO_FLOAT64)TeoGetPixel(image, x, y, p, TEO_UINT32);
    }
  }
  else if (TeoType(image)==TEO_FLOAT){
    switch(TeoBit(image)){
    case 32:
      return (TEO_FLOAT64)TeoGetPixel(image, x, y, p, TEO_FLOAT32);
    case 64:
      return (TEO_FLOAT64)TeoGetPixel(image, x, y, p, TEO_FLOAT64);
    }
  }
  else if (TeoType(image)==TEO_SIGNED){
    switch(TeoBit(image)){
    case 8:
      return (TEO_FLOAT64)TeoGetPixel(image, x, y, p, TEO_SINT8);
    case 16:
      return (TEO_FLOAT64)TeoGetPixel(image, x, y, p, TEO_SINT16);
    case 32:
      return (TEO_FLOAT64)TeoGetPixel(image, x, y, p, TEO_SINT32);
    }
  }
  
  if (TeoBit(image)==1) return (TEO_FLOAT64)TeoGetBit(image, x, y, p);

  fprintf(stderr,"ERROR: Wrong pixel type\n");
  exit(-1);

  return (TEO_FLOAT64)0; /* dummy */
}

TEO_FLOAT64 TeoUtilPutAnyPixel(TEOIMAGE *image, int x, int y, int p,
			       TEO_FLOAT64 val){

  if (TeoType(image)==TEO_UNSIGNED){
    switch(TeoBit(image)){
    case 8:
      return (TEO_FLOAT64)TeoPutPixel(image, x, y, p, TEO_UINT8, val);
    case 16:
      return (TEO_FLOAT64)TeoPutPixel(image, x, y, p, TEO_UINT16, val);
    case 32:
      return (TEO_FLOAT64)TeoPutPixel(image, x, y, p, TEO_UINT32, val);
    }
  }
  else if (TeoType(image)==TEO_FLOAT){
    switch(TeoBit(image)){
    case 32:
      return (TEO_FLOAT64)TeoPutPixel(image, x, y, p, TEO_FLOAT32, val);
    case 64:
      return (TEO_FLOAT64)TeoPutPixel(image, x, y, p, TEO_FLOAT64, val);
    }
  }
  else if (TeoType(image)==TEO_SIGNED){
    switch(TeoBit(image)){
    case 8:
      return (TEO_FLOAT64)TeoPutPixel(image, x, y, p, TEO_SINT8, val);
    case 16:
      return (TEO_FLOAT64)TeoPutPixel(image, x, y, p, TEO_SINT16, val);
    case 32:
      return (TEO_FLOAT64)TeoPutPixel(image, x, y, p, TEO_SINT32, val);
    }
  }

  if (TeoBit(image)==1) return (TEO_FLOAT64)TeoPutBit(image, x, y, p, val);

  fprintf(stderr,"ERROR: Wrong pixel type\n");
  exit(-1);

  return (TEO_FLOAT64)0; /* dummy */
}
