#include <stdio.h>
#include <string.h>
#include <teo.h>

static int TeoUtilCopyImageWithCastFromBITToBIT(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutBit(image2,i,j,p,TeoGetBit(image1,i,j,p));
  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT8ToBIT(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutBit(image2,i,j,p,
		  (TeoGetPixel(image1,i,j,p,TEO_UINT8) == 0)? 0:1);
  return 1;
}

static int TeoUtilCopyImageWithCastFromBITToUINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutPixel(image2,i,j,p,TEO_UINT8,
		    (TEO_UINT8)TeoGetBit(image1,i,j,p));
  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT8ToBIT(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutBit(image2,i,j,p,
		  (TeoGetPixel(image1,i,j,p,TEO_SINT8) == 0)? 0:1);
  return 1;
}

static int TeoUtilCopyImageWithCastFromBITToSINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutPixel(image2,i,j,p,TEO_SINT8,
		    (TEO_SINT8)TeoGetBit(image1,i,j,p));
  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT16ToBIT(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutBit(image2,i,j,p,
		  (TeoGetPixel(image1,i,j,p,TEO_UINT16) == 0)? 0:1);
  return 1;
}

static int TeoUtilCopyImageWithCastFromBITToUINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutPixel(image2,i,j,p,TEO_UINT16,
		    (TEO_UINT16)TeoGetBit(image1,i,j,p));
  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT16ToBIT(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutBit(image2,i,j,p,
		  (TeoGetPixel(image1,i,j,p,TEO_SINT16) == 0)? 0:1);
  return 1;
}

static int TeoUtilCopyImageWithCastFromBITToSINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutPixel(image2,i,j,p,TEO_SINT16,
		    (TEO_SINT16)TeoGetBit(image1,i,j,p));
  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT32ToBIT(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutBit(image2,i,j,p,
		  (TeoGetPixel(image1,i,j,p,TEO_UINT32) == 0)? 0:1);
  return 1;
}

static int TeoUtilCopyImageWithCastFromBITToUINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutPixel(image2,i,j,p,TEO_UINT32,
		    (TEO_UINT32)TeoGetBit(image1,i,j,p));
  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT32ToBIT(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutBit(image2,i,j,p,
		  (TeoGetPixel(image1,i,j,p,TEO_SINT32) == 0)? 0:1);
  return 1;
}

static int TeoUtilCopyImageWithCastFromBITToSINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutPixel(image2,i,j,p,TEO_SINT32,
		    (TEO_SINT32)TeoGetBit(image1,i,j,p));
  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT32ToBIT(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutBit(image2,i,j,p,
		  (TeoGetPixel(image1,i,j,p,TEO_FLOAT32) == 0)? 0:1);
  return 1;
}

static int TeoUtilCopyImageWithCastFromBITToFLOAT32(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutPixel(image2,i,j,p,TEO_FLOAT32,
		    (TEO_FLOAT32)TeoGetBit(image1,i,j,p));
  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT64ToBIT(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutBit(image2,i,j,p,
		  (TeoGetPixel(image1,i,j,p,TEO_FLOAT64) == 0)? 0:1);
  return 1;
}

static int TeoUtilCopyImageWithCastFromBITToFLOAT64(TEOIMAGE *image1,TEOIMAGE *image2){
  int i,j,p;

  for(j=TeoYstart(image1);j<=TeoYend(image2);j++)
    for(i=TeoXstart(image1);i<=TeoXend(image2);i++)
      for(p=0;p<TeoPlane(image1);p++)
	TeoPutPixel(image2,i,j,p,TEO_FLOAT64,
		    (TEO_FLOAT64)TeoGetBit(image1,i,j,p));
  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT8ToUINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT8 *p1;
  TEO_UINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT8ToSINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT8 *p1;
  TEO_SINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT8ToUINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT8 *p1;
  TEO_UINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT8ToSINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT8 *p1;
  TEO_SINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT8ToUINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT8 *p1;
  TEO_UINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT8ToSINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT8 *p1;
  TEO_SINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT8ToFLOAT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT8 *p1;
  TEO_FLOAT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT8ToFLOAT64(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT8 *p1;
  TEO_FLOAT64 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT64)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT8ToUINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT8 *p1;
  TEO_UINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT8ToSINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT8 *p1;
  TEO_SINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT8ToUINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT8 *p1;
  TEO_UINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT8ToSINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT8 *p1;
  TEO_SINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT8ToUINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT8 *p1;
  TEO_UINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT8ToSINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT8 *p1;
  TEO_SINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT8ToFLOAT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT8 *p1;
  TEO_FLOAT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT8ToFLOAT64(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT8 *p1;
  TEO_FLOAT64 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT64)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT16ToUINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT16 *p1;
  TEO_UINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT16ToSINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT16 *p1;
  TEO_SINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT16ToUINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT16 *p1;
  TEO_UINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT16ToSINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT16 *p1;
  TEO_SINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT16ToUINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT16 *p1;
  TEO_UINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT16ToSINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT16 *p1;
  TEO_SINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT16ToFLOAT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT16 *p1;
  TEO_FLOAT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT16ToFLOAT64(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT16 *p1;
  TEO_FLOAT64 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT64)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT16ToUINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT16 *p1;
  TEO_UINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT16ToSINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT16 *p1;
  TEO_SINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT16ToUINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT16 *p1;
  TEO_UINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT16ToSINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT16 *p1;
  TEO_SINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT16ToUINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT16 *p1;
  TEO_UINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT16ToSINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT16 *p1;
  TEO_SINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT16ToFLOAT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT16 *p1;
  TEO_FLOAT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT16ToFLOAT64(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT16 *p1;
  TEO_FLOAT64 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT64)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT32ToUINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT32 *p1;
  TEO_UINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT32ToSINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT32 *p1;
  TEO_SINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT32ToUINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT32 *p1;
  TEO_UINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT32ToSINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT32 *p1;
  TEO_SINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT32ToUINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT32 *p1;
  TEO_UINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT32ToSINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT32 *p1;
  TEO_SINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT32ToFLOAT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT32 *p1;
  TEO_FLOAT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromUINT32ToFLOAT64(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_UINT32 *p1;
  TEO_FLOAT64 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT64)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT32ToUINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT32 *p1;
  TEO_UINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT32ToSINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT32 *p1;
  TEO_SINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT32ToUINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT32 *p1;
  TEO_UINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT32ToSINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT32 *p1;
  TEO_SINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT32ToUINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT32 *p1;
  TEO_UINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT32ToSINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT32 *p1;
  TEO_SINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT32ToFLOAT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT32 *p1;
  TEO_FLOAT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromSINT32ToFLOAT64(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_SINT32 *p1;
  TEO_FLOAT64 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT64)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT32ToUINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT32 *p1;
  TEO_UINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT32ToSINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT32 *p1;
  TEO_SINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT32ToUINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT32 *p1;
  TEO_UINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT32ToSINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT32 *p1;
  TEO_SINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT32ToUINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT32 *p1;
  TEO_UINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT32ToSINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT32 *p1;
  TEO_SINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT32ToFLOAT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT32 *p1;
  TEO_FLOAT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT32ToFLOAT64(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT32 *p1;
  TEO_FLOAT64 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT64)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT64ToUINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT64 *p1;
  TEO_UINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT64ToSINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT64 *p1;
  TEO_SINT8 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT8)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT64ToUINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT64 *p1;
  TEO_UINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT64ToSINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT64 *p1;
  TEO_SINT16 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT16)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT64ToUINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT64 *p1;
  TEO_UINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_UINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT64ToSINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT64 *p1;
  TEO_SINT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_SINT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT64ToFLOAT32(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT64 *p1;
  TEO_FLOAT32 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT32)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastFromFLOAT64ToFLOAT64(TEOIMAGE *image1,TEOIMAGE *image2){
  TEO_FLOAT64 *p1;
  TEO_FLOAT64 *p2;
  int i,size;

  p1 = TeoData(image1);
  p2 = TeoData(image2);

  size = TeoWidth(image1) * TeoHeight(image1) * TeoPlane(image1);

  for(i=0;i<size;i++)
    *(p2++) = (TEO_FLOAT64)(*(p1++));

  return 1;
}

static int TeoUtilCopyImageWithCastToBIT(TEOIMAGE *image1,TEOIMAGE *image2){
  switch(TeoBit(image1)){
  case 1:
    return TeoUtilCopyImageWithCastFromBITToBIT(image1,image2);
    break;
  case 8:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT8ToBIT(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT8ToBIT(image1,image2);
    break;
  case 16:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT16ToBIT(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT16ToBIT(image1,image2);
    break;
  case 32:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT32ToBIT(image1,image2);
    else if(TeoType(image1) == TEO_SIGNED)
      return TeoUtilCopyImageWithCastFromSINT32ToBIT(image1,image2);
    else 
      return TeoUtilCopyImageWithCastFromFLOAT32ToBIT(image1,image2);
    break;
  case 64:
    return TeoUtilCopyImageWithCastFromFLOAT64ToBIT(image1,image2);
    break;
  default:
    return 0;
    break;
  }
}
static int TeoUtilCopyImageWithCastToUINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  switch(TeoBit(image1)){
  case 1:
    return TeoUtilCopyImageWithCastFromBITToUINT8(image1,image2);
    break;
  case 8:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT8ToUINT8(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT8ToUINT8(image1,image2);
    break;
  case 16:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT16ToUINT8(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT16ToUINT8(image1,image2);
    break;
  case 32:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT32ToUINT8(image1,image2);
    else if(TeoType(image1) == TEO_SIGNED)
      return TeoUtilCopyImageWithCastFromSINT32ToUINT8(image1,image2);
    else 
      return TeoUtilCopyImageWithCastFromFLOAT32ToUINT8(image1,image2);
    break;
  case 64:
    return TeoUtilCopyImageWithCastFromFLOAT64ToUINT8(image1,image2);
    break;
  default:
    return 0;
    break;
  }
}
static int TeoUtilCopyImageWithCastToSINT8(TEOIMAGE *image1,TEOIMAGE *image2){
  switch(TeoBit(image1)){
  case 1:
    return TeoUtilCopyImageWithCastFromBITToSINT8(image1,image2);
    break;
  case 8:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT8ToSINT8(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT8ToSINT8(image1,image2);
    break;
  case 16:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT16ToSINT8(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT16ToSINT8(image1,image2);
    break;
  case 32:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT32ToSINT8(image1,image2);
    else if(TeoType(image1) == TEO_SIGNED)
      return TeoUtilCopyImageWithCastFromSINT32ToSINT8(image1,image2);
    else 
      return TeoUtilCopyImageWithCastFromFLOAT32ToSINT8(image1,image2);
    break;
  case 64:
    return TeoUtilCopyImageWithCastFromFLOAT64ToSINT8(image1,image2);
    break;
  default:
    return 0;
    break;
  }
}
static int TeoUtilCopyImageWithCastToUINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  switch(TeoBit(image1)){
  case 1:
    return TeoUtilCopyImageWithCastFromBITToUINT16(image1,image2);
    break;
  case 8:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT8ToUINT16(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT8ToUINT16(image1,image2);
    break;
  case 16:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT16ToUINT16(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT16ToUINT16(image1,image2);
    break;
  case 32:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT32ToUINT16(image1,image2);
    else if(TeoType(image1) == TEO_SIGNED)
      return TeoUtilCopyImageWithCastFromSINT32ToUINT16(image1,image2);
    else 
      return TeoUtilCopyImageWithCastFromFLOAT32ToUINT16(image1,image2);
    break;
  case 64:
    return TeoUtilCopyImageWithCastFromFLOAT64ToUINT16(image1,image2);
    break;
  default:
    return 0;
    break;
  }
}
static int TeoUtilCopyImageWithCastToSINT16(TEOIMAGE *image1,TEOIMAGE *image2){
  switch(TeoBit(image1)){
  case 1:
    return TeoUtilCopyImageWithCastFromBITToSINT16(image1,image2);
    break;
  case 8:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT8ToSINT16(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT8ToSINT16(image1,image2);
    break;
  case 16:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT16ToSINT16(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT16ToSINT16(image1,image2);
    break;
  case 32:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT32ToSINT16(image1,image2);
    else if(TeoType(image1) == TEO_SIGNED)
      return TeoUtilCopyImageWithCastFromSINT32ToSINT16(image1,image2);
    else 
      return TeoUtilCopyImageWithCastFromFLOAT32ToSINT16(image1,image2);
    break;
  case 64:
    return TeoUtilCopyImageWithCastFromFLOAT64ToSINT16(image1,image2);
    break;
  default:
    return 0;
    break;
  }
}
static int TeoUtilCopyImageWithCastToUINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  switch(TeoBit(image1)){
  case 1:
    return TeoUtilCopyImageWithCastFromBITToUINT32(image1,image2);
    break;
  case 8:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT8ToUINT32(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT8ToUINT32(image1,image2);
    break;
  case 16:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT16ToUINT32(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT16ToUINT32(image1,image2);
    break;
  case 32:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT32ToUINT32(image1,image2);
    else if(TeoType(image1) == TEO_SIGNED)
      return TeoUtilCopyImageWithCastFromSINT32ToUINT32(image1,image2);
    else 
      return TeoUtilCopyImageWithCastFromFLOAT32ToUINT32(image1,image2);
    break;
  case 64:
    return TeoUtilCopyImageWithCastFromFLOAT64ToUINT32(image1,image2);
    break;
  default:
    return 0;
    break;
  }
}
static int TeoUtilCopyImageWithCastToSINT32(TEOIMAGE *image1,TEOIMAGE *image2){
  switch(TeoBit(image1)){
  case 1:
    return TeoUtilCopyImageWithCastFromBITToSINT32(image1,image2);
    break;
  case 8:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT8ToSINT32(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT8ToSINT32(image1,image2);
    break;
  case 16:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT16ToSINT32(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT16ToSINT32(image1,image2);
    break;
  case 32:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT32ToSINT32(image1,image2);
    else if(TeoType(image1) == TEO_SIGNED)
      return TeoUtilCopyImageWithCastFromSINT32ToSINT32(image1,image2);
    else 
      return TeoUtilCopyImageWithCastFromFLOAT32ToSINT32(image1,image2);
    break;
  case 64:
    return TeoUtilCopyImageWithCastFromFLOAT64ToSINT32(image1,image2);
    break;
  default:
    return 0;
    break;
  }
}
static int TeoUtilCopyImageWithCastToFLOAT32(TEOIMAGE *image1,TEOIMAGE *image2){
  switch(TeoBit(image1)){
  case 1:
    return TeoUtilCopyImageWithCastFromBITToFLOAT32(image1,image2);
    break;
  case 8:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT8ToFLOAT32(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT8ToFLOAT32(image1,image2);
    break;
  case 16:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT16ToFLOAT32(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT16ToFLOAT32(image1,image2);
    break;
  case 32:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT32ToFLOAT32(image1,image2);
    else if(TeoType(image1) == TEO_SIGNED)
      return TeoUtilCopyImageWithCastFromSINT32ToFLOAT32(image1,image2);
    else 
      return TeoUtilCopyImageWithCastFromFLOAT32ToFLOAT32(image1,image2);
    break;
  case 64:
    return TeoUtilCopyImageWithCastFromFLOAT64ToFLOAT32(image1,image2);
    break;
  default:
    return 0;
    break;
  }
}
static int TeoUtilCopyImageWithCastToFLOAT64(TEOIMAGE *image1,TEOIMAGE *image2){
  switch(TeoBit(image1)){
  case 1:
    return TeoUtilCopyImageWithCastFromBITToFLOAT64(image1,image2);
    break;
  case 8:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT8ToFLOAT64(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT8ToFLOAT64(image1,image2);
    break;
  case 16:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT16ToFLOAT64(image1,image2);
    else
      return TeoUtilCopyImageWithCastFromSINT16ToFLOAT64(image1,image2);
    break;
  case 32:
    if(TeoType(image1) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastFromUINT32ToFLOAT64(image1,image2);
    else if(TeoType(image1) == TEO_SIGNED)
      return TeoUtilCopyImageWithCastFromSINT32ToFLOAT64(image1,image2);
    else 
      return TeoUtilCopyImageWithCastFromFLOAT32ToFLOAT64(image1,image2);
    break;
  case 64:
    return TeoUtilCopyImageWithCastFromFLOAT64ToFLOAT64(image1,image2);
    break;
  default:
    return 0;
    break;
  }
}

int TeoUtilCopyImageWithCast(TEOIMAGE *src,TEOIMAGE *dst){
  if( ( TeoWidth(src) != TeoWidth(dst) ) ||
      ( TeoHeight(src) != TeoHeight(dst) ) ||
      ( TeoXoffset(src) != TeoXoffset(dst) ) ||
      ( TeoYoffset(src) != TeoYoffset(dst) ) ||
      ( TeoPlane(src) != TeoPlane(dst) ) ) return 0;

  if( ( ( TeoType(src) == TeoType(dst) ) &&
	( TeoBit(src) == TeoBit(dst) ) ) ) {
    memcpy(TeoData(dst),TeoData(src),TeoFsize(src));
    return 1;
  }
  switch(TeoBit(dst)){
  case 1:
    if(TeoBit(src) == 1) {
      memcpy(TeoData(dst),TeoData(src),TeoFsize(src));
      return 1;
    }
    return TeoUtilCopyImageWithCastToBIT(src,dst);
    break;
  case 8:
    if(TeoType(dst) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastToUINT8(src,dst);
    else
      return TeoUtilCopyImageWithCastToSINT8(src,dst);
    break;
  case 16:
    if(TeoType(dst) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastToUINT16(src,dst);
    else
      return TeoUtilCopyImageWithCastToSINT16(src,dst);
    break;
  case 32:
    if(TeoType(dst) == TEO_UNSIGNED)
      return TeoUtilCopyImageWithCastToUINT32(src,dst);
    else if(TeoType(dst) == TEO_SIGNED)
      return TeoUtilCopyImageWithCastToSINT32(src,dst);
    else 
      return TeoUtilCopyImageWithCastToFLOAT32(src,dst);
    break;
  case 64:
    return TeoUtilCopyImageWithCastToFLOAT64(src,dst);
    break;
  default:
    return 0;
    break;
  }
}
