#include <teo.h>

/*--< $B%^%/%m(B >--*/

#define TeoUtilIsInner(img,x,y)\
 (((x) < TeoXstart(img) || TeoXend(img) < (x) || \
   (y) < TeoYstart(img) || TeoYend(img) < (y)   ) ? 0 : 1 )

/*--< $B%W%m%H%?%$%W@k8@(B >--*/

/* color.c */
TEOIMAGE *TeoUtilGray2Binary(TEOIMAGE *img);
TEOIMAGE *TeoUtilRGB2Gray(TEOIMAGE *img);
TEOIMAGE *TeoUtilBinary2Gray(TEOIMAGE *img);
TEOIMAGE *TeoUtilGray2RGB(TEOIMAGE *img);
TEOIMAGE *TeoUtilRGB2HSV(TEOIMAGE *img);
TEOIMAGE *TeoUtilRGB2YCrCb(TEOIMAGE *img);

/* textureMapping.c */
void TeoUtilTextureMapping_UINT8(TEOIMAGE *in,TEOIMAGE *out,
        int ix1, int iy1, int ix2, int iy2, int ix3, int iy3,
        int ox1, int oy1, int ox2, int oy2, int ox3, int oy3);
void TeoUtilTextureMappingWithAlpha_UINT8(
	TEOIMAGE *in,TEOIMAGE *out,float alpha,
	int ix1, int iy1, int ix2, int iy2, int ix3, int iy3,
	int ox1, int oy1, int ox2, int oy2, int ox3, int oy3);

/* copyarea.c */
int TeoUtilCopyArea(TEOIMAGE *src, TEOIMAGE *dst,
        int src_x, int src_y, int width, int height, int dst_x, int dst_y);

/* copyimagewithcast.c */
int TeoUtilCopyImageWithCast(TEOIMAGE *src,TEOIMAGE *dst);

/* linearpixel.c */
float TeoUtilLinearPixel_UINT8(TEOIMAGE *img, float x, float y, int plane);
TEO_FLOAT64 TeoUtilLinearPixel(TEOIMAGE *img, float x, float y, int plane);

/* anyPixel.c */
TEO_FLOAT64 TeoUtilGetAnyPixel(TEOIMAGE *image, int x, int y, int p);
TEO_FLOAT64 TeoUtilPutAnyPixel(TEOIMAGE *image, int x, int y, int p,
			       TEO_FLOAT64 val);

/* fileio.c */
TEOIMAGE *TeoUtilMallocReadFromImage(char *filename);
void TeoUtilCreateFileFromImage(char *filename, TEOIMAGE *img);

/* numerical.c */
double TeoUtilInnerProduct(TEOIMAGE *img1,TEOIMAGE *img2);
double TeoUtilInnerProduct_FLOAT64(TEOIMAGE *img1,TEOIMAGE *img2);
double TeoUtilCalcSum(TEOIMAGE *img, int plane);
double TeoUtilCalcVariance(TEOIMAGE *img, int plane);
double TeoUtilCalcL2Norm(TEOIMAGE *img, int plane);
void TeoUtilNormalizeWithoutAlloc(TEOIMAGE *src, TEOIMAGE *dst, int flag);
TEOIMAGE *TeoUtilNormalize(TEOIMAGE *src, int flag);
double TeoUtilCalcMax(TEOIMAGE *img, int plane);
double TeoUtilCalcMin(TEOIMAGE *img, int plane);


/* misc.c */
void TeoUtilCheckImage(TEOIMAGE *img, int width, int height,
		       int xoffset, int yoffset, int type, int bit, int plane);

void TeoUtilCheckFile(TEOFILE *file, int width, int height,
		      int xoffset, int yoffset, int type,
		      int bit, int plane, int frame);

/* draw.c */
void TeoUtilDrawPoint_UINT8(TEOIMAGE *img, int x, int y, TEO_UINT8 *color);
void TeoUtilDrawLine_UINT8(TEOIMAGE *img, int x1, int y1,
			   int x2, int y2, TEO_UINT8 *color);
void TeoUtilDrawRectangle_UINT8(TEOIMAGE *img, int x, int y,
				int width, int height,TEO_UINT8 *color);
void TeoUtilDrawFillRectangle_UINT8(TEOIMAGE *img, int x, int y,
				    int width, int height,TEO_UINT8 *color);
void TeoUtilDrawCircle_UINT8(TEOIMAGE *img, int x, int y, int r,
			     TEO_UINT8 *color);
void TeoUtilDrawFillCircle_UINT8(TEOIMAGE *img, int x, int y, int r,
				 TEO_UINT8 *color);

void TeoUtilDrawPointClipping_UINT8(TEOIMAGE *img, int x, int y,
				    TEO_UINT8 *color);
void TeoUtilDrawLineClipping_UINT8(TEOIMAGE *img, int x1, int y1,
			   int x2, int y2, TEO_UINT8 *color);
void TeoUtilDrawRectangleClipping_UINT8(TEOIMAGE *img, int x, int y,
				int width, int height,TEO_UINT8 *color);
void TeoUtilDrawFillRectangleClipping_UINT8(TEOIMAGE *img, int x, int y,
				    int width, int height,TEO_UINT8 *color);
void TeoUtilDrawCircleClipping_UINT8(TEOIMAGE *img, int x, int y, int r,
			     TEO_UINT8 *color);
void TeoUtilDrawFillCircleClipping_UINT8(TEOIMAGE *img, int x, int y, int r,
				 TEO_UINT8 *color);

/* draw+.c */
void TeoUtilDrawPointWithAlpha_UINT8 (TEOIMAGE *img, int x, int y,
				      unsigned char alpha, TEO_UINT8 *color);
void TeoUtilDrawLines_UINT8 (TEOIMAGE *img, int *data, int pnum,
			     TEO_UINT8 *color);
void TeoUtilDrawSegments_UINT8 (TEOIMAGE *img, int *data, int pnum,
				TEO_UINT8 *color);
void TeoUtilDrawFillRectangleWithAlpha_UINT8 (TEOIMAGE *img, int x, int	y,
					      int width, int height,
					      unsigned char alpha,
					      TEO_UINT8 *color); 
void TeoUtilDrawFillCircleWithAlpha_UINT8 (TEOIMAGE *img, int x, int y, int r,
					   unsigned char alpha,
					   TEO_UINT8 *color);
void TeoUtilDrawArc_UINT8 (TEOIMAGE *img, int x0, int y0, int xl, int yl,
			   double theta, TEO_UINT8 *color);
void TeoUtilDrawFillArc_UINT8 (TEOIMAGE *img, int x0, int y0, int xl, int yl,
			       double theta, TEO_UINT8 *color);
void TeoUtilDrawFillArcWithAlpha_UINT8 (TEOIMAGE *img, int x0, int y0, int xl,
					int yl, double theta,
					unsigned char alpha, TEO_UINT8 *color);
void TeoUtilDrawPointWithAlphaClipping_UINT8 (TEOIMAGE *img, int x, int y,
				      unsigned char alpha, TEO_UINT8 *color);
void TeoUtilDrawLinesClipping_UINT8 (TEOIMAGE *img, int *data, int pnum,
			     TEO_UINT8 *color);
void TeoUtilDrawSegmentsClipping_UINT8 (TEOIMAGE *img, int *data, int pnum,
				TEO_UINT8 *color);
void TeoUtilDrawFillRectangleWithAlphaClipping_UINT8 (TEOIMAGE *img, int x,
						      int y, int width,
						      int height,
						      unsigned char alpha,
						      TEO_UINT8 *color); 
void TeoUtilDrawFillCircleWithAlphaClipping_UINT8 (TEOIMAGE *img, int x, int y,
						   int r, unsigned char alpha,
						   TEO_UINT8 *color);
void TeoUtilDrawArcClipping_UINT8 (TEOIMAGE *img, int x0, int y0, int xl,
				   int yl, double theta, TEO_UINT8 *color);
void TeoUtilDrawFillArcClipping_UINT8 (TEOIMAGE *img, int x0, int y0, int xl,
				       int yl, double theta, TEO_UINT8 *color);
void TeoUtilDrawFillArcWithAlphaClipping_UINT8 (TEOIMAGE *img, int x0, int y0,
						int xl, int yl, double theta,
						unsigned char alpha,
						TEO_UINT8 *color);

