#include <stdio.h>
#include <stdlib.h>
#include <teopp.h>

void usage(char *pname){
  fprintf(stderr,"usage: %s pixel-type bits [teofile]\n",pname);
  exit(-1);
}

int main(int argc,char **argv){
  char type;
  int bit;
  TeoFile input;
  if(argc<3) usage(argv[0]);
  bit = atoi(argv[2]);

  if(bit != 1 && bit != 8 &&
     bit != 16 && bit != 32 &&
     bit != 64) usage(argv[0]);

  switch(argv[1][0]){
  case 'S':
    if(bit == 64) usage(argv[0]);
    type = TEO_SIGNED;
    break;
  case 'U':
    if(bit == 64) usage(argv[0]);
    type = TEO_UNSIGNED;
    break;
  case 'F':
    if(bit == 16) usage(argv[0]);
    type = TEO_FLOAT;
    break;
  default:
    usage(argv[0]);
    break;
  }
  if(argc<4) input = TeoFile("-");
  else input = TeoFile(argv[3]);

  TeoFile output("-",
		 input.Width(),input.Height(),
		 input.Xoffset(),input.Yoffset(),
		 type,bit,
		 input.Plane(),input.Frame());
  for(int f=0;f<input.Frame();f++){
    switch(bit){
    case 1:
      output.PutImage(TeoImage<TeoBin>(input.GetImage()));
      break;
    case 8:
      if(type == TEO_SIGNED)
	output.PutImage(TeoImage<TeoSint8>(input.GetImage()));
      else if(type == TEO_UNSIGNED)
	output.PutImage(TeoImage<TeoUint8>(input.GetImage()));
      else usage(argv[0]);
      break;
    case 16:
      if(type == TEO_SIGNED)
	output.PutImage(TeoImage<TeoSint16>(input.GetImage()));
      else if(type == TEO_UNSIGNED)
	output.PutImage(TeoImage<TeoUint16>(input.GetImage()));
      else usage(argv[0]);
      break;
    case 32:
      if(type == TEO_SIGNED)
	output.PutImage(TeoImage<TeoSint32>(input.GetImage()));
      else if(type == TEO_UNSIGNED)
	output.PutImage(TeoImage<TeoUint32>(input.GetImage()));
      else 
	output.PutImage(TeoImage<TeoFloat32>(input.GetImage()));
      break;
    case 64:
      output.PutImage(TeoImage<TeoFloat64>(input.GetImage()));
      break;
    default:
      break;
    }
  }
  return 0;
}
