/* ************************************************ gtkiconitemfactory.h *** *
 * GtkIconItemFactory ヘッダファイル
 *
 * Copyright (C) 2002-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/01/13 21:43:19 sugaya>
 *
 * GTK - The GIMP Toolkit Copyright (C) 1995-1997 Peter Mattis,
 * Spencer Kimball and Josh MacDonald
 *
 * GtkItemFactory: Flexible item factory with automatic rc handling
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 * ************************************************************************* */
#ifndef __GTK_ICON_ITEM_FACTORY_H__
#define	__GTK_ICON_ITEM_FACTORY_H__

#include <gtk/gtkwidget.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


  typedef void	(*GtkIconPrintFunc)	   (gpointer		 func_data,
					    const gchar		*str);
  typedef gchar * (*GtkIconTranslateFunc)   (const gchar	*path,
					     gpointer 		func_data);
  typedef void	(*GtkIconItemFactoryCallback)  ();
  typedef void	(*GtkIconItemFactoryCallback1) (gpointer	callback_data,
						guint	callback_action,
						GtkWidget	*widget);

#define GTK_TYPE_ICON_ITEM_FACTORY            (gtk_icon_item_factory_get_type ())
#define GTK_ICON_ITEM_FACTORY(object)         (GTK_CHECK_CAST ((object), GTK_TYPE_ICON_ITEM_FACTORY, GtkIconItemFactory))
#define GTK_ICON_ITEM_FACTORY_CLASS(class)    (GTK_CHECK_CLASS_CAST ((class), GTK_TYPE_ICON_ITEM_FACTORY, GtkIconItemFactoryClass))
#define GTK_IS_ICON_ITEM_FACTORY(object)      (GTK_CHECK_TYPE ((object), GTK_TYPE_ICON_ITEM_FACTORY))
#define GTK_IS_ICON_ITEM_FACTORY_CLASS(class) (GTK_CHECK_CLASS_TYPE ((class), GTK_TYPE_ICON_ITEM_FACTORY))
#define GTK_ICON_ITEM_FACTORY_GET_CLASS(obj)  (GTK_CHECK_GET_CLASS ((obj), GTK_TYPE_ICON_ITEM_FACTORY, GtkIconItemFactoryClass))

typedef	struct	_GtkIconItemFactory		GtkIconItemFactory;
typedef	struct	_GtkIconItemFactoryClass	GtkIconItemFactoryClass;
typedef	struct	_GtkIconItemFactoryEntry	GtkIconItemFactoryEntry;
typedef	struct	_GtkIconItemFactoryItem		GtkIconItemFactoryItem;

  struct _GtkIconItemFactory {
    GtkObject		 object;
    gchar		*path;
    GtkAccelGroup	*accel_group;
    GtkWidget		*widget;
    GSList		*items;
    GtkTranslateFunc	translate_func;
    gpointer		translate_data;
    GtkDestroyNotify	translate_notify;   
  };

  struct _GtkIconItemFactoryClass
  {
    GtkObjectClass	 object_class;

    GHashTable		*item_ht;

    /* Padding for future expansion */
    void (*_gtk_reserved1) (void);
    void (*_gtk_reserved2) (void);
    void (*_gtk_reserved3) (void);
    void (*_gtk_reserved4) (void);
  };

  struct _GtkIconItemFactoryEntry {
    gchar		*path;
    gchar 		*accelerator;

    GtkIconItemFactoryCallback callback;
    guint		 callback_action;

    /* possible values:
     * NULL		-> "<Item>"
     * ""		-> "<Item>"
     * "<Title>"	-> create a title item
     * "<Item>"		-> create a simple item
     * "<ImageItem>"	-> create an item holding an image
     * "<StockItem>"	-> create an item holding a stock image
     * "<CheckItem>"	-> create a check item
     * "<ToggleItem>"	-> create a toggle item
     * "<RadioItem>"	-> create a radio item
     * <path>		-> path of a radio item to link against
     * "<Separator>"	-> create a separator
     * "<Tearoff>"	-> create a tearoff separator
     * "<Branch>"	-> create an item to hold sub items
     * "<LastBranch>"	-> create a right justified item to hold sub items
     *
     * "<iTitle>"	-> create a title item
     * "<iCheckItem>"	-> create a check item
     * "<iToggleItem>"	-> create a toggle item
     * "<iRadioItem>"	-> create a radio item
     * "<iBranch>"	-> create an item to hold sub items
     * "<iLastBranch>"	-> create a right justified item to hold sub items
     *
     * "<sTitle>"	-> create a title item
     * "<sCheckItem>"	-> create a check item
     * "<sToggleItem>"	-> create a toggle item
     * "<sRadioItem>"	-> create a radio item
     * "<sBranch>"	-> create an item to hold sub items
     * "<sLastBranch>"	-> create a right justified item to hold sub items
     */
    gchar		 *item_type;

    /* Extra data for some item types:
     *  ImageItem  -> pointer to inlined pixbuf stream
     *  StockItem  -> name of stock item
     */
    gconstpointer extra_data;
  };

  struct _GtkIconItemFactoryItem {
    gchar 		*path;
    GSList 		*widgets;
};

  GtkType	gtk_icon_item_factory_get_type	    (void) G_GNUC_CONST;
/*
 * `container_type' must be of GTK_TYPE_MENU_BAR, GTK_TYPE_MENU,
 * or GTK_TYPE_OPTION_MENU.
 */
GtkIconItemFactory*
gtk_icon_item_factory_new		(GtkType		container_type,
					 const gchar		*path,
					 GtkAccelGroup		*accel_group);
void gtk_icon_item_factory_construct	(GtkIconItemFactory	*ifactory,
					 GtkType		container_type,
					 const gchar		*path,
					 GtkAccelGroup       	*accel_group);
/*
 * These functions operate on GtkIconItemFactoryClass basis.
 */
void gtk_icon_item_factory_add_foreign	(GtkWidget		*accel_widget,
					 const gchar    	*full_path,
					 GtkAccelGroup  	*accel_group,
					 guint	     		keyval,
					 GdkModifierType 	modifiers);
     
GtkIconItemFactory*
gtk_icon_item_factory_from_widget	(GtkWidget		*widget);
G_CONST_RETURN gchar*
gtk_icon_item_factory_path_from_widget	(GtkWidget	 	*widget);

GtkWidget*
gtk_icon_item_factory_get_item	      	(GtkIconItemFactory	*ifactory,
					 const gchar    	*path);
GtkWidget*
gtk_icon_item_factory_get_widget	(GtkIconItemFactory 	*ifactory,
					 const gchar    	*path);
GtkWidget*
gtk_icon_item_factory_get_widget_by_action (GtkIconItemFactory	*ifactory,
					    guint	       	action);
GtkWidget*
gtk_icon_item_factory_get_item_by_action   (GtkIconItemFactory 	*ifactory,
					    guint	       	action);

void
gtk_icon_item_factory_create_item	(GtkIconItemFactory	*ifactory,
					 GtkIconItemFactoryEntry	*entry,
					 gpointer	 	callback_data,
					 guint		 	callback_type);
void
gtk_icon_item_factory_create_items	(GtkIconItemFactory	*ifactory,
					 guint			 n_entries,
					 GtkIconItemFactoryEntry *entries,
					 gpointer		callback_data);
void
gtk_icon_item_factory_delete_item	(GtkIconItemFactory	*ifactory,
					 const gchar		*path);
void
gtk_icon_item_factory_delete_entry	(GtkIconItemFactory	*ifactory,
					 GtkIconItemFactoryEntry *entry);
void
gtk_icon_item_factory_delete_entries	(GtkIconItemFactory	*ifactory,
					 guint			n_entries,
					 GtkIconItemFactoryEntry *entries);
void
gtk_icon_item_factory_popup		(GtkIconItemFactory	*ifactory,
					 guint			x,
					 guint			y,
					 guint			mouse_button,
					 guint32		time);
void
gtk_icon_item_factory_popup_with_data	(GtkIconItemFactory	*ifactory,
					 gpointer		 popup_data,
					 GtkDestroyNotify	 destroy,
					 guint			 x,
					 guint			 y,
					 guint			 mouse_button,
					 guint32		 time);
gpointer
gtk_icon_item_factory_popup_data	(GtkIconItemFactory	*ifactory);
gpointer
gtk_icon_item_factory_popup_data_from_widget (GtkWidget		*widget);
void
gtk_icon_item_factory_set_translate_func (GtkIconItemFactory    *ifactory,
					  GtkTranslateFunc	func,
					  gpointer             	data,
					  GtkDestroyNotify     	notify);

#ifndef GTK_DISABLE_DEPRECATED
/* Compatibility functions for deprecated GtkMenuFactory code
 */
typedef void (*GtkIconMenuCallback) (GtkWidget	*widget, 
				     gpointer   user_data);
typedef struct {
  gchar			*path;
  gchar 		*accelerator;
  GtkMenuCallback 	callback;
  gpointer 		callback_data;
  GtkWidget 		*widget;
} GtkIconMenuEntry;

GtkIconItemFactory*
gtk_icon_item_factory_from_path		(const gchar		*path);
void
gtk_icon_item_factory_create_menu_entries (guint		n_entries,
					   GtkMenuEntry      	*entries);
void
gtk_icon_item_factories_path_delete	(const gchar		*ifactory_path,
					 const gchar		*path);
typedef	void
(*GtkIconItemFactoryCallback2) 		(GtkWidget	*widget,
					 gpointer	 callback_data,
					 guint		 callback_action);
void
gtk_icon_item_factory_create_items_ac (GtkIconItemFactory	*ifactory,
				       guint			n_entries,
				       GtkIconItemFactoryEntry	*entries,
				       gpointer		callback_data,
				       guint		callback_type);

#endif /* GTK_DISABLE_DEPRECATED */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __GTK_ICON_ITEM_FACTORY_H__ */

/* ************************************************ gtkiconitemfactory.h *** */
