/* ********************************************************* interface.c *** *
 * 
 *
 * Copyright (C) 2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/03/25 23:06:38 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include <teo.h>
#include "teo_convert.h"
#include "teo2gdk-pixbuf.h"

/* Ȥβ ********************************************************** */
static gchar**
get_comments (GtkTextView	*textview,
	      gint		*comment_num) {
  GtkTextIter	iter_start, iter_end;
  GtkTextBuffer	*buffer;
  gchar		*header = "C%03d ";
  gchar		buf[32];
  gchar		*comment, *ptr;
  gchar		**comments;
  gint		n, lines, width;
  gint		header_num = 5;

  buffer  = gtk_text_view_get_buffer (textview);
  gtk_text_buffer_get_start_iter (buffer, &iter_start);
  gtk_text_buffer_get_end_iter   (buffer, &iter_end);

  comment = gtk_text_buffer_get_text (buffer, &iter_start, &iter_end, TRUE);

  /* 饤μ */
  ptr   = comment;
  lines = 0;
  while (*ptr != '\0') if (*ptr++ == '\n') lines++;
  ptr = strrchr (comment, '\0');
  if (*(ptr - 1) != '\n') lines++;
  if (lines == 0) {
    *comment_num = 0;
    return NULL;
  }
  /* 饤ΰ */
  comments = (gchar **) malloc (sizeof (gchar *) * lines);
  ptr      = comment;
  for (n = 0; n < lines; n++) {
    for (width = 1; *ptr != '\n' && *ptr != '\0'; width++) ptr++;
#if 0
    width += (header_num + 1);
#endif
    comments[n] = g_new (gchar, width);
    if (*ptr != '\0') ptr++;
  }
  /* 饤Υȥå */
  ptr = comment;    
  for (n = 0; n < lines; n++) {
#if 0
    sprintf (buf, header, n);
    for (width = 0; width < strlen (buf); width++) {
      comments[n][width] = buf[width];
    }
    for (; *ptr != '\n' && *ptr != '\0'; width++) {
      comments[n][width] = *ptr++;
    }
#else
    for (width = 0; *ptr != '\n' && *ptr != '\0'; width++) {
      comments[n][width] = *ptr++;
    }
#endif
    comments[n][width] = '\0';
    if (*ptr != '\0') ptr++;
  }
  *comment_num = lines;
  return comments;
}

/* ************************************************************************* */
static gboolean
insert_comment_to_buffer (GtkTextView	*textview,
			  gchar		**comments,
			  gint		comment_num) {
  GtkTextBuffer	*buffer;
  gchar		*all_comment;
  gint		comment_len;
  gint		n, m, l;

  buffer  = gtk_text_view_get_buffer (textview);
  
  for (n = 0, comment_len = comment_num + 1; n < comment_num; n++) {
    comment_len += strlen (comments[n]);
  }
  all_comment = g_new (gchar, comment_len);
  for (n = 0, m = 0; m < comment_num; m++) {
    for (l = 0; l < strlen (comments[m]); l++) {
      all_comment[n++] = comments[m][l];
    }
    all_comment[n++] = '\n';
  }
  all_comment[n] = '\0';

  gtk_text_buffer_set_text (buffer, all_comment, -1);

  return TRUE;
}

/* OKܥ **************************************************************** */
static gint
cb_ok (GtkWidget	*widget,
       GtkWidget	*dialog) {
  TEImage	*ti;
  TEOFILE	*teofp;
  TEOIMAGE	*dst, *src;
  GdkPixbuf	*pixbuf;
  GtkWidget	*checkbutton;
  GtkWidget	*textview;
  gboolean	flag[3];
  gchar		*filename;
  gchar		**comments = NULL;
  gint		n, comment_num;

  /* ե饰γ */
  checkbutton = (GtkWidget *)
    g_object_get_data (G_OBJECT (dialog), "checkbutton1");
  flag[0] = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton));

  checkbutton = (GtkWidget *)
    g_object_get_data (G_OBJECT (dialog), "checkbutton2");
  flag[1] = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton));

  checkbutton = (GtkWidget *)
    g_object_get_data (G_OBJECT (dialog), "checkbutton3");
  flag[2] = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton));

  /* Ȥγ */
  if (flag[2]) {
    textview = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "textbox");
    comments = get_comments (GTK_TEXT_VIEW (textview), &comment_num);
  }
  /* TEImageǡ */
  ti = (TEImage *) g_object_get_data (G_OBJECT (dialog), "ti");
  
  /* ե̾ */
  filename = (gchar *) g_object_get_data (G_OBJECT (dialog), "filename");

  /* ǡ¸ */
  if (strcmp (filename, ti->filename) == 0) {
    /* ¸ */

  } else {
    /* ̾¸ */
    if (comments) {
      teofp = TeoCreateFileWithUserExtension (filename,
					      ti->width, ti->height,
					      ti->xoffset, ti->yoffset, 
					      (flag[1]) ? 
					      ti->type : TI_PIXEL_UNSIGNED,
					      (flag[1]) ? ti->bit : 8,
					      ti->nchannels,
					      (flag[0]) ? 1 : ti->nframes,
					      comment_num,
					      comments);
    } else {
      teofp = TeoCreateFile (filename,
			     ti->width, ti->height, ti->xoffset, ti->yoffset, 
			     (flag[1]) ? ti->type : TI_PIXEL_UNSIGNED,
			     (flag[1]) ? ti->bit : 8,
			     ti->nchannels,
			     (flag[0]) ? 1 : ti->nframes);
    }
    dst = TeoAllocSimilarImage (teofp);
    if (flag[0]) {	/* 󥰥ե졼¸ */
      src = teo2gdk_pixbuf_new_from_pixbuf (ti->pixbuf, 0);
      TeoConvert_from_TEOUINT8 (src, dst);
      TeoWriteFrame (teofp, dst);
      TeoCloseFile  (teofp);
      TeoFreeImage  (src);
      TeoFreeImage  (dst);
    } else {		/* ꥸʥΥե졼¸ */
      TeoSetAbsFrame ((TEOFILE *) ti->fp, 0);
      for (n = 0; n < ti->nframes; n++) {
	if (flag[1]) {		/* ꥸʥΥǡ¸ */
	  if (n == ti->frame) {		/* ߤΥե졼 */
	    src = teo2gdk_pixbuf_new_from_pixbuf (ti->pixbuf, 0);
	    TeoConvert_from_TEOUINT8 (src, dst);
	    TeoWriteFrame (teofp, dst);
	    TeoFreeImage  (src);
	  } else {			/* ̤Υե졼 */
	    TeoSetAbsFrame ((TEOFILE *) ti->fp, n);
	    TeoReadFrame ((TEOFILE *) ti->fp, dst);
	    TeoWriteFrame (teofp, dst);
	  }
	} else {		/* TEO_UINT8¸ */
	  if (n == ti->frame) {		/* ߤΥե졼 */
	    src = teo2gdk_pixbuf_new_from_pixbuf (ti->pixbuf, 0);
	    TeoConvert_from_TEOUINT8 (src, dst);
	    TeoWriteFrame (teofp, dst);
	    TeoFreeImage  (src);
	  } else {			/* ̤Υե졼 */
	    src = TeoAllocSimilarImage ((TEOFILE *) ti->fp);
	    TeoSetAbsFrame ((TEOFILE *) ti->fp, n);
	    TeoReadFrame ((TEOFILE *) ti->fp, src);
	    pixbuf = teo2gdk_pixbuf_new_from_teoimage (src, -1, -1);
	    TeoFreeImage (src);
	    src = teo2gdk_pixbuf_new_from_pixbuf (pixbuf, 0);
	    TeoWriteFrame (teofp, src);
	    TeoFreeImage (src);
	  }
	}
      }
      TeoCloseFile (teofp);
      TeoFreeImage (dst);
    }
  }
  if (comments) {
    for (n = 0; n < comment_num; n++) g_free (comments[n]);
    g_free (comments);
  }
  gtk_window_set_modal (GTK_WINDOW (dialog), FALSE);
  gtk_widget_hide (dialog);
  gtk_widget_destroy (dialog);

  return TRUE;
}

/* Cancelܥ ************************************************************ */
static gint
cb_cancel (GtkWidget	*widget,
	   GtkWidget	*dialog) {
  gtk_window_set_modal (GTK_WINDOW (dialog), FALSE);
  gtk_widget_hide (dialog);
  gtk_widget_destroy (dialog);
  
  return TRUE;
}

/*  **************************************************** */
GtkWidget*
teo_dialog_new (TEImage		*ti,
		gchar		*filename) {
  GtkWidget	*dialog;
  GtkWidget	*vbox;
  GtkWidget	*vbox2;	
  GtkWidget	*hbox;	
  GtkWidget	*frame;
  GtkWidget	*widget;
  GtkWidget	*scrolledwindow;

  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Save as TEO"));
  gtk_widget_set_size_request (dialog, 360, -1);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);
  {
    frame = gtk_frame_new (_("Settings"));
    gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
    {
      vbox2 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), vbox2);
      gtk_container_set_border_width (GTK_CONTAINER (vbox2), 8);
      {
	widget = gtk_check_button_new_with_label (_("Save as a single frame"));
	gtk_box_pack_start (GTK_BOX (vbox2), widget, FALSE, FALSE, 0);
	g_object_set_data (G_OBJECT (dialog), "checkbutton1", widget);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);
	if (ti->nframes == 1) gtk_widget_set_sensitive (widget, FALSE);

	widget = gtk_check_button_new_with_label (_("Save as the same data type of the original"));
	gtk_box_pack_start (GTK_BOX (vbox2), widget, FALSE, FALSE, 0);
	g_object_set_data (G_OBJECT (dialog), "checkbutton2", widget);
	if (ti->type == TI_PIXEL_UNSIGNED && ti->bit == 8) {
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);
	  gtk_widget_set_sensitive (widget, FALSE);
	}
	widget = gtk_check_button_new_with_label (_("Add comments"));
	gtk_box_pack_start (GTK_BOX (vbox2), widget, FALSE, FALSE, 0);
	g_object_set_data (G_OBJECT (dialog), "checkbutton3", widget);

	frame = gtk_frame_new (NULL);
	gtk_box_pack_start (GTK_BOX (vbox2), frame, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
	{
	  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),
					  GTK_POLICY_AUTOMATIC,
					  GTK_POLICY_AUTOMATIC);
	  gtk_container_add (GTK_CONTAINER (frame), scrolledwindow);
	  {
	    widget = gtk_text_view_new ();
	    gtk_container_add (GTK_CONTAINER (scrolledwindow), widget);
	    g_object_set_data (G_OBJECT (dialog), "textbox", widget);
	    if (ti->fp && ((TEOFILE *) ti->fp)->extc > 0) {
	      insert_comment_to_buffer (GTK_TEXT_VIEW (widget),
					((TEOFILE *) ti->fp)->extv,
					((TEOFILE *) ti->fp)->extc);
	    }
	  }
	}
      }
    }
    widget = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 3);

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
    {
      widget = gtk_button_new_from_stock (GTK_STOCK_OK);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_set_size_request (widget, 120, -1);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (cb_ok), dialog);

      widget = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_set_size_request (widget, 120, -1);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (cb_cancel), dialog);
    }
  }
  g_object_set_data (G_OBJECT (dialog), "ti", ti);
  g_object_set_data (G_OBJECT (dialog), "filename", filename);

  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);

  return dialog;
}
