/* ******************************************************* teo_convert.c *** *
 * This library is a auxiliary teo library
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/01/14 22:19:45 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <teo.h>

/* Convert Binary to Gray (Original source comes from libteoutil) ********** */
TEOIMAGE*
TeoCreateBin2Gray (TEOIMAGE	*src) {
  int		row, col;
  TEOIMAGE	*dst;
  unsigned char	*src_ptr, *dst_ptr;
  
  dst = TeoAllocImage (TeoWidth   (src),
		       TeoHeight  (src),
		       TeoXoffset (src),
		       TeoYoffset (src),
		       TEO_UNSIGNED, 8, 3);

  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++){
      if (TeoGetBit (src, col, row, 0) == 0) {	
	TeoPutPixel (dst, col, row, 0, TEO_UINT8, 0);
      } else {
	TeoPutPixel (dst, col, row, 0, TEO_UINT8, 255);
	TeoPutPixel (dst, col, row, 1, TEO_UINT8, 255);
	TeoPutPixel (dst, col, row, 2, TEO_UINT8, 255);	
      }
    }
  }     
  return dst;
}

/* TEO_UINT8$B7?$+$i(BTEO_SINT8$B7?$X$NJQ49(B ************************************** */
static void
TEOUINT8_to_TEOSINT8 (TEOIMAGE	*src,
		      TEOIMAGE	*dst) {
  int	row, col, p;

  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      for (p = 0; p < (TeoPlane (src) < TeoPlane (dst)) ? 
	     TeoPlane (src) : TeoPlane (dst); p++) {
	TeoPutPixel (dst, col, row, p, TEO_SINT8,
		     (TEO_SINT8) TeoGetPixel (src, col, row, p, TEO_UINT8));
      }
    }
  }
}

/* TEO_UINT8$B7?$+$i(BTEO_SINT16$B7?$X$NJQ49(B ************************************* */
static void
TEOUINT8_to_TEOSINT16 (TEOIMAGE	*src,
		       TEOIMAGE	*dst) {
  int	row, col, p;

  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      for (p = 0; p < (TeoPlane (src) < TeoPlane (dst)) ? 
	     TeoPlane (src) : TeoPlane (dst); p++) {
	TeoPutPixel (dst, col, row, p, TEO_SINT16,
		     (TEO_SINT16) TeoGetPixel (src, col, row, p, TEO_UINT8));
      }
    }
  }
}

/* TEO_UINT8$B7?$+$i(BTEO_SINT32$B7?$X$NJQ49(B ************************************* */
static void
TEOUINT8_to_TEOSINT32 (TEOIMAGE	*src,
		       TEOIMAGE	*dst) {
  int	row, col, p;

  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      for (p = 0; p < (TeoPlane (src) < TeoPlane (dst)) ? 
	     TeoPlane (src) : TeoPlane (dst); p++) {
	TeoPutPixel (dst, col, row, p, TEO_SINT32,
		     (TEO_SINT32) TeoGetPixel (src, col, row, p, TEO_UINT8));
      }
    }
  }
}

/* TEO_UINT8$B7?$+$i(BTEO_UINT8$B7?$X$NJQ49(B ************************************** */
static void
TEOUINT8_to_TEOUINT8 (TEOIMAGE	*src,
		      TEOIMAGE	*dst) {
  int	row, col, p;

  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      for (p = 0; p < ((TeoPlane (src) < TeoPlane (dst)) ? 
		       TeoPlane (src) : TeoPlane (dst)); p++) {
	TeoPutPixel (dst, col, row, p, TEO_UINT8,
		     (TEO_UINT8) TeoGetPixel (src, col, row, p, TEO_UINT8));
      }
    }
  }
}

/* TEO_UINT8$B7?$+$i(BTEO_UINT16$B7?$X$NJQ49(B ************************************* */
static void
TEOUINT8_to_TEOUINT16 (TEOIMAGE	*src,
		       TEOIMAGE	*dst) {
  int	row, col, p;

  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      for (p = 0; p < (TeoPlane (src) < TeoPlane (dst)) ? 
	     TeoPlane (src) : TeoPlane (dst); p++) {
	TeoPutPixel (dst, col, row, p, TEO_UINT16,
		     (TEO_UINT16) TeoGetPixel (src, col, row, p, TEO_UINT8));
      }
    }
  }
}

/* TEO_UINT8$B7?$+$i(BTEO_UINT32$B7?$X$NJQ49(B ************************************* */
static void
TEOUINT8_to_TEOUINT32 (TEOIMAGE	*src,
		       TEOIMAGE	*dst) {
  int	row, col, p;

  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      for (p = 0; p < (TeoPlane (src) < TeoPlane (dst)) ? 
	     TeoPlane (src) : TeoPlane (dst); p++) {
	TeoPutPixel (dst, col, row, p, TEO_UINT32,
		     (TEO_UINT32) TeoGetPixel (src, col, row, p, TEO_UINT8));
      }
    }
  }
}

/* TEO_UINT8$B7?$+$i(BTEO_FLOAT32$B7?$X$NJQ49(B ************************************ */
static void
TEOUINT8_to_TEOFLOAT32 (TEOIMAGE	*src,
			TEOIMAGE	*dst) {
  int	row, col, p;

  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      for (p = 0; p < (TeoPlane (src) < TeoPlane (dst)) ? 
	     TeoPlane (src) : TeoPlane (dst); p++) {
	TeoPutPixel (dst, col, row, p, TEO_FLOAT32,
		     (TEO_FLOAT32) TeoGetPixel (src, col, row, p, TEO_UINT8));
      }
    }
  }
}

/* TEO_UINT8$B7?$+$i(BTEO_FLOAT64$B7?$X$NJQ49(B ************************************ */
static void
TEOUINT8_to_TEOFLOAT64 (TEOIMAGE	*src,
			TEOIMAGE	*dst) {
  int	row, col, p;

  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      for (p = 0; p < (TeoPlane (src) < TeoPlane (dst)) ? 
	     TeoPlane (src) : TeoPlane (dst); p++) {
	TeoPutPixel (dst, col, row, p, TEO_FLOAT64,
		     (TEO_FLOAT64) TeoGetPixel (src, col, row, p, TEO_UINT8));
      }
    }
  }
}

/* ************************************************************************* */
void
TeoConvert_from_TEOUINT8 (TEOIMAGE	*src,
			  TEOIMAGE	*dst) {
  switch (TeoType (dst)) {
  case TEO_SIGNED:
    switch (TeoBit (dst)) {
    case 8:
      TEOUINT8_to_TEOSINT8 (src, dst);
      break;
    case 16:
      TEOUINT8_to_TEOSINT16 (src, dst);
      break;
    case 32:
      TEOUINT8_to_TEOSINT32 (src, dst);
      break;
    }
    break;
  case TEO_UNSIGNED:
    switch (TeoBit (dst)) {
    case 8:
      TEOUINT8_to_TEOUINT8 (src, dst);
      break;
    case 16:
      TEOUINT8_to_TEOUINT16 (src, dst);
      break;
    case 32:
      TEOUINT8_to_TEOUINT32 (src, dst);
      break;
    }
    break;
  case TEO_FLOAT:
    switch (TeoBit (dst)) {
    case 32:
      TEOUINT8_to_TEOFLOAT32 (src, dst);
      break;
    case 64:
      TEOUINT8_to_TEOFLOAT64 (src, dst);
      break;
    }
    break;
  }
}

/* ************************************************ End of teo_convert.c *** */
