/* ******************************************************** teo_normal.c *** *
 * This library is a auxiliary teo library
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/01/14 22:21:58 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <teo.h>

/* ************************************************************************* */
TEOIMAGE*
TeoCreateNormalImage (TEOIMAGE	*src, 
		      double	min,
		      double	max) {
  TEOIMAGE      *dst;
  TEO_UINT8	*dst_ptr;
  double	param;
  int		n;
  
  dst = TeoAllocImage (TeoWidth	  (src),
                       TeoHeight  (src),
                       TeoXoffset (src),
		       TeoYoffset (src),
                       TEO_UNSIGNED, 
		       8,
		       TeoPlane (src));
  dst_ptr = (TEO_UINT8 *) dst->data;  
  param   = (min != max) ? max - min : (min > 255) ? min : 255;
  min     = (min == max) ? 0 : min;

  switch (TeoType (src)) {
  case TEO_UNSIGNED:
    switch (TeoBit (src)) {
    case 8:
      {
	TEO_UINT8 *src_ptr;
	src_ptr = (TEO_UINT8 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
	break;
      }
    case 16:
      {
	TEO_UINT16 *src_ptr;
	src_ptr = (TEO_UINT16 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
	break;
      }
    case 32:
      {
	TEO_UINT32 *src_ptr;
	src_ptr = (TEO_UINT32 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
	break;
      }
    }
    break;
  case TEO_SIGNED:
    switch (TeoBit (src)) {
    case 8:
      {
	TEO_SINT8 *src_ptr;
	src_ptr = (TEO_SINT8 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
	break;
      }
    case 16:
      {
	TEO_SINT16 *src_ptr;
	src_ptr = (TEO_SINT16 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
	break;
      }
    case 32:
      {
	TEO_SINT32 *src_ptr;
	src_ptr = (TEO_SINT32 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
	break;
      }
    }
    break;
  case TEO_FLOAT:
    switch (TeoBit (src)) {
    case 32:
      {
	TEO_FLOAT32 *src_ptr;
	src_ptr = (TEO_FLOAT32 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
	break;
      }
    case 64:
      {
	TEO_FLOAT64 *src_ptr;
	src_ptr = (TEO_FLOAT64 *) src->data;
	for (n = TeoFsize (dst); n > 0; n--) {
	  *dst_ptr++ = (TEO_UINT8) ((*src_ptr++ - min) * 255 / param);
	}
	break;
      }
    }
    break;
  }
  return dst;
}

/* ******************************************************** teo_normal.c *** */
