/* ****************************************************** browser_menu.h *** *
 *
 *
 * Copyright (C) 1998-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <04/06/21 15:04:14 sugaya>
 * ************************************************************************* */
#ifndef	__BROWSER_MENU_H__
#define	__BROWSER_MENU_H__

#include "callback.h"

#include "teoeyes_icon.icon"
#include "stock_new.icon"
#include "stock_open.icon"
#include "stock_save.icon"
#include "stock_save_as.icon"
#include "stock_close.icon"
#include "stock_quit.icon"
#include "stock_iconlist.icon"
#include "stock_filelist.icon"
#include "stock_reload.icon"
#include "stock_clean.icon"
#include "stock_prof.icon"
#include "stock_help.icon"
#include "stock_about.icon"
#include "stock_home.icon"


static GtkIconItemFactoryEntry menu_items[] = {

  {N_("/_File"),		NULL,	0,	0,	"<Branch>",	NULL},
  {N_("/_File/tearoff"),	NULL,	0,	0,	"<Tearoff>",	NULL},
  {N_("/_File/New"),	"<Control>N",
   cb_new,	0,	"<ImageItem>",	stock_new},
  {N_("/_File/Open"),	"<Control>O",
   cb_open,	0,	"<ImageItem>",	stock_open},
  {N_("/_File/Save"),	"<Control>S",
   cb_save,	0,	"<ImageItem>",	stock_save},
  {N_("/_File/Save as"),"<Control><Alt>S",
   cb_save_as,	0,	"<ImageItem>",	stock_save_as},
  {N_("/_File/separator"),	NULL,	0,	0,	"<Separator>",	NULL},
  {N_("/_File/Close"),	"<Control>W",
   ixp_close,	0,	"<ImageItem>",	stock_close},
  {N_("/_File/Quit"),	"<Control>Q",
   cb_quit,	0,	"<ImageItem>",	stock_quit},
  

  {N_("/_View"),		NULL,	0,	0,	"<Branch>",	NULL},
  {N_("/_View/tearoff"),	NULL,	0,	0,	"<Tearoff>",	NULL},
  {N_("/_View/Show Icon List"),	NULL,
   ixp_switch_view_mode,	0,	"<ImageItem>",	stock_iconlist},
  {N_("/_View/Show File List"),	NULL,
   ixp_switch_view_mode,	1,	"<ImageItem>",	stock_filelist},
  {N_("/_View/separator"),	NULL,	0,	0,	"<Separator>",	NULL},
  {N_("/_View/Show Hidden Folders"), NULL,
   ixp_show_hidden,	0,	"<ToggleItem>",	NULL},
  {N_("/_View/Reload List"),	"<Control>R",
   ixp_reload,	0,	"<ImageItem>",	stock_reload},
  {N_("/_View/Clean up Icon"),	"<Control>C",
   ixp_clean,	0,	"<ImageItem>",	stock_clean},


  {N_("/_Property"),		NULL,	0,	0,	"<Branch>",	NULL},
  {N_("/_Property/tearoff"),	NULL,	0,	0,	"<Tearoff>",	NULL},
  {N_("/_Property/Property"),	"<Control>F",
   cb_show_config,	0,	"<ImageItem>",	stock_prof},


  {N_("/_Help"),		NULL,	0,	0,	"<LastBranch>",	NULL},
  {N_("/_Help/tearoff"),	NULL,	0,	0,	"<Tearoff>",	NULL},
  {N_("/_Help/About Teoeyes"),	"<Control>A",
   cb_show_about,	0,	"<ImageItem>",	stock_help},
  {N_("/_Help/Help"),	"<Control>H",
   0,	0,	"<ImageItem>",	stock_about}
};

#endif	/* __BROWSER_MENU_H__ */

/* *********************************************** End of browser_menu.h *** */
