/* ******************************************************** gfileutils.c *** *
 * ǥ쥯ȥꡦեؿ
 *
 * Copyright (C) 2002-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/05/12 21:20:56 sugaya>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <time.h>
#include <pwd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <glib.h>
#include "gfileutils.h"

#define	DEFAULT_DIRECTORY_MODE	(0755)

/* ************************************************************************* *
 * ǥ쥯ȥꡦե̴ؿ
 * ************************************************************************* */

/* եѥե̾ƥǥ쥯ȥȥե̾ʬ䤹 **************** */
void
g_separate_path (const gchar	*fullname,
		 gchar		**path,
		 gchar		**file) {
  g_return_if_fail (fullname && *fullname);

  *file = g_path_get_basename (fullname);
  *path = g_path_get_dirname (fullname);
}

/* Хѥ ****************************************************** */
gchar* 
g_get_absolute_path (const gchar	*path) {
  gchar	root[5], root1[5], root2[5], root3[5], root4[5];
  gchar *aux_path;
  gint 	length;

  /* GET ABSOLUTE PATH */
  sprintf (root,  "%s",		G_DIR_SEPARATOR_S);
  sprintf (root1, "%s.",	G_DIR_SEPARATOR_S);
  sprintf (root2, "%s..",	G_DIR_SEPARATOR_S);
  sprintf (root3, "%s..%s",	G_DIR_SEPARATOR_S, G_DIR_SEPARATOR_S);
  sprintf (root4, "%s.%s",	G_DIR_SEPARATOR_S, G_DIR_SEPARATOR_S);

  aux_path = g_strdup (path);
  length   = strlen (aux_path);

  if (strcmp (aux_path + length - 2, root1) == 0) {
    if (length == 2) {
      g_free (aux_path);
      aux_path = g_strdup (root);
    } else {
      aux_path[length - 1] = '\0';
    }
  } else if (strcmp (aux_path + length - 3, root2) == 0) {
    if (length == 3) {
      g_free (aux_path);
      aux_path = g_strdup (root);
    } else {
      gint i = length - 4;
      while (i >= 0) {
	if (aux_path[i] == root[0]) {
	  aux_path[i+1] = '\0';
	  break;
	}
	i--;
      }
    }
  } else if (strcmp (aux_path + length - 4, root3) == 0) {
    if (length == 4) {
      g_free (aux_path);
      aux_path = g_strdup (root);
    } else {
      gint i = length - 5;
      while (i >= 0) {
	if (aux_path[i] == root[0]) {
	  aux_path[i+1] = '\0';
	  break;
	}
	i--;
      }
    }
  } else if (strcmp (aux_path + length - 3, root4) == 0) {
    if (length == 3) {
      g_free (aux_path);
      aux_path = g_strdup (root);
    } else {
      aux_path[length - 2] = '\0';
    }
  }
  return aux_path;
}

/* 桼͡ϡ ****************************************************** */
const gchar*
g_get_username (gint	uid) {
  struct passwd	*pass;

  pass = getpwuid (uid);
  if (pass && pass->pw_name) {
    endpwent ();    
    return pass->pw_name;
  } else {
    return NULL;
  }
}

/* ϡ ************************************************************** */
const gchar*
g_get_usershell (gint	uid) {       
  struct passwd	*pass;
   
  pass = getpwuid (uid);
  if (pass && pass->pw_shell) {
    endpwent ();
    return pass->pw_shell;
  } else {
    return NULL;
  }
}

/* ************************************************************************* *
 * ǥ쥯ȥؿ
 * ************************************************************************* */

/* ȥǥ쥯ȥѹ ********************************************** */
gboolean
g_dir_cd (const gchar	*dir) {
  g_return_val_if_fail (dir && *dir, FALSE);

  chdir (dir);

  return TRUE;
}

/* ǥ쥯ȥ ************************************************** */
gboolean
g_dir_mkdir (const gchar	*dir) {
  g_return_val_if_fail (dir && *dir, FALSE);

  if (mkdir (dir, DEFAULT_DIRECTORY_MODE) < 0) {
    return FALSE;
  } else {
    return TRUE;
  }
}

/* ǥ쥯ȥ ************************************************** */
gboolean
g_dir_mkdirs (const gchar	*dir) {
  gchar  s[1024];
#if 0
  int   n = 0, m = 0;
#endif
  g_return_val_if_fail (dir && *dir, FALSE);
#if 0
  while (dir[n]) {
    s[m++] = dir[n];
    s[m] = 0;
    if (dir[n] == G_DIR_SEPARATOR) {
      if (!g_file_exist (s)) {
	g_dir_mkdir (s);
      } else if (!g_dir_is (s)) {
	return FALSE;
      }
    }
    n++;
  }
#else
  sprintf (s, "mkdir -p %s", dir);
  system (s);
#endif
  return TRUE;
}

/* ǥ쥯ȥ ************************************************** */
gboolean
g_dir_remove (const gchar	*dir) {
  char	cmd[1024];

  g_return_val_if_fail (dir && *dir, FALSE);
  
  sprintf (cmd, "rm -rf %s", dir);
  system (cmd);

  return TRUE;
}

/* ȥǥ쥯ȥγ ********************************************** */
gchar*
g_dir_get_current_dir (void) {
  gchar s[1024];
  gchar ss[1024];  
   
  getcwd (s, sizeof (s));
  sprintf (ss, "%s/", s);
  
  return g_strdup (ss);
}

/* ************************************************************************* */
gchar*
g_dir_get_parent_dir (const gchar	*dir) {
  gchar	*work, *parent;

  g_return_val_if_fail (dir, NULL);
  
  if (strcmp (dir, G_DIR_SEPARATOR_S) == 0) {
    return g_strdup (dir);
  } else if (*(dir + strlen (dir) - 1) == G_DIR_SEPARATOR) {
    work = g_strndup (dir, strlen (dir) - 1);
  } else {
    work = g_strdup (dir);
  }
  if (!work) return NULL;

  parent = g_path_get_dirname (work);
  g_free (work);

  return parent;
}

/* ȥǥ쥯ȥꡩ ************************************************** */
gboolean
g_dir_is_current_dir (const gchar	*dir) {
  g_return_val_if_fail (dir && *dir, FALSE);
  
  if (strcmp (dir, G_DIR_CURRENT_S) == 0) {
    return TRUE;
  } else {
    return FALSE;
  }
}

/* ƥǥ쥯ȥꡩ ******************************************************** */
gboolean
g_dir_is_parent_dir (const gchar	*dir) {
  g_return_val_if_fail (dir && *dir, FALSE);

  if (strcmp (dir, G_DIR_PARENT_S) == 0) {
    return TRUE;
  } else {
    return FALSE;
  }
}

/* ǥ쥯ȥꡩ ********************************************************** */
gboolean
g_dir_is (const gchar	*dir) {
  struct stat	st;

  g_return_val_if_fail (dir && *dir, FALSE);  

  if (stat (dir, &st) < 0) return FALSE;
  if (S_ISDIR (st.st_mode)) {
    return TRUE;
  } else {
    return FALSE;
  }
}

/* ֥ǥ쥯ȥ꤬뤫ɤĴ٤ ************************************ */
gint
g_dir_exist_subdir (const gchar	*dir) {
  struct stat	st;

  g_return_val_if_fail (dir && *dir, FALSE);

  if (stat (dir, &st) < 0) return FALSE;
  if (!S_ISDIR (st.st_mode)) return FALSE;

  return st.st_nlink - 2;
}

/* ************************************************************************* */
static gint
compare_by_spell (gconstpointer	data1,
		  gconstpointer	data2) {
  const gchar	*str1 = data1;
  const gchar	*str2 = data2;

  return strcmp (str1, str2);
}

/* ǥ쥯ȥls ********************************************************** */
GList*
g_dir_ls_dir (const gchar	*dir,
	      gboolean		show_hidden) {
  DIR		*dp;
  struct dirent	*entry;
  GList		*list = NULL;
  gchar		*path;

  g_return_val_if_fail (dir && *dir, NULL);

  if (!(dp = opendir (dir))) return NULL;

  while ((entry = readdir (dp))) {
    if (g_dir_is_current_dir (entry->d_name) ||
	g_dir_is_parent_dir  (entry->d_name)) continue;
    path = g_build_filename (dir, entry->d_name, NULL);
    if (g_dir_is (path)) {
      if (!show_hidden && entry->d_name[0] == '.') continue;
      list = g_list_append (list, g_strdup (entry->d_name));
    }
    g_free (path);
  }
  closedir (dp);

  if (list) list = g_list_sort (list, compare_by_spell);

  return list;
}

/* ls ********************************************************************** */
GList*
g_dir_ls (const gchar	*dir) {
  DIR		*dp;
  struct dirent	*entry;
  GList		*files = NULL;

  g_return_val_if_fail (dir && *dir, NULL);

  if (!(dp = opendir (dir))) return NULL;

  while ((entry = readdir (dp))) {
    if (g_dir_is_current_dir (entry->d_name) || 
	g_dir_is_parent_dir  (entry->d_name)) continue;
    files = g_list_append (files, g_strdup (entry->d_name));
  }
  closedir (dp);

  if (files) files = g_list_sort (files, compare_by_spell);
  
  return files;
}

/* ************************************************************************* *
 * եؿ
 * ************************************************************************* */

/* ե¸ߤ뤫 ************************************************** */
gboolean
g_file_exist (const gchar	*filename) {
  struct stat st;

  g_return_val_if_fail (filename && *filename, FALSE);
  
  if (stat (filename, &st) < 0) return FALSE;

  return TRUE;
}

/* ե뤫 ************************************************************ */
gboolean
g_file_is (const gchar	*filename) {
  struct stat st;

  g_return_val_if_fail (filename && *filename, FALSE);

  if (stat (filename, &st) < 0) return FALSE;
  if (S_ISREG (st.st_mode)) {
    return TRUE;
  } else {
    return FALSE;
  }
}

/* 󥯤 ************************************************************** */
gboolean
g_file_is_link (const gchar	*filename) {
  struct stat st;

  g_return_val_if_fail (filename && *filename, FALSE);

  if (lstat (filename, &st) < 0) return FALSE;
  if (S_ISLNK (st.st_mode)) {
    return TRUE;
  } else {
    return FALSE;
  }
}

/* եκ ********************************************************** */
gboolean
g_file_remove (const gchar	*filename) {
  g_return_val_if_fail (filename && *filename, FALSE);

  unlink (filename);

  return TRUE;
}

/* ե̾ѹ ****************************************************** */
gboolean
g_file_rename (const gchar	*old, 
	       const gchar	*new) {
  g_return_val_if_fail (old && *old, FALSE);
  g_return_val_if_fail (new && *new, FALSE);  
  
  rename (old, new);

  return TRUE;
}

/* եΥԡ ******************************************************** */
gboolean
g_file_copy (const gchar	*from,
	     const gchar	*to) {
  FILE		*from_fp, *to_fp;
  unsigned char buf[1];

  g_return_val_if_fail (from && *from, FALSE);
  g_return_val_if_fail (to && *to, FALSE);
  
  if (!g_file_exist (from)) return FALSE;

  from_fp = fopen (from, "r");
  if (!from_fp) return FALSE;

  to_fp = fopen (to, "w");
  if (!to_fp) {
    fclose (from_fp);
    return FALSE;
  }
  while (fread (buf, 1, 1, from_fp)) fwrite (buf, 1, 1, to_fp);

  fclose (from_fp);
  fclose (to_fp);

  return TRUE;
}

/* եιγ ************************************************ */
guint64
g_file_get_moddate (const gchar	*filename) {
  struct stat st;

  g_return_val_if_fail (filename && *filename, 0);
  
  if (!stat (filename, &st) < 0) return 0;
  if (st.st_mtime > st.st_ctime) {
    return (guint64) st.st_mtime;
  } else {
    return (guint64) st.st_ctime;
  }
}

/* եιγ (ʸȤ֤) ***************************** */
gchar*
g_file_get_moddate_string (const gchar	*filename) {
  gchar		*tmp;
  gchar		buf[1024];
  struct stat 	st;
  struct tm	*update;
  gint		n;

  g_return_val_if_fail (filename && *filename, NULL);
  if (!stat (filename, &st) < 0) return NULL;

  update = (st.st_mtime > st.st_ctime) ?
    localtime ((time_t *) &st.st_mtime) : localtime ((time_t *) &st.st_ctime);
  tmp = asctime (update) + 4;
  for (n = 0; n < 12; n++) buf[n] = *tmp++;
  tmp += 3;
  for (; n < 17; n++) buf[n] = *tmp++;
  buf[n] = '\0';

  return g_strdup (buf);
}

/* ե륵γ **************************************************** */
gint
g_file_get_size (const gchar	*filename) {
  struct stat st;

  g_return_val_if_fail (filename && *filename, 0);  
  if (stat (filename, &st) < 0) return 0;
  
  return (gint) st.st_size;
}

/* ե륵γ **************************************************** *
 * original source code came from gimageview (fileutils.c)
 * ************************************************************************* */
gchar*
g_file_get_size_string (const gchar	*filename) {
  struct stat 	st;
  size_t	i = 0, size;
  gint		j = 0;
  int		n_digit = 0;
  gchar 	tmp[14];
  gchar 	comma[14];
  gchar 	buf[14];
  gboolean	space = TRUE;

  g_return_val_if_fail (filename && *filename, 0);  
  if (stat (filename, &st) < 0) return NULL;
  
  i = size = st.st_size;

  /* detect digit num */
  while (i > 0) {
    i = i / 10;
    n_digit++;
  }
  sprintf (tmp, "%d", size);

  if (strlen (tmp) < 4) {
    if (space) {
      g_snprintf (buf, 14, "%13s", tmp);
      return g_strdup (buf);
    } else {
      return g_strdup(tmp);
    }
  }
  /* until first comma */
  if (n_digit % 3 != 0) {
    for (i = 0; i < n_digit % 3; i++) {
      comma[j++] = tmp[i];
      if (i != strlen (tmp)) comma[j++] = ',';
    }
  }
  /* until end of string */
  while (tmp[i] != '\0'){
    comma[j++] = tmp[i++];
    comma[j++] = tmp[i++];
    comma[j++] = tmp[i++];
    if(tmp[i] != '\0')
      comma[j++] = ',';
  }
  /* end of string */
  comma[j] = '\0';

  if (space) {
    g_snprintf (buf, 14, "%13s", comma);
    return g_strdup (buf);
  } else {
    return g_strdup(comma);
  }
}

/* ѡߥåϡ ****************************************************** */
gint
g_file_get_permissions (const gchar	*filename) {
  struct stat st;

  g_return_val_if_fail (filename && *filename, 0);
  if (!stat (filename, &st) < 0) return 0;
  
  return (gint) st.st_mode;
}

/* ͭԤï ************************************************************ */
gint
g_file_get_owner (const gchar	*filename) {
  struct stat st;

  g_return_val_if_fail (filename && *filename, 0);  
  if (!stat (filename, &st) < 0) return 0;
  
  return (gint) st.st_uid;
}

/* 롼פϡ ************************************************************ */
gint
g_file_get_group (const gchar	*filename) {
  struct stat st;

  g_return_val_if_fail (filename && *filename, 0);
  if (!stat (filename, &st) < 0) return 0;
  
  return (gint) st.st_gid;
}

/* ɤ߹߲ǽ ********************************************************** */
gboolean
g_file_can_read (const gchar	*filename) {
  g_return_val_if_fail (filename && *filename, FALSE);

  return (gboolean) !access (filename, R_OK);
}

/* 񤭹߲ǽ ********************************************************** */
gboolean
g_file_can_write (const gchar	*filename) {
  g_return_val_if_fail (filename && *filename, FALSE);
  
  return access (filename, W_OK);
}

/* ¹Բǽ ************************************************************** */
gboolean
g_file_can_exec (const gchar	*filename) {
  g_return_val_if_fail (filename && *filename, FALSE);

  return access (filename, X_OK);
}

/* ************************************************************************* *
 * ѥޥå󥰴ؿ
 * ************************************************************************* */
gint
g_strcmp (const char	*pattern,
	  const char	*text) {
  int	p_length;
  int	t_length;

  p_length = strlen (pattern);
  t_length = strlen (text);

  if (p_length < t_length) {
    return (gint) strcmp (pattern, (text + t_length - p_length));
  } else {
    return (gint) strcmp (pattern, text);
  }
}

/* ************************************************* End of gfileutils.c *** */
