/* ************************************************************** grab.c *** *
 * Υ
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/05/14 23:23:44 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "X11/cursorfont.h"
#include "grab.h"
#include "image_io.h"
#include "image_window.h"
#include "list_viewer.h"

/* Хѿ ********************************************************** */
static Display		*dsp;
static Window		win;
static GC		gc;
static int		screen;

u_long
xorMasks[] = {
  0x01010101,
  0x02020203,
  0x84848485,
  0x88888889,
  0x10101011,
  0x20202023,
  0xc4c4c4c5,
  0xffffffff
};

/* ************************************************************************* */
static void
flash_start (void) {
  XSetFunction      (dsp, gc, GXinvert);
  XSetSubwindowMode (dsp, gc, IncludeInferiors);
}

/* ************************************************************************* */
static void
flash_end (void) {
  XSetFunction      (dsp, gc, GXcopy);
  XSetSubwindowMode (dsp, gc, ClipByChildren);
  XSetPlaneMask     (dsp, gc, AllPlanes);
  XSync             (dsp, FALSE);
}

/* ************************************************************************* */
static void
flash_rect (int		x,
	    int		y,
	    int		w,
	    int		h,
	    int		show) {
  static int	isvis	= 0;
  static int	maskno	= 0;

  XSetPlaneMask (dsp, gc, xorMasks[maskno]);
  if (!show) {
    if (isvis) XDrawRectangle (dsp, win, gc, x, y, (u_int) w-1, (u_int) h-1);
    isvis = 0;
  } else {
    if (!isvis && w > 1 && h > 1) {
      maskno = (maskno + 1) & 7;
      XSetPlaneMask (dsp, gc, xorMasks[maskno]);
      XDrawRectangle (dsp, win, gc, x, y, (u_int) w-1, (u_int) h-1);
      isvis = 1;
    }
  }
}

/* ************************************************************************* */
static Window
try_children (Display	*dsp,
	      Window	win,
	      Atom	WM_STATE) {
  Window	root, parent, inf = 0;
  Window	*children;
  Atom		type = None;
  int 		format;  
  unsigned int 	n, nchildren;
  unsigned long nitems, after;
  unsigned char *data;

  if (!XQueryTree (dsp, win, &root, &parent, &children, &nchildren)) return 0;

  for (n = 0; !inf && (n < nchildren); n++) {
    XGetWindowProperty (dsp, children[n], WM_STATE, 0L, 0L, False,
			AnyPropertyType, &type, &format, &nitems,
			&after, &data);
    if (type) inf = children[n];
  }
  for (n = 0; !inf && (n < nchildren); n++) {
    inf = try_children (dsp, children[n], WM_STATE);
  }
  if (children) XFree ((char *) children);

  return inf;
}

/* ************************************************************************* */
static Window
client_window (Display	*dsp,
	       Window	win) {
  Window	inf;
  Atom		WM_STATE;
  Atom		type = None;
  int 		format;
  unsigned long nitems, after;
  unsigned char *data;

  WM_STATE = XInternAtom (dsp, "WM_STATE", TRUE);
  if (!WM_STATE) return win;

  XGetWindowProperty (dsp, win, WM_STATE, 0L, 0L, False, AnyPropertyType,
		      &type, &format, &nitems, &after, &data);
  if (type) return win;

  inf = try_children (dsp, win, WM_STATE);

  return inf;
}
		       
/* ************************************************************************* */
void
grab_do_grab (void) {
  GtkWidget		*canvas;
  GdkWindow		*gwin;
  GdkPixbuf		*pixbuf, *tmp;  
  Window		rW, cW, clickW, chwin, orgW;
  XWindowAttributes	clickxwa, parentxwa;  
  Cursor		tcross;
  char			buf[256];  
  unsigned int		mask;
  int			n, x, y, rx, ry, rw, rh, x1, y1, x2, y2;
  int			ix, iy, iw, ih, W, H, org_x, org_y;
    
  canvas = G_GET_WIDGET (image_window, "canvas");
  dsp    = GDK_DISPLAY ();
  win    = GDK_ROOT_WINDOW ();
  screen = DefaultScreen (dsp);
  gc     = DefaultGC (dsp, screen);
  tcross = XCreateFontCursor (dsp, XC_tcross);

  XGrabButton (dsp, (u_int) AnyButton, 0, win, FALSE, 0,
	       GrabModeAsync, GrabModeSync, None, tcross);
  while (1) {
    if (XQueryPointer (dsp, win, &rW, &cW, &rx, &ry, &x1, &y1, &mask)) {
      if (mask & (Button1Mask | Button2Mask | Button3Mask)) break;
    }
  }
  if (mask & Button3Mask || rW != win) {
    /* ܥΥ٥ (֥󥻥) */    
    while (1) {
      if (XQueryPointer (dsp, win, &rW, &cW, &rx, &ry, &x, &y, &mask)) {
	if (!(mask & Button3Mask)) break;
      }
    }
    XUngrabButton (dsp, (u_int) AnyButton, 0, win);
  } else if (mask & Button2Mask) {
    /* ܥΥ٥ (ɥΥ) */    
    gdk_window_get_geometry (gdk_get_default_root_window(),
			     NULL, NULL, &W, &H, NULL);
    while (1) {
      if (XQueryPointer (dsp, win, &rW, &cW, &rx, &ry, &x, &y, &mask)) {
	if (!(mask & Button2Mask)) break;
      }
    }
    if (!cW || cW == win) {
      clickW = win;
    } else {
      XTranslateCoordinates (dsp, rW, cW, rx, ry, &x, &y, &chwin);
      if (chwin != None) {
	clickW = client_window (dsp, chwin);
	if (!clickW || 
	    (XGetWindowAttributes (dsp, clickW, &clickxwa)     &&
	     XGetWindowAttributes (dsp, cW,     &parentxwa)    &&
	     clickxwa.visual->class == parentxwa.visual->class &&
	     clickxwa.colormap      == parentxwa.colormap      &&
	     clickxwa.depth         == parentxwa.depth)) {
	  clickW = cW;
	}
      } else {
	clickW = cW;
      }
    }
    if (clickW == win) {
      ix = iy = 0;
      iw = W;
      ih = H;
    } else {
      if (XGetGeometry (dsp, clickW, &rW, &x, &y, &rw, &rh, &rx, &ry)) {
	iw = (int) rw;
	ih = (int) rh;
	XTranslateCoordinates (dsp, clickW, win, 0, 0, &ix,&iy, &chwin);
      } else {
	ix = iy = 0;
	iw = W;
	ih = H;
	clickW = win;
      }
    }
    if (ix<0) {
      iw += ix;
      ix = 0;
    }
    if (iy<0) {
      ih += iy;
      iy = 0;
    }
    if (ix + iw > W) iw = W - ix;
    if (iy + ih > H) ih = H - iy;

    flash_start ();
    
    for (n = 0; n < 5; n++) {
      flash_rect (ix, iy, iw, ih, 1);
      XFlush (dsp);
      usleep (100000);
      flash_rect (ix, iy, iw, ih, 0);
      XFlush (dsp);
      usleep (100000);      
    }
    flash_end ();

    XUngrabButton (dsp, (u_int) AnyButton, 0, win);
    
    gwin = gdk_window_foreign_new (clickW);
    tmp = gdk_pixbuf_get_from_drawable (NULL, (GdkDrawable *) gwin,
					gdk_window_get_colormap (gwin),
					0, 0, 0, 0, iw, ih);
    pixbuf = gdk_pixbuf_align_rowstride (tmp);
    gdk_pixbuf_unref (tmp);

    sprintf (buf, "grabed-image");
    teoeyes_image_add_list (g_list_last (image_list), buf, FALSE);

    /* ȲΥ */
#if 0
    if (opt->clear_data && !opt->display_mode) {
      image_clear_image (image_list);
    }
#endif
    image_list = g_list_last (image_list);
    ti_set_pixbuf (image_list, pixbuf);
    teoeyes_image_set (ti_get_image (image_list), 0, 0, 255);      
#if 0    
    if (!opt->display_mode) {
      image_load_image (image_list, 0, opt->min, opt->max);
    }
#endif
    /* 礭 */
    gtk_widget_set_size_request (canvas, iw, ih);
    image_window_set_size (image_window, iw, ih);

    /* ꥹȥɥƤϥͥ򹹿 */
    if (list_viewer && GTK_WIDGET_VISIBLE (list_viewer)) {
      list_viewer_refresh_list (list_viewer);
    }
  } else if (mask & Button1Mask) {
    /* ܥΥ٥ (ΰΥ) */
    clickW = win;
    orgW   = cW;
    org_x  = ix = x2 = rx;
    org_y  = iy = y2 = ry;
    iw     = 0;
    ih     = 0;

    XGrabServer (dsp);
    flash_start ();

    while (1) {
      if (XQueryPointer (dsp, win, &rW, &cW, &rx, &ry, &x, &y, &mask)) {
	if (!(mask & Button1Mask)) break;
      }
      flash_rect (ix, iy, iw, ih, 0);
      if (rx != x2 || ry != y2) {
	ix = (x1 < rx) ? x1 : rx;
	iy = (y1 < ry) ? y1 : ry;
	iw = abs (rx - x1);
	ih = abs (ry - y1);
	x2 = rx;
	y2 = ry;
      }
      if (iw > 1 && ih > 1) flash_rect (ix, iy, iw, ih, 1);
    }
    flash_rect (ix, iy, iw, ih, 0);
    flash_end ();

    XUngrabServer (dsp);
    XUngrabButton (dsp, (u_int) AnyButton, 0, win);

    if (iw <= 0 || ih <= 0) return;
    
    tmp =
      gdk_pixbuf_get_from_drawable (NULL,
				    (GdkDrawable *) GDK_ROOT_PARENT (),
				    gdk_window_get_colormap(GDK_ROOT_PARENT()),
				    ix, iy, 0, 0, iw, ih);
    pixbuf = gdk_pixbuf_align_rowstride (tmp);
    gdk_pixbuf_unref (tmp);

    sprintf (buf, "grabed-image");
    teoeyes_image_add_list (g_list_last (image_list), buf, FALSE);

    /* ȲΥ */
#if 0
    if (opt->clear_data && !opt->display_mode) {
      image_clear_image (image_list);
    }
#endif
    image_list = g_list_last (image_list);
    ti_set_pixbuf (image_list, pixbuf);
    teoeyes_image_set (ti_get_image (image_list), 0, 0, 255);
#if 0
    if (!opt->display_mode) {
      image_load_image (image_list, 0, opt->min, opt->max);
    }
#endif
    /* 礭 */
    gtk_widget_set_size_request (canvas, iw, ih);
    image_window_set_size (image_window, iw, ih);

    /* ꥹȥɥƤϥͥ򹹿 */
    if (list_viewer && GTK_WIDGET_VISIBLE (list_viewer)) {
      list_viewer_refresh_list (list_viewer);
    }
  }
}

/* ******************************************************* End of grab.c *** */
