/* ************************************************************* image.c *** *
 * TEImage˴ؤؿ
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/05/15 16:05:27 sugaya>
 * ************************************************************************* */
#include <teo.h>
#include "teoeyes.h"
#include "image_io.h"
#include "teo_range.h"

/* ************************************************************************* *
 * ؿ
 * ************************************************************************* */

/* ե̾ؿ ************************************************ */
const gchar*
ti_get_filename (GList	*list) {
  gchar	*filepath;

  filepath = ti_get_file_path (list);

  return (!strrchr (filepath, '/')) ? filepath : strrchr (filepath, '/') + 1;
}

/* եѥꥹȤФ **************************************** */
GList*
ti_get_list_from_path (GList		*list,
		       const gchar	*path) {
  GList	*ilist;

  ilist = g_list_first (list);
  while (ilist) {
    if (strcmp (path, ti_get_file_path (ilist)) == 0) return ilist;
    ilist = g_list_next (ilist);
  }
  return NULL;
}

/* ͤϰϤĴ٤ؿ ************************************************ */
void
ti_get_pixel_range (GList	*list,
		    gdouble	*min,
		    gdouble	*max) {
  guchar 	*data;
  gint		n, size;
  gdouble	val;
  
  if (!ti_get_original_data (list)) {

    data = gdk_pixbuf_get_pixels (ti_get_pixbuf (list));
    size = (ti_get_width (list) * ti_get_height (list) *
	    gdk_pixbuf_get_n_channels (ti_get_pixbuf (list)));
    *min = *max = (gdouble) *data;
    if (ti_get_has_alpha (list)) {
      for (n = size/4; n > 0; n--) {
	val = (gdouble) *data++;
	if (val < *min) *min = val;
	if (val > *max) *max = val;	
	val = (gdouble) *data++;
	if (val < *min) *min = val;
	if (val > *max) *max = val;	
	val = (gdouble) *data++;
	if (val < *min) *min = val;
	if (val > *max) *max = val;	
	data++;
      }
    } else {
      for (n = size; n > 0; n--) {
	val = (gdouble) *data++;
	if (val < *min) *min = val;
	if (val > *max) *max = val;	
      }
    }
  } else {
    TeoGetPixelRange (ti_get_original_data (list), min, max);
  }
}

/* ꤵ줿ͥβؿ ********************************** */
GdkPixbuf*
ti_get_nth_plane (GList		*list,
		  gint		plane) {
  GdkPixbuf	*pixbuf;
  int		row, col;

  if (plane >= ti_get_nchannels (list)) return NULL;

  pixbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, 
			   ti_get_width (list), ti_get_height (list));
  if (!pixbuf) return NULL;

  for (row = 0; row < ti_get_height (list); row++) {
    for (col = 0; col < ti_get_width (list); col++) {
      gdk_pixbuf_put_pixel (pixbuf, col, row, 0, 
			    gdk_pixbuf_get_pixel (ti_get_pixbuf (list),
						  col, row, plane));
      gdk_pixbuf_put_pixel (pixbuf, col, row, 1, 
			    gdk_pixbuf_get_pixel (ti_get_pixbuf (list),
						  col, row, plane));
      gdk_pixbuf_put_pixel (pixbuf, col, row, 2, 
			    gdk_pixbuf_get_pixel (ti_get_pixbuf (list),
						  col, row, plane));
    }
  }
  return pixbuf;
}

/* ************************************************************************* */
void
ti_set_pixbuf (GList		*list,
	       GdkPixbuf	*pixbuf) {
  TEImage	*ti;

  ti = ti_get_image (list);
  
  if (ti->pixbuf_list) {
    g_list_foreach (ti->pixbuf_list, (GFunc) gdk_pixbuf_unref, NULL);
    ti->pixbuf_list = NULL;
    ti->pixbuf      = NULL;
  }
  ti->pixbuf_list = g_list_append (ti->pixbuf_list, pixbuf);
  ti->pixbuf 	  = (GdkPixbuf *) ti->pixbuf_list->data;
}


/* ************************************************************************* *
 * ǡؿ
 * ************************************************************************* */

/* TEImage *********************************************************** */
TEImage*
teoeyes_image_new (const gchar	*filename,
		   gboolean	external) {
  TEImage	*ti;

  /*  */
  ti = g_new (TEImage, 1);
  if (!ti) {
    g_printerr (_("Can not allocate enough memory for TEImage.\n"));
    return NULL;
  }
  /* եޥåȤĴ٤ */
  if (external && !check_image_supported (filename)) {
    g_printerr (_("The image format for '%s' is not supported.\n"), filename);
    g_free (ti);
    return NULL;
  }
  /* Ф */
  ti->filename	    	 = g_strdup (filename);
  ti->xoffset	    	 = 0;
  ti->yoffset	    	 = 0;
  ti->frame	    	 = 0;
  ti->channel	    	 = -1;
  ti->nframes	    	 = 1;
  ti->nchannels	    	 = 3;
  ti->type	    	 = TI_PIXEL_UNSIGNED;
  ti->bit	    	 = 8;
  ti->fp	    	 = NULL;
  ti->original_data_list = NULL;
  ti->original_data 	 = NULL;
  ti->pixbuf_list   	 = NULL;
  ti->pixbuf	    	 = NULL;
  ti->backup		 = NULL;
  ti->has_alpha     	 = FALSE;
  ti->external	    	 = external;

  ti->mod = g_new (GdkPixbufModifier, 1);
  ti->mod->mod.gamma		= 256;
  ti->mod->mod.brightness	= 256;
  ti->mod->mod.contrast		= 256;    
  ti->mod->rmod.gamma		= 256;
  ti->mod->rmod.brightness	= 256;
  ti->mod->rmod.contrast	= 256;    
  ti->mod->gmod.gamma		= 256;
  ti->mod->gmod.brightness	= 256;
  ti->mod->gmod.contrast	= 256;    
  ti->mod->bmod.gamma		= 256;
  ti->mod->bmod.brightness	= 256;
  ti->mod->bmod.contrast	= 256;
  ti->mod->map			= NULL;
  gdk_pixbuf_calc_map_tables (ti->mod);

  return ti;
}

/* TEImage¤ΤΥ *********************************************** */
void
teoeyes_image_free (TEImage	*ti) {
  if (ti) {
    /* ե̾ΰβ */
    if (ti->filename) g_free (ti->filename);

    /* GdkPixbufǡβ */
    if (ti->pixbuf_list) {
      g_list_foreach (ti->pixbuf_list, (GFunc) gdk_pixbuf_unref, NULL);
    }
    /* Хååץǡβ */
    if (ti->backup) gdk_pixbuf_unref (ti->backup);

    /* TEOեΥ */
    if (ti->fp) {
      TeoCloseFile ((TEOFILE *) ti->fp);
    }
    /* TEOIMAGEǡβ */
    if (ti->original_data_list) {
      g_list_foreach (ti->original_data_list, (GFunc) TeoFreeImage, NULL);
    }
    /* Modifierβ */
    if (ti->mod) {
      g_free (ti->mod->map);
      g_free (ti->mod);
    }
    g_free (ti);
  }
}

/* ߤΥꥹȤ˿ɲä ************************************** */
gboolean
teoeyes_image_add_list (GList		*list,
			const gchar	*filename,
			gboolean	external) {
  TEImage	*ti;

  /*  */
  ti = teoeyes_image_new (filename, external);
  if (!ti) return FALSE;

  /* ꥹȤɲ */
  list = g_list_append (list, (gpointer) ti);
  
  return TRUE;
}

/* ****************************************************** End of image.c *** */
