/* ****************************************************** image_window.c *** *
 * $B2hA|%&%#%s%I%&$N4X$9$k4X?t(B
 *
 * Copyright (C) 2002-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <04/06/21 15:21:15 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "cripping.h"
#include "dnd.h"
#include "draw.h"
#include "image_window.h"
#include "loope.h"
#include "pixel_info.h"
#include "plugin.h"

#include "gtkiconitemfactory.h"

/* ************************************************************************* *
 * $B%3!<%k%P%C%/4X?t(B
 *
 * cb_quit
 * cb_expose
 * cb_mouse_press
 * cb_mouse_release
 * cb_mouse_motion
 * ************************************************************************* */

/* $B%(%/%9%]!<%:%$%Y%s%H(B **************************************************** */
static void
cb_expose (GtkWidget		*widget,
	   GdkEventExpose	*ev) {
  if (ti_get_width  (image_list) != widget->allocation.width ||
      ti_get_height (image_list) != widget->allocation.height) {
    G_SET_PARAMETER (image_window, "forcescroll", TRUE);
    image_window_set_size (image_window,
		     ti_get_current_width  (image_list),
		     ti_get_current_height (image_list));
  } else {
    image_window_set_size (image_window,
		     ti_get_current_width  (image_list),
		     ti_get_current_height (image_list));
  }
}

/* $B%^%&%9%\%?%s$r2!$7$?;~$N=hM}(B ******************************************** */
static gboolean
cb_mouse_press (GtkWidget	*widget,
		GdkEventButton	*ev) {
  GtkWidget	*popup_menu;
  gint		x, y, w, h, lx, ly, scale;

  /* $B%U%)!<%+%9$N%;%C%H(B */
  if (!GTK_WIDGET_HAS_FOCUS (widget)) gtk_widget_grab_focus (widget);

  /* $B%^%&%9%]%$%s%?$N:BI83MF@(B */
  w = widget->allocation.width;
  h = widget->allocation.height;
  x = (gint) (ev->x * ti_get_width  (image_list) / w);
  y = (gint) (ev->y * ti_get_height (image_list) / h);
  G_SET_PARAMETER (image_window, "x", x);
  G_SET_PARAMETER (image_window, "y", y);

  /* $B3F%\%?%s$K@_Dj$5$l$?=hM}(B */
  switch (ev->button) {
  case MOUSE_BUTTON_LEFT:	/* $B:8%\%?%s(B */
    if (!pixel_window) pixel_window = pixel_window_new ();
    if (!GTK_WIDGET_VISIBLE (pixel_window)) gtk_widget_show_all (pixel_window);
    gdk_window_raise (pixel_window->window);
    pixel_window_show (x, y,
		       (ev->state == 1) ?
		       PIXEL_TYPE_CURRENT : PIXEL_TYPE_ORIGINAL, 
		       gdk_x11_drawable_get_xdisplay (ev->window), ev->time);

    /* CTRL$B%-!<$,2!$5$l$F$$$?$i%/%j%C%T%s%0%b!<%I$X(B */
    if (ev->state == 4) crip_mouse_press ((gint) ev->x, (gint) ev->y);

    break;
  case MOUSE_BUTTON_CENTER:	/* $BCf%\%?%s(B */
    
    if (ev->state == 4) { /* $B%/%j%C%T%s%0$N<B9T(B */
      crip_do_crip ();
    } else {
      if (!loope) loope = loope_new (_("Loope Window"),
				     LOOPE_WINDOW_SIZE, LOOPE_WINDOW_SIZE);
      if (!GTK_WIDGET_VISIBLE (loope)) gtk_widget_show (loope);

      scale = (gint) G_GET_PARAMETER (image_window, "scale");
      lx = ly = LOOPE_WINDOW_SIZE / 2 - scale;
      G_SET_PARAMETER (image_window, "lx", lx);
      G_SET_PARAMETER (image_window, "ly", ly);

      draw_loope_image (G_GET_WIDGET (loope, "canvas"),
			image_list, x, y, lx, ly, scale);
      draw_scope (widget, x, y, scale);
      if (!pixel_window) pixel_window = pixel_window_new ();
      if (!GTK_WIDGET_VISIBLE (pixel_window)) {
	gtk_widget_show_all (pixel_window);
      }
      gdk_window_raise (pixel_window->window);
      pixel_window_show (x, y,
			 (ev->state == 1) ?
			 PIXEL_TYPE_CURRENT : PIXEL_TYPE_ORIGINAL, 
			 gdk_x11_drawable_get_xdisplay (ev->window), ev->time);
    }
    break;
  case MOUSE_BUTTON_RIGHT:	/* $B1&%\%?%s(B */
    popup_menu = G_GET_WIDGET (image_window, "popup_menu");
    if (popup_menu) {
      gtk_menu_popup (GTK_MENU (popup_menu),
		      NULL, NULL, NULL, NULL, 3, ev->time);
    }
    break;
  case MOUSE_WHEEL_DOWN:	/* $B%[%$!<%k%\%?%s2<(B */
    g_printerr (_("The action mouse(%d) is not impremented yet !\n"),
		ev->button);
    break;
  case MOUSE_WHEEL_UP:		/* $B%[%$!<%k%\%?%s>e(B */
    g_printerr ("The action mouse(%d) is not impremented yet !\n",
		ev->button);
    break;
  }    
  return FALSE;
}

/* $B%^%&%9%\%?%s$r2!$7$?;~$N=hM}(B ******************************************** */
static gboolean
cb_mouse_release (GtkWidget		*widget,
		  GdkEventButton	*ev) {
  gint	in_crip;

  in_crip = (gint) G_GET_PARAMETER (image_window, "crip_do");
  if (!in_crip) {
    gdk_window_clear_area (widget->window, 0, 0,
			   widget->allocation.width, 
			   widget->allocation.height);
  }	
  return FALSE;
}

/* ************************************************************************* */
static gboolean
cb_mouse_motion (GtkWidget	*widget,
		 GdkEventMotion	*ev) {
  gint			x, y, w, h, lx, ly, ox, oy, scale;
  GdkModifierType	state;

  /* $B%^%&%9%]%$%s%?$N:BI83MF@(B */  
  if (ev->is_hint) {
    gdk_window_get_pointer (ev->window, &x, &y, &state);
    ox = x;
    oy = y;
  } else {
    x	= (gint) ev->x;
    y	= (gint) ev->y;
    ox	= x;
    oy	= y;
    state = ev->state;
  }
  w = widget->allocation.width;
  h = widget->allocation.height;
  if (x < 0)   x = 0;
  if (y < 0)   y = 0;
  if (x > w-1) x = w - 1;
  if (y > h-1) y = h - 1;  
  x = x * ti_get_width  (image_list) / w;
  y = y * ti_get_height (image_list) / h;

  /* $B3F%\%?%s$K@_Dj$5$l$?=hM}(B */  
  if ((state & GDK_BUTTON1_MASK) != 0) {	/* $B:8%\%?%s(B */
    /* $B8=:_$N:BI8$rJ]B8(B */
    G_SET_PARAMETER (image_window, "x", x);
    G_SET_PARAMETER (image_window, "y", y);

    /* $B2hAGCM$NI=<((B */    
    if (!pixel_window) pixel_window = pixel_window_new ();
    if (!GTK_WIDGET_VISIBLE (pixel_window)) gtk_widget_show_all (pixel_window);
    pixel_window_show (x, y,
		       (ev->state == 257) ?
		       PIXEL_TYPE_CURRENT : PIXEL_TYPE_ORIGINAL, 
		       gdk_x11_drawable_get_xdisplay (ev->window), ev->time);

    /* CTRL$B%-!<$,2!$5$l$F$$$?$i%/%j%C%T%s%0%b!<%I$X(B */    
    if (ev->state == 260) crip_mouse_move (ox, oy); 

  } else if ((state & GDK_BUTTON2_MASK) != 0) {	/* $BCf%\%?%s(B */
    if (!loope) loope = loope_new (_("Loope Window"),
				   LOOPE_WINDOW_SIZE, LOOPE_WINDOW_SIZE);
    if (!GTK_WIDGET_VISIBLE (loope)) gtk_widget_show (loope);

    if ((x != (gint) G_GET_PARAMETER (image_window, "x")) ||
	(y != (gint) G_GET_PARAMETER (image_window, "y"))) {

      scale = (gint) G_GET_PARAMETER (image_window, "scale");
      lx = ly = LOOPE_WINDOW_SIZE / 2 - scale;

      G_SET_PARAMETER (image_window, "x",  x);
      G_SET_PARAMETER (image_window, "y",  y);
      G_SET_PARAMETER (image_window, "lx", lx);
      G_SET_PARAMETER (image_window, "ly", ly);

      draw_loope_image (G_GET_WIDGET (loope, "canvas"),
			image_list, x, y, lx, ly, scale);
      draw_scope (widget, x, y, scale);      
    }
    if (!pixel_window) pixel_window = pixel_window_new ();
    if (!GTK_WIDGET_VISIBLE (pixel_window)) gtk_widget_show_all (pixel_window);
    pixel_window_show (x, y,
		       (ev->state == 513) ?
		       PIXEL_TYPE_CURRENT : PIXEL_TYPE_ORIGINAL, 
		       gdk_x11_drawable_get_xdisplay (ev->window), ev->time);
  }
  return FALSE;
}

/* ************************************************************************* */
#include "image_window_menu.h"

/* ************************************************************************* *
 * $B%m!<%+%k4X?t(B
 *
 * popup_menu_new
 * ************************************************************************* */

/* ************************************************************************* */
static GtkWidget*
popup_menu_new (GtkWidget	*window,
		GtkWidget	*menubar) {
  int			items, n, m;
  GtkWidget		*popup_menu, *plugin_item;
#if !HAVE_NAMAZU
  GtkWidget		*assistant_item;
#endif
  GtkIconItemFactory	*item_factory;
  GtkAccelGroup 	*accel_group;  
  gchar			*item;
  
  items = sizeof (popup_menu_items) / sizeof (popup_menu_items[0]);

  /* $B%7%g!<%H%+%C%H$r%+%9%?%^%$%:$9$k(B */
  for (m = 0, n = 0; n < items; n++) {
    item = popup_menu_items[n].item_type;
    if (strcmp (item, "<Branch>") 	!= 0	&&
	strcmp (item, "<Tearoff>") 	!= 0	&&
	strcmp (item, "<Separator>") 	!= 0	&&
	strcmp (item, "<LastBranch>") 	!= 0	&&
	strcmp (item, "<iTitle>") 	!= 0	&&
	strcmp (item, "<iBranch>") 	!= 0	&&
	strcmp (item, "<Item>")		!= 0	&&
	strcmp (popup_menu_items[n].path, N_("/Plugin")) != 0) {
      popup_menu_items[n].accelerator =
	(gchar *) (g_list_nth (tc->shortcut_accel, m)->data);
      m++;
    }
  }
  /* $B%a%K%e!<$r@8@.$9$k(B */
  accel_group = gtk_accel_group_new ();  
  item_factory
    = gtk_icon_item_factory_new (GTK_TYPE_MENU, "<sub>", accel_group);

  gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);  
  gtk_icon_item_factory_set_translate_func 
    (item_factory, (GtkTranslateFunc) gettext, NULL, NULL);
  
  gtk_icon_item_factory_create_items (item_factory,
				      items, popup_menu_items, NULL);
  popup_menu = gtk_icon_item_factory_get_widget (item_factory, "<sub>");
#if !HAVE_NAMAZU
  assistant_item 
    = gtk_icon_item_factory_get_widget (item_factory,
					N_("/Window/Assistant"));
  gtk_widget_set_sensitive (assistant_item, FALSE);
#endif
  plugin_item = gtk_icon_item_factory_get_widget (item_factory, N_("/Plugin"));

  plugin_menu_new (GTK_MENU_ITEM (menubar), GTK_MENU_ITEM (plugin_item));

  return popup_menu;
}

/* ************************************************************************* *
 * $B%0%m!<%P%k4X?t(B
 *
 * image_window_set_size
 * image_window_new
 * ************************************************************************* */

/* $B%9%/%m!<%k5!G=IU$-%&%#%s%I%&$NI=<((B ************************************** */
void
image_window_set_size (GtkWidget	*widget,
		       gint		width,
		       gint		height) {
  GtkWidget	*canvas;
  GtkWidget	*scroll_window;
  GtkWidget	*box;
  GtkWidget	*alignment;
  gboolean	scrollable;
  gboolean	forcescroll;
  gint		rw, rh;

  /* $B%&%#%8%'%C%H$N3MF@(B */
  canvas 	= G_GET_WIDGET (widget, "canvas");
  scroll_window = G_GET_WIDGET (widget, "scroll_window");
  box		= G_GET_WIDGET (widget, "image_box");
  alignment	= G_GET_WIDGET (widget, "alignment");

  /* $B%Q%i%a!<%?$N3MF@(B */
  scrollable  = (gboolean) G_GET_PARAMETER (widget, "scrollable");
  forcescroll = (gboolean) G_GET_PARAMETER (widget, "forcescroll");

  /* $BBg$-$5$N@_Dj(B */
  ti_set_current_width  (image_list, width);
  ti_set_current_height (image_list, height);  
  
  /* $B2hLL%5%$%:$N3MF@(B */
  gdk_window_get_size (GDK_ROOT_PARENT (), &rw, &rh);

  /* $B%9%/%m!<%k%P!<$,I=<($5$l$F$$$J$$>l9g(B...
     $B2hA|%5%$%:$,2hLL%5%$%:$h$jBg$-$+$C$?$i(B */
  if (!scrollable) {
    if (width > rw && height > rh) {
      gtk_widget_set_size_request (widget, rw - 64, rh - 64);
    } else if (width > rw) {
      gtk_widget_set_size_request (widget, rw - 64, height - 32);      
    } else if (height > rh) {
      gtk_widget_set_size_request (widget, width - 32, rh - 64);
    }
  }
  if (width > rw || height > rh || forcescroll) {
    if (!scrollable) {
      gtk_window_set_policy (GTK_WINDOW (widget), TRUE, TRUE, FALSE);
      gtk_widget_show (scroll_window);
      gtk_widget_reparent (canvas, alignment);
      gtk_widget_set_size_request (scroll_window, -1, -1);
      gtk_widget_set_size_request (canvas, width, height);
      G_SET_PARAMETER (widget, "scrollable", TRUE);
    }
  }
  /* $B2hA|$NIA2h(B */
  draw_image (image_list, width, height);
}

/* ************************************************************************* */
GtkWidget*
image_window_new (const gchar	*title,
		  gint		width,
		  gint		height) {
  GtkWidget		*window;
  GtkWidget		*box;
  GtkWidget		*hbox;
  GtkWidget		*scroll_window;
  GtkWidget		*alignment;
  GtkWidget		*canvas;
  GtkWidget		*menubar;
  GtkWidget		*plugin_item;
  GtkWidget		*popup_menu;
#if !HAVE_NAMAZU
  GtkWidget		*assistant_item;
#endif
  GtkIconItemFactory	*item_factory;
  gint			nmenu_items;

  /* $B%&%#%s%I%&$N@8@.(B */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (window, width, height);
  
  /* $B%&%#%s%I%&%/%i%9$NEPO?(B */
  gtk_window_set_wmclass (GTK_WINDOW (window), "teoeyes", "Teo Image Viewer");

  /* $B%?%$%H%k$N@_Dj(B */
  gtk_window_set_title (GTK_WINDOW (window), title);

  /* $B%\!<%@%5%$%:$N@_Dj(B */
  gtk_container_set_border_width (GTK_CONTAINER (window), 0);

  /* $B%j%5%$%:$N@_Dj(B */
  gtk_window_set_resizable (GTK_WINDOW (window), TRUE);

  /* $B%$%Y%s%H$N@_Dj(B */
#if 0
  g_signal_connect (G_OBJECT (window), "delete_event",
		    G_CALLBACK (cb_quit), NULL);
#endif
  g_signal_connect (G_OBJECT (window), "destroy",
		    G_CALLBACK (cb_quit), NULL);

  box = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), box);
  {
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (box), hbox, FALSE, FALSE, 0);
    {
      /* $B%a%K%e!<%P!<$N@8@.(B */
      nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);     
      item_factory
	= gtk_icon_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", NULL);
      gtk_icon_item_factory_set_translate_func 
	(item_factory, (GtkTranslateFunc) gettext, NULL, NULL);
      gtk_icon_item_factory_create_items (item_factory,
					  nmenu_items, menu_items, NULL);
      menubar = gtk_icon_item_factory_get_widget (item_factory, "<main>");
      gtk_box_pack_start (GTK_BOX (hbox), menubar, TRUE, TRUE, 0);
#if !HAVE_NAMAZU
      assistant_item 
	= gtk_icon_item_factory_get_widget (item_factory,
					    N_("/Window/Assistant"));
      gtk_widget_set_sensitive (assistant_item, FALSE);
#endif
      plugin_item
	= gtk_icon_item_factory_get_widget (item_factory, N_("/Plugin"));
    }
    /* $B%-%c%s%P%9$N@8@.(B */
    canvas = gtk_drawing_area_new ();
    gtk_box_pack_start (GTK_BOX (box), canvas, TRUE, TRUE, 0);
    gtk_widget_set_size_request (canvas, width, height);

    /* $B%$%Y%s%H$N@_Dj(B */
    gtk_widget_set_events (canvas,
			   GDK_EXPOSURE_MASK |
			   GDK_BUTTON_PRESS_MASK |
			   GDK_BUTTON_RELEASE_MASK |
			   GDK_POINTER_MOTION_MASK |
			   GDK_POINTER_MOTION_HINT_MASK);

    /* $B%3!<%k%P%C%/4X?t$N@_Dj(B */
    g_signal_connect (G_OBJECT (canvas), "expose_event",
		      G_CALLBACK (cb_expose),		NULL);
    g_signal_connect (G_OBJECT (canvas), "button_press_event",
		      G_CALLBACK (cb_mouse_press),	NULL);
    g_signal_connect (G_OBJECT (canvas), "button_release_event",
		      G_CALLBACK (cb_mouse_release),	NULL);
    g_signal_connect (G_OBJECT (canvas), "motion_notify_event",
		      G_CALLBACK (cb_mouse_motion),	NULL);

    
    /* $B%9%/%m!<%k%&%#%s%I%&$N@8@.(B */
    scroll_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start (GTK_BOX (box), scroll_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll_window),
				    GTK_POLICY_AUTOMATIC,
				    GTK_POLICY_AUTOMATIC);
    {
      /* $B%"%i%$%s%a%s%H$N@8@.(B */
      alignment = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
      gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW
					     (scroll_window), alignment);
    }
  }
  /* $B%]%C%W%"%C%W%a%K%e!<$N@8@.(B */
  popup_menu = popup_menu_new (window, plugin_item);

  /* $B%I%i%C%0(B&$B%I%m%C%W$N@_Dj(B */
  dnd_drop_on_widget (window);
  
  /* $B%"%$%3%s$NEPO?(B */
  gtk_widget_realize (window);
  te_icon = gdk_pixbuf_new_from_inline (-1, teoeyes_icon, FALSE, NULL);
  gtk_window_set_icon (GTK_WINDOW (window), te_icon);
  gdk_window_set_icon_name (window->window, _("TeoEyes"));
  
  /* $B%&%#%8%'%C%H$NEPO?(B */
  G_SET_WIDGET (window, "image_box",		box);
  G_SET_WIDGET (window, "canvas",	 	canvas);
  G_SET_WIDGET (window, "hbox", 		hbox);  
  G_SET_WIDGET (window, "scroll_window",	scroll_window); 
  G_SET_WIDGET (window, "popup_menu",		popup_menu);
  G_SET_WIDGET (window, "menubar",		menubar);
  G_SET_WIDGET (window, "alignment",		alignment); 

  /* $B%Q%i%a!<%?$NEPO?(B */
  G_SET_PARAMETER (window, "scrollable",	FALSE);
  G_SET_PARAMETER (window, "forcescroll",	FALSE);
  G_SET_PARAMETER (window, "show_meunbar",	FALSE);
  G_SET_PARAMETER (window, "x",			0);
  G_SET_PARAMETER (window, "y",			0);
  G_SET_PARAMETER (window, "lx", LOOPE_WINDOW_SIZE / 2 - tc->loope_scale);
  G_SET_PARAMETER (window, "ly", LOOPE_WINDOW_SIZE / 2 - tc->loope_scale);
  G_SET_PARAMETER (window, "scale",		tc->loope_scale);

  gtk_widget_show_all (window);
  gtk_widget_hide (scroll_window);
  gtk_widget_hide (menubar);
  
  return window;
}

/* *********************************************** End of image_window.c *** */
