/* *************************************************************** xml.h *** *
 * XML˴ؤؿ إåե
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/03/02 00:00:36 sugaya>
 * ************************************************************************* */
#ifndef	__XML_H__
#define	__XML_H__

#include <glib.h>
#include <stdio.h>

#define	XMLBUFSIZE	8192

typedef struct _XMLAttr {
  gchar		*name;
  gchar		*value;
} XMLAttr;

typedef struct _XMLTag {
  gchar		*tag;
  GList		*attr;
} XMLTag;

typedef struct _XMLNode {
  XMLTag	*tag;
  gchar		*element;
} XMLNode;

typedef struct _XMLFile {
  FILE		*fp;
  GString	*buf;
  gchar		*bufp;
  gchar		*dtd;
  GList		*tag_stack;
  guint		level;
  gboolean	is_empty_element;
} XMLFile;

/* ************************************************************************* */
XMLFile*	xml_open_file		(const gchar	*path);
void		xml_close_file		(XMLFile	*file);
GNode*		xml_parse_file		(const gchar	*path);

gint		xml_get_dtd		(XMLFile	*file);
gint		xml_parse_next_tag	(XMLFile	*file);
void		xml_push_tag		(XMLFile	*file,
					 XMLTag		*tag);
void		xml_pop_tag		(XMLFile	*file);

XMLTag*		xml_get_current_tag	(XMLFile	*file);
GList*		xml_get_current_tag_attr(XMLFile	*file);
gchar*		xml_get_element		(XMLFile	*file);

gint		xml_read_line		(XMLFile	*file);
void		xml_truncate_buf	(XMLFile	*file);
gboolean	xml_compare_tag		(XMLFile	*file,
					 const gchar	*name);

XMLTag*		xml_copy_tag		(XMLTag		*tag);
XMLAttr*	xml_copy_attr		(XMLAttr	*attr);

gint 		xml_unescape_str	(gchar		*str);
gint 		xml_file_put_escape_str	(FILE		*fp,
					 const gchar	*str);

void		xml_free_node		(XMLNode	*node);
void		xml_free_tree		(GNode		*node);

#endif	/* __XML_H__ */

/* *************************************************************** xml.h *** */
