/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.access;

import javax.naming.NamingException;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.ejb.access.LocalSlsbInvokerInterceptor;
import org.springframework.util.ClassUtils;

public class LocalStatelessSessionProxyFactoryBean
extends LocalSlsbInvokerInterceptor
implements FactoryBean,
BeanClassLoaderAware {
    private Class businessInterface;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Object proxy;

    public void setBusinessInterface(Class businessInterface) {
        this.businessInterface = businessInterface;
    }

    public Class getBusinessInterface() {
        return this.businessInterface;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void afterPropertiesSet() throws NamingException {
        super.afterPropertiesSet();
        if (this.businessInterface == null) {
            throw new IllegalArgumentException("businessInterface is required");
        }
        this.proxy = new ProxyFactory(this.businessInterface, this).getProxy(this.beanClassLoader);
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class getObjectType() {
        return this.businessInterface;
    }

    public boolean isSingleton() {
        return true;
    }
}

