/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.transaction;

import com.ibatis.common.util.Throttle;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionConfig;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import com.ibatis.sqlmap.engine.transaction.TransactionState;
import java.sql.SQLException;
import javax.sql.DataSource;

public class TransactionManager {
    private TransactionConfig transactionConfig;
    private boolean forceCommit;
    private Throttle txThrottle;

    public TransactionManager(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
        this.txThrottle = new Throttle(transactionConfig.getMaximumConcurrentTransactions());
    }

    public void begin(SessionScope session) throws SQLException, TransactionException {
        this.begin(session, -9999);
    }

    public void begin(SessionScope session, int transactionIsolation) throws SQLException, TransactionException {
        Transaction trans = session.getTransaction();
        TransactionState state = session.getTransactionState();
        if (state == TransactionState.STATE_STARTED) {
            throw new TransactionException("TransactionManager could not start a new transaction.  A transaction is already started.");
        }
        if (state == TransactionState.STATE_USER_PROVIDED) {
            throw new TransactionException("TransactionManager could not start a new transaction.  A user provided connection is currently being used by this session.  The calling .setUserConnection (null) will clear the user provided transaction.");
        }
        this.txThrottle.increment();
        try {
            trans = this.transactionConfig.newTransaction(transactionIsolation);
            session.setCommitRequired(false);
        }
        catch (SQLException e) {
            this.txThrottle.decrement();
            throw e;
        }
        catch (TransactionException e) {
            this.txThrottle.decrement();
            throw e;
        }
        session.setTransaction(trans);
        session.setTransactionState(TransactionState.STATE_STARTED);
    }

    public void commit(SessionScope session) throws SQLException, TransactionException {
        Transaction trans = session.getTransaction();
        TransactionState state = session.getTransactionState();
        if (state == TransactionState.STATE_USER_PROVIDED) {
            throw new TransactionException("TransactionManager could not commit.  A user provided connection is currently being used by this session.  You must call the commit() method of the Connection directly.  The calling .setUserConnection (null) will clear the user provided transaction.");
        }
        if (state != TransactionState.STATE_STARTED && state != TransactionState.STATE_COMMITTED) {
            throw new TransactionException("TransactionManager could not commit.  No transaction is started.");
        }
        if (session.isCommitRequired() || this.forceCommit) {
            trans.commit();
            session.setCommitRequired(false);
        }
        session.setTransactionState(TransactionState.STATE_COMMITTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(SessionScope session) throws SQLException, TransactionException {
        Transaction trans = session.getTransaction();
        TransactionState state = session.getTransactionState();
        if (state == TransactionState.STATE_USER_PROVIDED) {
            throw new TransactionException("TransactionManager could not end this transaction.  A user provided connection is currently being used by this session.  You must call the rollback() method of the Connection directly.  The calling .setUserConnection (null) will clear the user provided transaction.");
        }
        try {
            if (trans != null) {
                try {
                    if (state != TransactionState.STATE_COMMITTED && (session.isCommitRequired() || this.forceCommit)) {
                        trans.rollback();
                        session.setCommitRequired(false);
                    }
                }
                finally {
                    session.closePreparedStatements();
                    trans.close();
                }
            }
            Object var6_5 = null;
            if (state != TransactionState.STATE_ENDED) {
                this.txThrottle.decrement();
            }
            session.setTransaction(null);
            session.setTransactionState(TransactionState.STATE_ENDED);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (state != TransactionState.STATE_ENDED) {
                this.txThrottle.decrement();
            }
            session.setTransaction(null);
            session.setTransactionState(TransactionState.STATE_ENDED);
            throw throwable;
        }
    }

    public DataSource getDataSource() {
        return this.transactionConfig.getDataSource();
    }

    public void setDataSource(DataSource ds) {
        this.transactionConfig.setDataSource(ds);
    }

    public boolean isForceCommit() {
        return this.forceCommit;
    }

    public void setForceCommit(boolean forceCommit) {
        this.forceCommit = forceCommit;
    }
}

