/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.messageex.web.action;

import java.util.Map;

import jp.terasoluna.thin.functionsample.messageex.bean.MessageExOriginalParam;
import jp.terasoluna.thin.functionsample.messageex.service.MessageExOriginalService;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;

/**
 * ŗLbZ[WANV
 *
 */
public class MessageExOriginalAction 
                extends AbstractBLogicAction<MessageExOriginalParam>{
    
    /**
     * ŗLbZ[WL[ݒNX錾
     */
    private MessageExOriginalService originalService ;

    /**
     * 1DT[rXNX̎s\bhďoĊebZ[W\[X̌ŗLbZ[WL[ݒ肷B<br>
     * 2Dݒ肵bZ[WL[}bv烁bZ[WL[擾ăbZ[Wݒ肷B
     * 2.1. }bvɗD揇1ԖMessageResourcešŗLbZ[Wݒ肷B<br>
     * 2.2. }bvɗD揇2ԖDB̌ŗLbZ[Wݒ肷B<br>
     * 2.3. }bvɗD揇3Ԗapplication-messagešŗLbZ[Wݒ肷B<br>
     * 2.4. }bvɗD揇4Ԗsystem-messagešŗLbZ[Wݒ肷B<br>
     * @param param ŗLbZ[WANVpp^[NX
     * @return bZ[WL[}bv
     */
    @Override
    public BLogicResult doExecuteBLogic(MessageExOriginalParam param) 
                                                    throws Exception {
    	BLogicResult result = new BLogicResult();
    	BLogicMessages msg = new BLogicMessages();
        
        // i[ŃbZ[WL[ݒ肷B
        Map<String, String> msgKey = originalService.execute(param);
        
        /*
         * ŗLbZ[WD揇ʏɐݒ肷B
         */
        msg.add("first", new BLogicMessage(msgKey.get("first")));
        msg.add("second", new BLogicMessage(msgKey.get("second")));
        msg.add("third", new BLogicMessage(msgKey.get("third")));
        msg.add("fourth", new BLogicMessage(msgKey.get("fourth")));
        
        result.setMessages(msg);
        result.setResultString("success");
        return result;
    }

    /**
     * ŗLbZ[WL[ݒNX擾B
     * @return ŗLbZ[WL[ݒNX
     */
    public MessageExOriginalService getOriginalService() {
        return originalService;
    }

    /**
     * ŗLbZ[WL[ݒNXݒ肷B
     * @param originalService ŗLbZ[WL[ݒNX
     */
    public void setOriginalService(MessageExOriginalService originalService) {
        this.originalService = originalService;
    }
}