/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.orm.ibatis.support;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.ibatis.support.AbstractLobTypeHandler;

/**
 * iBATIS痘pBLOBƃXg[}bsOiBATIS̃^CvnhB
 *
 * <p>
 * BLOBoCgzƂĈꍇA{NX𗘗pKvȂB
 * oCgzƂĈƁA
 * BLOBňf[^ŃG[A
 * \vȂꍇ̂݁A{NX𗘗p邱ƁB
 * </p>
 *
 * <p>
 * Spring񋟂ĂLobHandler𗘗pĂ邽߁A
 * {NX𗘗p邽߂ɂ́ALobHandlerBean`sqlMapClientFactoryBeanւ̐ݒsƁB
 * ȂALobHandler̎NX́ASpring񋟂ĂB<br>
 *  Oraclȅꍇ́AOracleLobHandlerȂ̏ꍇ́ADefaultLobHandler𗘗p邱ƁB
 * </p>
 *
 * <p>
 *  y<code>Bean`t@C</code>̐ݒz<br>
 * <code><pre>
 *   &lt;!-- LOBtB[h߂̃nh --&gt;
 *   &lt;bean id="oracleLobHandler"
 *            class="org.springframework.jdbc.support.lob.OracleLobHandler"&gt;
 *     &lt;property name="nativeJdbcExtractor" ref="simpleExtractor"/&gt;
 *   &lt;/bean&gt;
 *
 *   &lt;!-- iBATIS f[^x[Xŵ߂SQlMap̐ݒ --&gt;
 *   &lt;bean id="sqlMapClient"
 *       class="org.springframework.orm.ibatis.SqlMapClientFactoryBean"&gt;
 *     &lt;property name="configLocation" value="WEB-INF/sql-map-config.xml"/&gt;
 *     &lt;property name="dataSource" ref="dataSource"/&gt;
 *     &lt;property name="lobHandler" ref="oracleLobHandler"/&gt;
 *   &lt;/bean&gt;
 * </pre></code>
 * </p>
 *
 * <p>
 * {NX𗘗piBATISݒt@C̋Lq@ȉɂ߂B
 * </p>
 *
 * <p>
 *  yBLOB_TESTe[u`z<br>
 *   <table border="1" CELLPADDING="8">
 *     <th></th>
 *     <th>^</th>
 *     <th></th>
 *
 *     <tr>
 *       <td align=center>PK</td>
 *       <td>INTEGER</td>
 *       <td>NOT NULL</td>
 *     </tr>
 *
 *     <tr>
 *       <td align=center>MAP</td>
 *       <td>BLOB</td>
 *       <td>NOT NULL</td>
 *     </tr>
 *  </table>
 * </p>
 *
 * <p>
 *  y<code>iBATISݒt@C</code>̐ݒz<br>
 * <code><pre>
 * &lt;!-- update̐ݒ --&gt;
 * &lt;parameterMap id="blobParam" class="java.util.Map"&gt;
 *   &lt;parameter property="pk"/&gt;
 *   &lt;parameter property="map"
 *       typeHandler="jp.terasoluna.fw.orm.ibatis.support.BlobInputStreamTypeHandler"/&gt;
 * &lt;/parameterMap&gt;
 *
 * &lt;insert id="insertBLobTest" parameterMap="blobParam"&gt;
 *   INSERT INTO BLOB_TEST (PK, MAP) VALUES (?, ?)
 * &lt;/insert&gt;
 *
 * &lt;!-- select̐ݒ --&gt;
 * &lt;resultMap id="blobResult" class="java.util.HashMap"&gt;
 *   &lt;result property="pk"/&gt;
 *   &lt;result property="map"
 *       typeHandler="jp.terasoluna.fw.orm.ibatis.support.BlobInputStreamTypeHandler"/&gt;
 * &lt;/resultMap&gt;
 *
 * &lt;select id="selectBLobTest" resultMap="blobResult"&gt;
 *   SELECT PK, MAP FROM BLOB_TEST
 * &lt;/select&gt;
 * </pre></code>
 * </p>
 *
 */
public class BlobInputStreamTypeHandler extends AbstractLobTypeHandler {

    /**
     * RXgN^B
     */
    public BlobInputStreamTypeHandler() {
        super();
    }

    /**
     * RXgN^B
     * @param lobHandler LobHandler
     */
    protected BlobInputStreamTypeHandler(LobHandler lobHandler) {
        super(lobHandler);
    }

    /**
     * p[^ݒ肷B
     *
     * @param ps ZbgPreparedStatement
     * @param index p[^̃CfbNX
     * @param value Zbgp[^
     * @param jdbcType p[^JDBC^
     * @param lobCreator pLobCreator
     * @throws SQLException SQLO
     */
    @Override
    protected void setParameterInternal(
            PreparedStatement ps,
            int index,
            Object value,
            String jdbcType,
            LobCreator lobCreator)
                throws SQLException {
        lobCreator.setBlobAsBinaryStream(ps, index, (InputStream) value, 0);
    }

    /**
     * ʂ擾B
     * @param rs 擾ResultSet
     * @param index ResultSet̃CfbNX
     * @param lobHandler pLobHandler
     * @return 擾
     * @throws SQLException SQLO
     */
    @Override
    protected Object getResultInternal(
            ResultSet rs,
            int index,
            LobHandler lobHandler)
                throws SQLException {
        return lobHandler.getBlobAsBinaryStream(rs, index);
    }

    /**
     * {Handler^ɕϊB
     * @param s 
     * @return Handler^̃CX^X
     */
    public Object valueOf(String s) {
        if (s == null) {
            return null;
        }
        return new ByteArrayInputStream(s.getBytes());
    }
}
