/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseResultSet;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Field;
import org.postgresql.jdbc2.AbstractJdbc2ResultSet;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class AbstractJdbc2Array {
    private BaseConnection conn = null;
    private Field field = null;
    private BaseResultSet rs;
    private int idx = 0;
    private String rawString = null;

    public AbstractJdbc2Array(BaseConnection conn, int idx, Field field, BaseResultSet rs) throws SQLException {
        this.conn = conn;
        this.field = field;
        this.rs = rs;
        this.idx = idx;
        this.rawString = rs.getFixedString(idx);
    }

    public Object getArray() throws SQLException {
        return this.getArrayImpl(1L, 0, null);
    }

    public Object getArray(long index, int count) throws SQLException {
        return this.getArrayImpl(index, count, null);
    }

    public Object getArrayImpl(Map map) throws SQLException {
        return this.getArrayImpl(1L, 0, map);
    }

    public Object getArrayImpl(long index, int count, Map map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
        }
        if (index < 1L) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}", new Long(index)), PSQLState.DATA_ERROR);
        }
        Object[] retVal = null;
        ArrayList<String> array = new ArrayList<String>();
        if (this.rawString != null && !this.rawString.equals("{}")) {
            char[] chars = this.rawString.toCharArray();
            StringBuffer sbuf = new StringBuffer();
            boolean foundOpen = false;
            boolean insideString = false;
            boolean isQuoted = false;
            boolean haveMinServerVersion82 = this.conn.haveMinimumServerVersion("8.2");
            int startOffset = 0;
            if (chars[0] == '[') {
                while (chars[startOffset] != '=') {
                    ++startOffset;
                }
                ++startOffset;
            }
            for (int i = startOffset; i < chars.length; ++i) {
                if (chars[i] == '\\') {
                    ++i;
                } else {
                    if (!insideString && chars[i] == '{') {
                        if (foundOpen) {
                            throw new PSQLException(GT.tr("Multi-dimensional arrays are currently not supported."), PSQLState.NOT_IMPLEMENTED);
                        }
                        foundOpen = true;
                        continue;
                    }
                    if (chars[i] == '\"') {
                        insideString = !insideString;
                        isQuoted = true;
                        continue;
                    }
                    if (!insideString && (chars[i] == ',' || chars[i] == '}') || i == chars.length - 1) {
                        if (chars[i] != '\"' && chars[i] != '}' && chars[i] != ',') {
                            sbuf.append(chars[i]);
                        }
                        array.add((String)(sbuf.toString().equals("NULL") && !isQuoted && haveMinServerVersion82 ? null : sbuf.toString()));
                        sbuf = new StringBuffer();
                        isQuoted = false;
                        continue;
                    }
                }
                sbuf.append(chars[i]);
            }
        }
        String[] arrayContents = array.toArray(new String[array.size()]);
        if (count == 0) {
            count = arrayContents.length;
        }
        if (--index + (long)count > (long)arrayContents.length) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1}.", new Object[]{new Long(index + (long)count), new Long(arrayContents.length)}), PSQLState.DATA_ERROR);
        }
        int i = 0;
        Object cal = null;
        switch (this.getBaseType()) {
            case -7: {
                retVal = new boolean[count];
                while (count > 0) {
                    retVal[i++] = AbstractJdbc2ResultSet.toBoolean(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 4: 
            case 5: {
                retVal = new int[count];
                while (count > 0) {
                    ((int[])retVal)[i++] = AbstractJdbc2ResultSet.toInt(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case -5: {
                retVal = new long[count];
                while (count > 0) {
                    ((long[])retVal)[i++] = AbstractJdbc2ResultSet.toLong(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 2: {
                retVal = new BigDecimal[count];
                while (count > 0) {
                    ((BigDecimal[])retVal)[i++] = AbstractJdbc2ResultSet.toBigDecimal(arrayContents[(int)index++], -1);
                    --count;
                }
                break;
            }
            case 7: {
                retVal = new float[count];
                while (count > 0) {
                    ((float[])retVal)[i++] = AbstractJdbc2ResultSet.toFloat(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 8: {
                retVal = new double[count];
                while (count > 0) {
                    ((double[])retVal)[i++] = AbstractJdbc2ResultSet.toDouble(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 1: 
            case 12: {
                retVal = new String[count];
                while (count > 0) {
                    ((String[])retVal)[i++] = arrayContents[(int)index++];
                    --count;
                }
                break;
            }
            case 91: {
                retVal = new Date[count];
                while (count > 0) {
                    ((Date[])retVal)[i++] = this.conn.getTimestampUtils().toDate(null, arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 92: {
                retVal = new Time[count];
                while (count > 0) {
                    ((Time[])retVal)[i++] = this.conn.getTimestampUtils().toTime(null, arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 93: {
                retVal = new Timestamp[count];
                while (count > 0) {
                    ((Timestamp[])retVal)[i++] = this.conn.getTimestampUtils().toTimestamp(null, arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            default: {
                if (this.conn.getLogger().logDebug()) {
                    this.conn.getLogger().debug("getArrayImpl(long,int,Map) with " + this.getBaseTypeName());
                }
                throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
            }
        }
        return retVal;
    }

    public int getBaseType() throws SQLException {
        return this.conn.getSQLType(this.getBaseTypeName());
    }

    public String getBaseTypeName() throws SQLException {
        String fType = this.conn.getPGType(this.field.getOID());
        if (fType.charAt(0) == '_') {
            fType = fType.substring(1);
        }
        return fType;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getResultSetImpl(1L, 0, null);
    }

    public ResultSet getResultSet(long index, int count) throws SQLException {
        return this.getResultSetImpl(index, count, null);
    }

    public ResultSet getResultSetImpl(Map map) throws SQLException {
        return this.getResultSetImpl(1L, 0, map);
    }

    private void fillIntegerResultSet(long index, int[] intArray, Vector rows) throws SQLException {
        for (int i = 0; i < intArray.length; ++i) {
            byte[][] tuple = new byte[2][0];
            tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
            tuple[1] = this.conn.encodeString(Integer.toString(intArray[i]));
            rows.addElement(tuple);
        }
    }

    private void fillStringResultSet(long index, String[] strArray, Vector rows) throws SQLException {
        for (int i = 0; i < strArray.length; ++i) {
            byte[][] tuple = new byte[2][0];
            tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
            tuple[1] = this.conn.encodeString(strArray[i]);
            rows.addElement(tuple);
        }
    }

    public ResultSet getResultSetImpl(long index, int count, Map map) throws SQLException {
        Object array = this.getArrayImpl(index, count, map);
        Vector<byte[][]> rows = new Vector<byte[][]>();
        Field[] fields = new Field[2];
        fields[0] = new Field("INDEX", 21);
        switch (this.getBaseType()) {
            case -7: {
                boolean[] booleanArray = (boolean[])array;
                fields[1] = new Field("VALUE", 16);
                for (int i = 0; i < booleanArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(booleanArray[i] ? "YES" : "NO");
                    rows.addElement(tuple);
                }
                break;
            }
            case 5: {
                fields[1] = new Field("VALUE", 21);
                this.fillIntegerResultSet(index, (int[])array, rows);
                break;
            }
            case 4: {
                fields[1] = new Field("VALUE", 23);
                this.fillIntegerResultSet(index, (int[])array, rows);
                break;
            }
            case -5: {
                long[] longArray = (long[])array;
                fields[1] = new Field("VALUE", 20);
                for (int i = 0; i < longArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(Long.toString(longArray[i]));
                    rows.addElement(tuple);
                }
                break;
            }
            case 2: {
                BigDecimal[] bdArray = (BigDecimal[])array;
                fields[1] = new Field("VALUE", 1700);
                for (int i = 0; i < bdArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(bdArray[i].toString());
                    rows.addElement(tuple);
                }
                break;
            }
            case 7: {
                float[] floatArray = (float[])array;
                fields[1] = new Field("VALUE", 700);
                for (int i = 0; i < floatArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(Float.toString(floatArray[i]));
                    rows.addElement(tuple);
                }
                break;
            }
            case 8: {
                double[] doubleArray = (double[])array;
                fields[1] = new Field("VALUE", 701);
                for (int i = 0; i < doubleArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(Double.toString(doubleArray[i]));
                    rows.addElement(tuple);
                }
                break;
            }
            case 1: {
                fields[1] = new Field("VALUE", 1042);
                this.fillStringResultSet(index, (String[])array, rows);
                break;
            }
            case 12: {
                fields[1] = new Field("VALUE", 1043);
                this.fillStringResultSet(index, (String[])array, rows);
                break;
            }
            case 91: {
                Date[] dateArray = (Date[])array;
                fields[1] = new Field("VALUE", 1082);
                for (int i = 0; i < dateArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(this.conn.getTimestampUtils().toString(null, dateArray[i]));
                    rows.addElement(tuple);
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])array;
                fields[1] = new Field("VALUE", 1083);
                for (int i = 0; i < timeArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(this.conn.getTimestampUtils().toString(null, timeArray[i]));
                    rows.addElement(tuple);
                }
                break;
            }
            case 93: {
                Timestamp[] timestampArray = (Timestamp[])array;
                fields[1] = new Field("VALUE", 1184);
                for (int i = 0; i < timestampArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(this.conn.getTimestampUtils().toString(null, timestampArray[i]));
                    rows.addElement(tuple);
                }
                break;
            }
            default: {
                if (this.conn.getLogger().logDebug()) {
                    this.conn.getLogger().debug("getResultSetImpl(long,int,Map) with " + this.getBaseTypeName());
                }
                throw Driver.notImplemented(this.getClass(), "getResultSetImpl(long,int,Map)");
            }
        }
        BaseStatement stat = (BaseStatement)this.conn.createStatement(1004, 1007);
        return stat.createDriverResultSet(fields, rows);
    }

    public String toString() {
        return this.rawString;
    }
}

