/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.commonj.usequeue;

import commonj.work.WorkItem;
import commonj.work.WorkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.standard.StandardWorkQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkManagerTaskWorkQueue
extends StandardWorkQueue {
    private List<WorkItem> workItemList = new ArrayList<WorkItem>();
    private WorkManager workManager = null;
    private long workTimeout = Long.MAX_VALUE;

    public WorkManagerTaskWorkQueue(int queueLength, JobStatus jobStatus) {
        super(queueLength, jobStatus);
    }

    @Override
    public void waitForAllWorkers() {
        try {
            this.workManager.waitForAll(this.workItemList, this.workTimeout);
        }
        catch (IllegalArgumentException e) {
            throw new JobException(e);
        }
        catch (InterruptedException e) {
            throw new JobException(e);
        }
    }

    public void addWorkItem(WorkItem workItem) {
        this.workItemList.add(workItem);
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public void setWorkTimeout(long workTimeout) {
        this.workTimeout = workTimeout;
    }

    @Override
    public void addFutureJobResult(Future<?> futureResult) {
        throw new UnsupportedOperationException();
    }
}

