/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.sample.job01;

import jp.terasoluna.fw.batch.core.AbstractCollector;
import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.dao.FileQueryDAO;

/**
 * f[^C|[gRN^NX
 */
public class NyukinImportCollector extends AbstractCollector {

    /**
     * t@CANZXpDAOB
     * SpringɂCX^Xݒ肳B
     */
    private FileQueryDAO fileQueryDAO = null;
    
    /**
     * ʃNXB
     * SpringɂCX^Xݒ肳B
     */
    private Object resultClass = null;

         
    @Override
    protected CollectorResult doCollect(JobContext jobContext,
        CollectedDataHandler handler, JobStatus jobStatus) throws FileException {

        // ύs̃JEg
        int collected = 0;
        
        //t@CsIuWFNgێCe[^擾
        //(t@C̓WuReLXg擾)
        DBJobContext dbJobContext = (DBJobContext) jobContext;
        FileLineIterator fileLineIterator = fileQueryDAO.execute(dbJobContext.getFileName(), 
           resultClass.getClass());
        try {
            
            //t@CsIuWFNg
            while (fileLineIterator.hasNext()) {
        	    Object object = fileLineIterator.next();
        	    if (object != null) {
        	    	handler.handle(object, collected++);
        	    	jobStatus.incrementCollected();
        	    }
            }
            
            //RN^[ʃIuWFNgԋpB
            CollectorResult result = new CollectorResult(ReturnCode.NORMAL_END, collected);
            return result;
            
        } catch (FileException e) {
            throw e;
        } finally {
            fileLineIterator.closeFile();
        }
    }

    /**
     * FileQueryDAOݒ肷B
     * @param fileQueryDAO FileQueryDAO
     */
    public void setFileQueryDAO(FileQueryDAO fileQueryDAO) {
        this.fileQueryDAO = fileQueryDAO;
    }

   
    /**
     * ʃNXݒ肷B
     * @param resultClass ʃNX
     */
    public void setResultClass(Object resultClass) {
        this.resultClass = resultClass;
    }

}
