/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.dao.ibatis;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.dao.IllegalClassTypeException;
import jp.terasoluna.fw.dao.QueryDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.ibatis.SqlMapClientTemplate;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

/**
 * QueryDAOC^tF[XiBATISpNXB
 * <p/>
 * ̃NX́ABean`t@CBean`sT[rXw
 * CWFNVĎgpBȉɐݒႨюB<br/>
 * 
 * <br/> <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend> Bean`t@C̗ </legend> <p/> <code>
 * &lt;bean id="listBLogic"
 * class="jp.strutspring.blogic.ListBLogic"&gt;<br/>
 * &nbsp;&nbsp;&lt;property name="dao"&gt;&lt;ref
 * local="<b>queryDAO</b>"/&gt;&lt;/property&gt;<br/>
 * &lt;/bean&gt;<br/>
 * <br/>
 * &lt;bean id="<b>queryDAO</b>"<br/>
 * &nbsp;&nbsp;class="<b>jp.terasoluna.
 * fw.dao.ibatis.QueryDAOiBatisImpl</b>"&gt;<br/>
 * &nbsp;&nbsp;&lt;property name="sqlMapClient"&gt;&lt;ref
 * local="sqlMapClient"/&gt;&lt;/property&gt;<br/>
 * &lt;/bean&gt;<br/>
 * <br/>
 * &lt;bean id="sqlMapClient"<br/>
 * &nbsp;&nbsp;&nbsp;
 * class="org.springframework.orm.ibatis.SqlMapClientFactoryBean"&gt;<br/>
 * &nbsp;&nbsp;&lt;property name="configLocation"&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;value&gt;sqlMapConfig.xml&lt;/value&gt;<br/>
 * &nbsp;&nbsp;&lt;/property&gt;<br/>
 * &lt;/bean&gt;
 * </code>
 * </fieldset> <p/> <fieldset style="border:1pt solid
 * black;padding:10px;width:100%;">
 * <legend> T[rXwł̎gp@F擾f[^1̏ꍇ </legend>
 * <p/> <code>
 * public&nbsp;class&nbsp;ListBLogic{<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;private&nbsp;QueryDAO&nbsp;dao&nbsp;=&nbsp;null;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;public&nbsp;QueryDAO&nbsp;getDao()&nbsp;{<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;return&nbsp;dao;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;}<br/>
 * &nbsp;&nbsp;&nbsp;
 * public&nbsp;void&nbsp;setDao(QueryDAO&nbsp;dao)&nbsp;{<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * this.dao&nbsp;=&nbsp;dao;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;}<br/>
 * <br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;public&nbsp;String
 * execute(ActionForm&nbsp;form)&nbsp;{<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;UserBean&nbsp;bean<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;=
 * <b>dao.executeForObject("getUser","10000000",UserBean.class);</b><br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;...<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;return&nbsp;"success";<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;}<br/>
 * }
 * </code>
 * </fieldset> <p/> 
 * <fieldset style="border:1pt solid
 * black;padding:10px;width:100%;">
 * <legend> T[rXwł̎gp@F擾f[^̏ꍇ(S擾)List</legend>
 * <p/>
 * <code>
 * public&nbsp;String&nbsp;execute(ActionForm&nbsp;form)&nbsp;{</br>
 * &nbsp;&nbsp;&nbsp;&nbsp;List<UserBean>&nbsp;bean</br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;=
 * <b>dao.executeForObjectList("getUser","10000000");</b></br>
 * &nbsp;&nbsp;&nbsp;&nbsp;...</br>
 * &nbsp;&nbsp;&nbsp;&nbsp;return&nbsp;"success";</br>
 * }
 * </code>
 * </fieldset>
 * <p/>
 * <fieldset style="border:1pt solid
 * black;padding:10px;width:100%;">
 * <legend> T[rXwł̎gp@F擾f[^̏ꍇ(S擾)z</legend>
 * <p/> 
 * <code>
 * public&nbsp;String&nbsp;execute(ActionForm&nbsp;form)&nbsp;{</br>
 * &nbsp;&nbsp;&nbsp;&nbsp;UserBean[]&nbsp;bean</br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;=
 * <b>dao.executeForObjectArray("getUser","10000000",UserBean.class);</b></br>
 * &nbsp;&nbsp;&nbsp;&nbsp;...</br>
 * &nbsp;&nbsp;&nbsp;&nbsp;return&nbsp;"success";</br>
 * }
 * </code>
 * </fieldset> <p/> <fieldset style="border:1pt solid
 * black;padding:10px;width:100%;">
 * <legend> T[rXwł̎gp@F擾f[^̏ꍇ
 * (wCfbNX̎w茏擾)List
 * </legend>
 * <br>
 * &nbsp;&nbsp;Ɏ擾JnCfbNXь̎wsB
 * ȉ̗ł́A21ڂ10擾B <p/> 
 * <code>
 * public&nbsp;String&nbsp;execute(ActionForm&nbsp;form)&nbsp;{</br>
 * &nbsp;&nbsp;&nbsp;&nbsp;List<UserBean>&nbsp;bean</br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;=
 * <b>dao.executeForObjectList("getUser","10000000",
 * 20,&nbsp;10);</b></br>
 * &nbsp;&nbsp;&nbsp;&nbsp;...</br>
 * &nbsp;&nbsp;&nbsp;&nbsp;return&nbsp;"success";</br>
 * }
 * </code>
 * </fieldset> <p/> <fieldset style="border:1pt solid
 * black;padding:10px;width:100%;">
 * <legend> T[rXwł̎gp@F擾f[^̏ꍇ
 * (wCfbNX̎w茏擾)z
 * </legend>
 * <br>
 * &nbsp;&nbsp;Ɏ擾JnCfbNXь̎wsB
 * ȉ̗ł́A21ڂ10擾B <p/>
 * <code>
 * public&nbsp;String&nbsp;execute(ActionForm&nbsp;form)&nbsp;{</br>
 * &nbsp;&nbsp;&nbsp;&nbsp;UserBean[]&nbsp;bean</br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;=
 * <b>dao.executeForObjectArray("getUser","10000000",UserBean.class,
 * 20,&nbsp;10);</b></br>
 * &nbsp;&nbsp;&nbsp;&nbsp;...</br>
 * &nbsp;&nbsp;&nbsp;&nbsp;return&nbsp;"success";</br>
 * }
 * </code>
 * </fieldset> <p/>
 * 
 */
public class QueryDAOiBatisImpl extends SqlMapClientDaoSupport implements
        QueryDAO {

    /**
     * OCX^X
     */
    private static Log log = LogFactory.getLog(QueryDAOiBatisImpl.class);

    /**
     * QƌnSQLsAʂw肳ꂽIuWFNgƂĕԋpB
     * SQĽʃIuWFNgƁAw肳ꂽ^ꍇ́AO𔭐B
     * 
     * @param <E>
     *            ԋpľ^
     * @param sqlID
     *            sSQLID
     * @param bindParams
     *            SQLɃoChli[IuWFNg
     * @param clazz
     *            ԋpl̃NX
     * @return SQL̎s
     */
    @SuppressWarnings("unchecked")
    public <E> E executeForObject(String sqlID,
                                   Object bindParams,
                                   Class clazz) {

        if (log.isDebugEnabled()) {
            log.debug("executeForObject Start.");
        }

        // SqlMapClientTemplate̎擾
        SqlMapClientTemplate sqlMapTemp = getSqlMapClientTemplate();

        // SQL̎sFl̎擾
        Object obj = sqlMapTemp.queryForObject(sqlID, bindParams);
        if (log.isDebugEnabled() && obj != null) {
            log.debug("Return type:" + obj.getClass().getName());
        }

        E rObj = null;
        try {
            if (clazz != null && obj != null) {
                rObj = (E) clazz.cast(obj);
            }
        } catch (ClassCastException e) {
            log.error(IllegalClassTypeException.ERROR_ILLEGAL_CLASS_TYPE);
            throw new IllegalClassTypeException(e);
        }

        if (log.isDebugEnabled()) {
            log.debug("executeForObject End.");
        }

        return rObj;
    }

    /**
     * QƌnSQLsAMapƂĕԋpB
     * 
     * @param sqlID
     *            sSQLID
     * @param bindParams
     *            SQLɃoChli[IuWFNg
     * @return SQL̎s
     */
    @SuppressWarnings("unchecked")
    public Map<String, Object> executeForMap(String sqlID, Object bindParams) {

        if (log.isDebugEnabled()) {
            log.debug("executeForMap Start.");
        }

        Map<String, Object> rObj = this.executeForObject(sqlID, bindParams,
                Map.class);

        if (log.isDebugEnabled()) {
            log.debug("executeForMap End.");
        }

        return rObj;
    }

    /**
     * QƌnSQLsAʂw肳ꂽIuWFNg̔zƂĕԋpB
     * SQĽʃIuWFNgƁAw肳ꂽ^ꍇ́AO𔭐B
     * 
     * @param <E>
     *            ԋpľ^
     * @param sqlID
     *            sSQLID
     * @param bindParams
     *            SQLɃoChli[IuWFNg
     * @param clazz
     *            ԋpl̃NX
     * @return SQL̎s
     */
    @SuppressWarnings("unchecked")
    public <E> E[] executeForObjectArray(String sqlID, Object bindParams,
            Class clazz) {

        if (log.isDebugEnabled()) {
            log.debug("executeForObjectArray Start.");
        }

        if (clazz == null) {
            log.error(IllegalClassTypeException.ERROR_ILLEGAL_CLASS_TYPE);
            throw new IllegalClassTypeException();
        }

        // SqlMapClient̎擾
        SqlMapClientTemplate sqlMapTemp = getSqlMapClientTemplate();

        // SQL̎sFl̎擾
        List<E> list = sqlMapTemp.queryForList(sqlID, bindParams);

        // zɕϊ
        E[] retArray = (E[]) Array.newInstance(clazz, list.size());
        try {
            list.toArray(retArray);
        } catch (ArrayStoreException e) {
            log.error(IllegalClassTypeException.ERROR_ILLEGAL_CLASS_TYPE);
            throw new IllegalClassTypeException(e);
        }

        if (log.isDebugEnabled()) {
            log.debug("executeForObjectArray End.");
        }

        return retArray;
    }

    /**
     * QƌnSQLsAMap̔zƂĕԋpB
     * Mapz̕ϊɎsꍇ́AO𔭐B
     * 
     * @param sqlID
     *            sSQLID
     * @param bindParams
     *            SQLɃoChli[IuWFNg
     * @return SQL̎s
     */
    public Map<String, Object>[] executeForMapArray(String sqlID,
            Object bindParams) {

        if (log.isDebugEnabled()) {
            log.debug("executeForMapArray Start.");
        }

        Map<String, Object>[] map = executeForObjectArray(sqlID, bindParams,
                Map.class);

        if (log.isDebugEnabled()) {
            log.debug("executeForMapArray End.");
        }

        return map;
    }

    /**
     * QƌnSQLsAʂw肳ꂽIuWFNg̔zƂĕԋpB
     * ԋp錋ʂ́AɂĎw肳ꂽCfbNXw肳ꂽłB
     * SQĽʃIuWFNgƁAw肳ꂽ^ꍇ́AO𔭐B
     * 
     * @param <E>
     *            ԋpľ^
     * @param sqlID
     *            sSQLID
     * @param bindParams
     *            SQLɃoChli[IuWFNg
     * @param clazz
     *            ԋpl̃NX
     * @param beginIndex
     *            擾JnCfbNX
     * @param maxCount
     *            擾錏
     * @return SQL̎s
     */
    @SuppressWarnings("unchecked")
    public <E> E[] executeForObjectArray(String sqlID, Object bindParams,
            Class clazz, int beginIndex, int maxCount) {

        if (log.isDebugEnabled()) {
            log.debug("executeForObjectArray Start.");
        }

        if (clazz == null) {
            log.error(IllegalClassTypeException.ERROR_ILLEGAL_CLASS_TYPE);
            throw new IllegalClassTypeException();
        }

        // SqlMapClient̎擾
        SqlMapClientTemplate sqlMapTemp = getSqlMapClientTemplate();

        // SQL̎sFl̎擾
        List<E> list = sqlMapTemp.queryForList(sqlID, bindParams, beginIndex,
                maxCount);

        // zɕϊ
        E[] retArray = (E[]) Array.newInstance(clazz, list.size());
        try {
            list.toArray(retArray);
        } catch (ArrayStoreException e) {
            log.error(IllegalClassTypeException.ERROR_ILLEGAL_CLASS_TYPE);
            throw new IllegalClassTypeException(e);
        }

        if (log.isDebugEnabled()) {
            log.debug("executeForObjectArray End.");
        }

        return retArray;
    }

    /**
     * QƌnSQLsAMap̔zƂĕԋpB
     * ԋp錋ʂ́AɂĎw肳ꂽCfbNXw肳ꂽłB
     * Mapz̕ϊɎsꍇ́AO𔭐B
     * 
     * @param sqlID
     *            sSQLID
     * @param bindParams
     *            SQLɃoChli[IuWFNg
     * @param beginIndex
     *            擾JnCfbNX
     * @param maxCount
     *            擾錏
     * @return SQL̎s
     */
    public Map<String, Object>[] executeForMapArray(String sqlID,
            Object bindParams, int beginIndex, int maxCount) {

        if (log.isDebugEnabled()) {
            log.debug("executeForMapArray Start.");
        }

        Map<String, Object>[] map = executeForObjectArray(sqlID, bindParams,
                Map.class, beginIndex, maxCount);

        if (log.isDebugEnabled()) {
            log.debug("executeForMapArray End.");
        }

        return map;
    }

    /**
     * QƌnSQLsAʂw肳ꂽIuWFNgListƂĕԋpB
     * 
     * @param <E>
     *            ԋpľ^
     * @param sqlID
     *            sSQLID
     * @param bindParams
     *            SQLɃoChli[IuWFNg
     * @return SQL̎sʃXg
     */
    @SuppressWarnings("unchecked")
    public <E> List<E> executeForObjectList(String sqlID, Object bindParams) {

        if (log.isDebugEnabled()) {
            log.debug("executeForObjectList Start.");
        }

        // SqlMapClient̎擾
        SqlMapClientTemplate sqlMapTemp = getSqlMapClientTemplate();

        // SQL̎sFl̎擾
        List<E> list = sqlMapTemp.queryForList(sqlID, bindParams);
        
        if (log.isDebugEnabled()) {
            log.debug("executeForObjectList End.");
        }

        return list;
    }
    
    /**
     * QƌnSQLsAMapListƂĕԋpB
     * 
     * @param sqlID
     *            sSQLID
     * @param bindParams
     *            SQLɃoChli[IuWFNg
     * @return SQL̎s
     */
    public List<Map<String, Object>> executeForMapList(String sqlID,
            Object bindParams) {

        if (log.isDebugEnabled()) {
            log.debug("executeForMapList Start.");
        }

        List<Map<String, Object>> mapList = executeForObjectList(sqlID, bindParams);

        if (log.isDebugEnabled()) {
            log.debug("executeForMapList End.");
        }

        return mapList;
    }    

    /**
     * QƌnSQLsAʂw肳ꂽIuWFNgListƂĕԋpB
     * ԋp錋ʂ́AɂĎw肳ꂽCfbNXw肳ꂽłB
     * 
     * @param <E>
     *            ԋpľ^
     * @param sqlID
     *            sSQLID
     * @param bindParams
     *            SQLɃoChli[IuWFNg
     * @param beginIndex
     *            擾JnCfbNX
     * @param maxCount
     *            擾錏
     * @return SQL̎s
     */
    @SuppressWarnings("unchecked")
    public <E> List<E> executeForObjectList(String sqlID, Object bindParams,
            int beginIndex, int maxCount) {

        if (log.isDebugEnabled()) {
            log.debug("executeForObjectList Start.");
        }

        // SqlMapClient̎擾
        SqlMapClientTemplate sqlMapTemp = getSqlMapClientTemplate();

        // SQL̎sFl̎擾
        List<E> list = sqlMapTemp.queryForList(sqlID, bindParams, beginIndex,
                maxCount);
        
        if (log.isDebugEnabled()) {
            log.debug("executeForObjectList End.");
        }

        return list;
    }    
    
    /**
     * QƌnSQLsAMapListƂĕԋpB
     * ԋp錋ʂ́AɂĎw肳ꂽCfbNXw肳ꂽłB
     * 
     * @param sqlID
     *            sSQLID
     * @param bindParams
     *            SQLɃoChli[IuWFNg
     * @param beginIndex
     *            擾JnCfbNX
     * @param maxCount
     *            擾錏
     * @return SQL̎s
     */
    public List<Map<String, Object>> executeForMapList(String sqlID,
            Object bindParams, int beginIndex, int maxCount) {

        if (log.isDebugEnabled()) {
            log.debug("executeForMapList Start.");
        }

        List<Map<String, Object>> mapList = executeForObjectList(sqlID, bindParams,
                beginIndex, maxCount);

        if (log.isDebugEnabled()) {
            log.debug("executeForMapList End.");
        }

        return mapList;
    }
    
}