/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.util.StringUtil;

/**
 * <p>
 *  ttH[}bgďóA邢̓XNveBOϐƂ
 *  `JX^^O߂̒ۊNXB
 * </p>
 * <p>
 *  t̃tH[}bgsJX^^ÕNX͂̊NX
 *  pč쐬B
 * </p>
 * <p>
 *  tH[}bgΏۂƂȂtf[^ƂẮA<code>java.util.Date</code>
 *  ^A邢 <code>java.lang.String</code> ^T|[gBA
 *  <code>java.lang.String</code> ^̃f[^tH[}bgۂɂ́A
 *  ̕ <code>&quot;yyyy/MM/dd hh:mm:ss&quot;</code>
 *  ̌`ƂȂĂKvB<br>
 * </p>
 * <p>
 *  {@link DateFormatterTagBase} NXpTuNXł́A
 *  ۂɕ̃tH[}bgsۃ\bh
 *  <code>doFormat(Date date)</code> B
 * </p>
 * <h5>^OT|[g鑮</h5>
 * <p><code>DateFormatterTagBase</code> ł́Aȉ̑T|[gB</p>
 * <div align="center">
 *  <table width="90%" border="1" bgcolor="#FFFFFF">
 *   <tr>
 *    <td> <b></b> </td>
 *    <td> <b>ftHgl</b> </td>
 *    <td> <b>K{</b> </td>
 *    <td> <b>s</b> </td>
 *    <td> <b>Tv</b> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>id</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>false</code> </td>
 *    <td align="left">tH[}bgꂽX|X֏o͂ɁA
 *      XNveBOϐɃZbgۂɎw肷B
 *      tH[}bgꂽXNveBOϐɃZbgꍇɂ́A
 *      <code>filter</code> ̎wɊւ炸HTML
 *      ꕶ̓GXP[vȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>filter</code> </td>
 *    <td> <code>true</code> </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">tH[}bgꂽo͂ۂɁAHTMLꕶ
 *      GXP[v邩ǂw肷BA<code>id</code> 
 *      w肳Ăꍇɂ́AB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>ignore</code></td>
 *    <td><code>false</code></td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left"><code>name</code> Ŏw肵 bean
 *      ȂƂɖ邩ǂw肷B<code>false</code>
 *      w肷ƁAbeanȂƂ <code>JspException</code>
 *      B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>name</code></td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">tH[}bgΏۂ̕vpeBɎ
 *      bean̖OB<code>property</code> w肳
 *      ȂƂɂ́A<code>name</code> Ŏw肳ꂽCX^X
 *      tH[}bg̑ΏۂƂȂB̏ꍇ́A
 *      ̃CX^Xg <code>java.util.Date</code> ^ł邩A邢
 *      <code>java.lang.String</code> ^i&quot;yyyy/MM/dd hh:mm:ss&quot;
 *      ̌`ƂȂẮĵǂ炩łKvB<code>value</code>
 *      w肳Ăꍇɂ́AB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>property</code></td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left"><code>name</code> Ŏw肳ꂽ bean
 *      ɂăANZXvpeB̖OB<code>value</code> 
 *      w肳Ăꍇɂ͖B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>scope</code></td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td>i<code>findAttribute()</code>\bȟj</td>
 *    <td align="left"><code>name</code> Ŏw肳ꂽ bean
 *      ۂ̃XR[vB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>value</code></td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">tH[}bg镶B́A
 *      &quot;yyyy/MM/dd hh:mm:ss&quot;̌`ƂȂĂKvB
 *      <code>value</code> w肵ꍇɂ́A<code>name</code>
 *      A <code>property</code>
 *      ͖B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>pattern</code></td>
 *    <td> - </td>
 *    <td> <code>true</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">tH[}bgo͌`B<code>pattern</code>
 *      Ŏw肵o͌`́A<code>DateFormatterTagBase</code>
 *      NX̃TuNXŉ߂Bڍׂ́ATuNX̃hLg
 *      QƂ̂ƁB
 *    </td>
 *   </tr>
 * </table>
 * </div>
 * <br><br>
 * <h5>JX^^ÕXNveBOϐ</h5>
 * <p>
 *  <code>DateFormatterTagBase</code> ł͈ȉ̕ϐT|[gB
 * </p>
 * <div align="center">
 * <table width="90%" border="1">
 *  <tr>
 *   <td><b>ϐ</b></td>
 *   <td><b>^</b></td>
 *   <td><b>L͈</b></td>
 *   <td><b>Lq</b></td>
 *  </tr>
 *  <tr>
 *   <td>JX^^O <code>id</code> Ŏw肳ꂽO</td>
 *   <td><code>String</code></td>
 *   <td>Jn^Oȍ~</td>
 *   <td align="left">
 *    ̃JX^^Oŏo͂AXNveBOϐ
 *    ݒ肷ꍇ̕ϐB
 *   </td>
 *  </tr>
 * </table>
 * </div>
 *
 * @see jp.terasoluna.fw.web.taglib.DateTag
 * @see jp.terasoluna.fw.web.taglib.JDateTag
 *
 */
public abstract class DateFormatterTagBase extends TagSupport {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(DateFormatterTagBase.class);
    
    /**
     * t̃tH[}bgB
     * f[^tƂĉ߂ۂɎgpB
     *
     */
    private static final String DATE_FORMAT = "yyyy/MM/dd hh:mm:ss";

    /**
     * ̃y[Wŗpł悤ɂ邽߂̃XNveBOϐ̖OB
     *
     */
    protected String id = null;

    /**
     * XNveBOϐ̖Oݒ肷B
     *
     * @param id XNveBOϐ
     */
    @Override
    public void setId(String id) {
        this.id = id;
    }

    /**
     * o͒HTMLꕶtB^[邩ǂBftHg
     * <code>true</code>B
     *
     */
    protected boolean filter = true;

    /**
     * o͒HTMLꕶtB^[邩ǂݒ肷B
     *
     * @param filter o͒HTMLꕶtB^[ꍇ
     *               <code>true</code>
     */
    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    /**
     * beanȂƂɁAPɖio͂ȂjǂB
     * Ȃꍇɂ́AO𓊂BftHg <code>false</code>
     * iO𓊂jB
     */
    protected boolean ignore = false;

    /**
     * beanȂꍇɖ邩ǂݒ肷B
     *
     * @param ignore ꍇ <code>true</code>
     */
    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    /**
     * tH[}bgΏۂ̃f[^܂bean̖OB
     *
     */
    protected String name = null;

    /**
     * tH[}bgΏۂ̃f[^܂bean̖Oݒ肷B
     *
     * @param name bean̖O
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * w肳ꂽbeanɂăANZXvpeB̖OB
     *
     */
    protected String property = null;

    /**
     * w肳ꂽbeanɂăANZXvpeBݒ肷B
     *
     * @param property vpeB
     */
    public void setProperty(String property) {
        this.property = property;
    }

    /**
     * w肳ꂽbeanXR[vB
     *
     */
    protected String scope = null;

    /**
     * w肳ꂽbeanXR[vݒ肷B
     *
     * @param scope XR[v
     */
    public void setScope(String scope) {
        this.scope = scope;
    }

    /**
     * o͂̃tH[}bgw肷p^[B
     * <code>SimpleDateFormat</code> ƓŎw肷B
     *
     */
    protected String pattern = null;

    /**
     * o͂̃tH[}bgw肷p^[ݒ肷B
     *
     * @param pattern p^[
     */
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    /**
     * tH[}bgΏۂ̒lijB
     *
     */
    protected String value = null;

    /**
     * tH[}bgΏۂ̒lݒ肷B
     *
     * @param value tH[}bgΏۂ̒l
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * ^O]JnɌĂ΂郁\bhB
     *
     * @return wB <code>SKIP_BODY</code>
     * @throws JspException JSPO
     */
    @Override
    public int doStartTag() throws JspException {

        Object value = this.value;
        if (value == null) {
            // beanȂĂꍇɂ́AvꂽbeanbNAbv
            // Ȃꍇɂ́A^[
            if (ignore) {
                if (TagUtil.lookup(pageContext, name, scope) == null) {
                    return SKIP_BODY;  // o͂Ȃ
                }
            }

            // vꂽvpeB̒lbNAbv
            value = TagUtil.lookup(pageContext, name, property, scope);
            if (value == null) {
                return SKIP_BODY;  // o͂Ȃ
            }
        }

        // vpeB̒lString^łΈxDate֕ϊ
        Date date = null;
        if (value instanceof String) {
            // Eg
            String trimed = StringUtil.rtrim((String) value);

            // xDate^ɕϊ
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            try {
                date = sdf.parse(trimed);
            } catch (ParseException e) {
                log.error("Date parsing error.");
                
                throw new JspTagException(e.getMessage());
            }
        } else if (value instanceof Date) {
            date = (Date) value;
        } else {
            return SKIP_BODY;  // o͂Ȃ
        }

        // tH[}bg
        String output = doFormat(date);

        if (id != null) {
            // idw肳ĂƂɂ́AXNveBOϐƂėpł
            // 悤Ƀy[WXR[vɃZbgB
            pageContext.setAttribute(id, output);
        } else {
            // idw肳ĂȂƂɂ́AvpeB̒lC^Ƀvg
            // BK؂ɃtB^B
            if (filter) {
                TagUtil.write(pageContext, TagUtil.filter(output));
            } else {
                TagUtil.write(pageContext, output);
            }
        }

        return SKIP_BODY;
    }

    /**
     * ׂẴAP[gꂽB
     *
     */
    @Override
    public void release() {
        super.release();
        id = null;
        filter = true;
        ignore = false;
        name = null;
        property = null;
        scope = null;
        pattern = null;
        value = null;
    }

    /**
     * t̃tH[}bgsۃ\bhB
     * TuNXŃI[o[ChB
     *
     * @param date t
     * @return tH[}bgꂽ
     */
    protected abstract String doFormat(Date date);

}
