/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.core;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <code>Chunk</code> PʂƂāA<code>Chunk</code> f[^
 * ƂrWlXWbNsB
 *
 * <p>Wu\ <code>Workable</code> C^tF[X̎̊Kw\
 * ɂāAłŉwiłȍƒPʁjɈʒuB<code>JobWorker</code>
 * ́A<code>Chunk</code> Ɋ܂܂邷ׂẴf[^ɑ΂āA
 * JԂrWlXWbNNB</p>
 *
 * <p>rWlXWbN̋N̍ۂɂ́A<code>Chunk</code> Ɋ܂܂
 * <code>JobContext</code> nB
 * rWlXWbN̎śA<code>blogicExecutor</code> ɐݒ肳Ă
 * rWlXWbNsNX̃CX^XɈϏB</p>
 *
 * <p><code>JobWorker</code> ł́A<code>Chunk</code> Ɋ܂܂邷ׂẴf[^
 * nāAob`XVXgێBob`XVXǵA
 * rWlXWbNob`XV̈˗閈ɐǉB
 * ob`XVXǵA<code>Chunk</code>Ɋ܂܂邷ׂẴf[^ɑ΂
 * rWlXWbN̎sIAB
 * Aob`XVXg̏́A<code>batchUpdateResultHandler</code>
 * ɐݒ肳Ăob`XVvZbTɈϏB</p>
 *
 * <p>ob`XVvZbTNɁAob`XV̏ʂWuXe[^Xւ
 * fAOo͂Ȃǂs悤 <code>batchUpdateResultHandler</code>
 * ɐݒ肳ꂽob`XVʃnhNB</p>
 *
 * <p>ob`XVvZbTAуob`XVʃnhŗO
 * ꍇɂ́AOnhɂďBOnh́A
 * <code>exceptionHandlerMap</code>ɐݒ肳ĂOnh`
 * 擾Bob`XVvZbTAуob`XVʂŗOꍇ
 * ̃nhOnhɂ́A<code>BatchUpdateException</code> OL[
 * Ē`Ă̂gB</p>
 *
 * <p>Onh`A<code>BatchUpdateException</code> OL[Ƃ
 * Onh擾łȂꍇɂ́A
 * <code>defaultJobExceptionHandler</code>ɐݒ肳Ă
 * ftHgOnhAOɎgB</p>
 *
 */
public class JobWorker implements Workable<Chunk> {

    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(JobWorker.class);

    /**
     * Onhi[MapB
     */
    protected LinkedHashMap<JobException, JobExceptionHandler> 
               exceptionHandlerMap = null;

    /**
     * ftHgOnhB
     */
    protected JobExceptionHandler defaultJobExceptionHandler = null;

    /**
     * ThrowablenhB
     */
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler(); 

    /**
     * ob`XVvZbTB
     */
    protected BatchUpdateProcessor batchUpdateProcessor = null;
    
    /**
     * ob`XV̏ʃnhB
     */
    protected BatchUpdateResultHandler batchUpdateResultHandler = null;

    /**
     * rWlXWbNsNX̃CX^XB
     */
    private BLogicExecutor blogicExecutor = null;
    
    /**
     * <code>Chunk</code> B
     * <p>
     * <code>JobWorker</code> ł́A<code>Chunk</code> Ɋ܂܂
     * ׂẴf[^ɓnāAob`XVXgێB
     * <br>ob`XVXǵArWlXWbNob`XV̈˗閈
     * ǉB<br>
     * ob`XVXǵA<code>Chunk</code>Ɋ܂܂邷ׂẴf[^ɑ΂
     * rWlXWbN̎sIAB<br>
     * Aob`XVXg̏́A<code>batchUpdateResultHandler</code>
     * ɐݒ肳Ăob`XVvZbTɈϏB
     * </p>
     * <p>
     * `NɊ܂܂f[^ɃWuXe[^XI
     * (<code>JobStatus.STATE.INTERRUPTED_FOR_IMMEDIATE_SHUTDOWN</code>)
     * ɍXVꂽꍇA<br>
     * ԂI(<code>JobStatus.STATE.SUSPENDING</code>) ɂāA
     * `N̏𒆒fB
     * <p>
     * <p>
     * `NɊ܂܂f[^ɃWuXe[^XfI
     * (<code>JobStatus.STATE.INTERRUPTED_FOR_GRACEFUL_SHUTDOWN</code>)
     * ɍXVꂽꍇ<br>
     * ԂύXɁA`N̏pB
     * <p>
     * 
     * @param chunk
     *            Ώۃf[^i[`N
     * @param jobStatus
     *            WuXe[^X
     */
    public void work(Chunk chunk, JobStatus jobStatus) {
        writeStartLog(jobStatus);

        if (chunk.size() == 0) {
            throw new IllegalArgumentException("chunk size is 0");
        }
        
        try {
            List<LinkedHashMap<String, Object>> batchUpdateMapList
            = new ArrayList<LinkedHashMap<String, Object>>();
            
            for (Object blogicInputData : chunk) {
                
                //I
                if (jobStatus.isShutdownImmediate()) {
                    jobStatus.suspend();
                    return;
                }
                
                // BLogicABLogicʃnȟĂяo
                blogicExecutor.executeBLogic(blogicInputData,
                        chunk.getJobContext(), jobStatus, batchUpdateMapList);
                
                if (!jobStatus.isContinue()) {
                    if (jobStatus.getJobState() 
                            == JobStatus.STATE.ENDING_NORMALLY) {
                        break;
                    }
                    return;
                }
            }
            
            // ob`XVs
            processBatchUpdate(chunk.getJobContext(), jobStatus,
                    batchUpdateMapList);
            
            writeEndLog(jobStatus);
        } catch (Throwable throwable) {
            throwableHandler.handle(chunk.getJobContext(), throwable, jobStatus);
        }
    }

    /**
     * ob`XVsB
     *
     * @param jobContext WuReLXg
     * @param jobStatus Wu
     * @param batchUpdateMapList ob`XVXg
     */
    protected void processBatchUpdate(JobContext jobContext,
            JobStatus jobStatus,
            List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        if (batchUpdateMapList.size() == 0) {
            return;
        }
        try {
            batchUpdateProcessor.processBatchUpdate(batchUpdateMapList);
            batchUpdateResultHandler.handle(jobStatus, batchUpdateMapList);
        } catch (RuntimeException e) {
            // BLogicABLogicʃnhŔȌ
            BatchUpdateException wrappingException
                = new BatchUpdateException(e, batchUpdateMapList);

            JobExceptionHandler handler
                = ExceptionHandlerUtil.getJobExceptionHandler(wrappingException,
                                                            exceptionHandlerMap,
                                                    defaultJobExceptionHandler);

            try {
                handler.handlException(jobContext, 
                        wrappingException,
                        jobStatus);
            } catch (RuntimeException handlerException) {
                log.error("[Exception in ExceptionHandler] Error JobID: "
                        + jobStatus.getJobId(), handlerException);
                jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
            }
        } 
    }

    /**
     * Onh`ݒ肷B
     *
     * @param exceptionHandlerMap Onh`
     */
    public void setExceptionHandlerMap(
         LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap) {
        this.exceptionHandlerMap = exceptionHandlerMap;
    }

    /**
     * ob`XVpNX̃CX^Xݒ肷B
     *
     * @param batchUpdateProcessor ob`XVpNX̃CX^X
     */
    public void setBatchUpdateProcessor(
            BatchUpdateProcessor batchUpdateProcessor) {
        this.batchUpdateProcessor = batchUpdateProcessor;
    }

    /**
     * rWlXWbNspNX̃CX^Xݒ肷B
     *
     * @param blogicExecutor rWlXWbNspNX̃CX^X
     */
    public void setBlogicExecutor(BLogicExecutor blogicExecutor) {
        this.blogicExecutor = blogicExecutor;
    }

    /**
     * ob`XV̏ʃnhݒ肷B
     * 
     * @param batchUpdateResultHandler ob`XV̏ʃnh
     */
    public void setBatchUpdateResultHandler(
            BatchUpdateResultHandler batchUpdateResultHandler) {
        this.batchUpdateResultHandler = batchUpdateResultHandler;
    }

    /**
     * ftHgOnhݒ肷B
     * @param defaultJobExceptionHandler ftHgOnh
     */
    public void setDefaultJobExceptionHandler(
            JobExceptionHandler defaultJobExceptionHandler) {
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
    }
    
    /**
     * JobWorker̊JnOo͂B
     * 
     * @param jobStatus WuXe[^X
     */
    private void writeStartLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("JobWorker processing START: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [BLogicExecutorName=");
            logStr.append(blogicExecutor.getClass().getSimpleName());
            logStr.append("] [BatchUpdateProcessorName=");
            logStr.append(batchUpdateProcessor.getClass().getSimpleName());
            logStr.append("] [BatchUpdateResultHandlerName=");
            logStr.append(batchUpdateResultHandler.getClass().getSimpleName());
            logStr.append("]");
            log.debug(logStr.toString());
        }
    }

    /**
     * JobWorkeȑIOo͂B
     * 
     * @param jobStatus WuXe[^X
     */
    private void writeEndLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("JobWorker processing END: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [BLogicExecutorName=");
            logStr.append(blogicExecutor.getClass().getSimpleName());
            logStr.append("] [BatchUpdateProcessorName=");
            logStr.append(batchUpdateProcessor.getClass().getSimpleName());
            logStr.append("] [BatchUpdateResultHandlerName=");
            logStr.append(batchUpdateResultHandler.getClass().getSimpleName());
            logStr.append("] [BatchUpdateCount=");
            logStr.append(jobStatus.getBatchUpdateCount());
            logStr.append("]");
            log.debug(logStr.toString());
        }
    }

    /**
     * Throwablenhݒ肷B
     * 
     * @param throwableHandler Throwablenh
     */
    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }

}
