/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;


/**
 * ڑIuWFNg̃bp[NXB<BR>
 * P̃eXgȂׂɍs߂ɁACX^XPɐA
 * g܂킷悤ɂĂB
 * ܂AEJBΉ̂߁Ajava.sql.Connetion#close()Ăۂclose
 * ܂Ȃ悤ɂĂB
 * 
 */
class DBConnectionWrapper implements Connection {

    /**
     * JDBCڑ̃[ŨL[
     */
    private static final String USER_KEY = "unittest.jdbc.user";

    /**
     * JDBCڑ̃pX[h̃L[
     */
    private static final String PASSWORDD_KEY = "unittest.jdbc.password";

    /**
     * JDBCڑURL̃L[
     */
    private static final String URL_KEY = "unittest.jdbc.url";

    /**
     * JDBCڑ̃hCõL[
     */
    private static final String DRIVER_KEY = "unittest.jdbc.driver";

    /**
     * JDBCڑ̃I[gR~bgwl̃L[
     */
    private static final String AUTOCOMMIT_KEY = "unittest.jdbc.autocommit";

    /**
     * B̃CX^XiSingletonp^[j
     */
    private static DBConnectionWrapper instance = null;

    /**
     * bvJDBCڑIuWFNg̎́B
     */
    private Connection jdbcConnection;


    /**
     * B̃CX^X̎擾B
     * 
     * @return B̃CX^XB
     */
    public static DBConnectionWrapper getInstance() {
        
        // łɃCX^XĂ΂ԂB
        if (instance != null) {
            return instance;
        }

        // ݒ擾
        String user = UTLibConfig.getProperty(USER_KEY);
        String passwd = UTLibConfig.getProperty(PASSWORDD_KEY);
        String url = UTLibConfig.getProperty(URL_KEY);
        String drv = UTLibConfig.getProperty(DRIVER_KEY);
        String autocommit = UTLibConfig.getProperty(AUTOCOMMIT_KEY);
        if (user == null || passwd == null || url == null || drv == null) {
            String msg = "f[^x[Xڑ񂪐w肳Ă܂B";
            throw new RuntimeException(msg);
        }

        // RlNV𐶐
        Properties dbprops = new Properties();
        dbprops.put("user", user);
        dbprops.put("password", passwd);
        try{
            Driver d = (Driver) Class.forName(drv).newInstance();
            Connection conn = d.connect(url, dbprops);
            conn.setAutoCommit(("on".equals(autocommit)));
            instance = new DBConnectionWrapper(conn);
        } catch(Exception e) {
            String msg = "JDBC Connection̐Ɏs܂I";
            throw new RuntimeException(msg, e);
        }
        return instance;
    }

    /**
     * RXgN^B
     * Singletonp^[ɂAprivateƂȂĂB
     * 
     * @param conn bvJDBCڑIuWFNg
     */
    private DBConnectionWrapper(Connection conn) {
        jdbcConnection = conn;
    }

    /**
     * ڑ̃N[YB
     * {́Ã\bhŐڑN[Y邪Ãbp[ł
     * N[YȂ悤ɃI[o[ChĂB́AEJB
     * eXgɑΉ邽߂ɊĂĂB
     * 
     * @throws SQLException
     */
    public void close() throws SQLException {
        // Ȃ悤ɂB
    }

    /**
     * N[YBjava.sql.Connection#close()̑ցB
     * 
     * @throws SQLException
     */
    public void doClose() throws SQLException {
        // ǂĂclose()Ƃp̃\bhB
        jdbcConnection.close();
    }

    /**
     * N[YĂ邩ǂ̊mFB
     * close()Ă񂾂ۂƂ͖֌Wȓ̂ŒӁB
     * 
     * @return ڑN[YĂ邩ǂB
     */
    public boolean isClosed() throws SQLException {
        // close()Ă񂾂ۂƂ͖֌Wȓ̂ŒӁB
        return jdbcConnection.isClosed();
    }

    /**
     * @see java.sql.Connection#createStatement()
     */
    public Statement createStatement() throws SQLException {
        return jdbcConnection.createStatement();
    }

    /**
     * @see java.sql.Connection#createStatement(int, int)
     */
    public Statement createStatement(
        int resultSetType,
        int resultSetConcurrency)
        throws SQLException {

        return jdbcConnection.createStatement(
            resultSetType,
            resultSetConcurrency);
    }

    /**
     * @see java.sql.Connection#prepareStatement(java.lang.String)
     */
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return jdbcConnection.prepareStatement(sql);
    }

    /**
     * @see java.sql.Connection#prepareStatement(java.lang.String, int, int)
     */
    public PreparedStatement prepareStatement(
        String sql,
        int resultSetType,
        int resultSetConcurrency)
        throws SQLException {

        return jdbcConnection.prepareStatement(
            sql,
            resultSetType,
            resultSetConcurrency);
    }

    /**
     * @see java.sql.Connection#prepareCall(java.lang.String)
     */
    public CallableStatement prepareCall(String sql) throws SQLException {
        return jdbcConnection.prepareCall(sql);
    }

    /**
     * @see java.sql.Connection#prepareCall(java.lang.String, int, int)
     */
    public CallableStatement prepareCall(
        String sql,
        int resultSetType,
        int resultSetConcurrency)
        throws SQLException {

        return jdbcConnection.prepareCall(
            sql,
            resultSetType,
            resultSetConcurrency);
    }

    /**
     * @see java.sql.Connection#nativeSQL(java.lang.String)
     */
    public String nativeSQL(String sql) throws SQLException {
        return jdbcConnection.nativeSQL(sql);
    }

    /**
     * @see java.sql.Connection#setAutoCommit(boolean)
     */
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        jdbcConnection.setAutoCommit(autoCommit);
    }

    /**
     * @see java.sql.Connection#getAutoCommit()
     */
    public boolean getAutoCommit() throws SQLException {
        return jdbcConnection.getAutoCommit();
    }

    /**
     * @see java.sql.Connection#commit()
     */
    public void commit() throws SQLException {
        jdbcConnection.commit();
    }

    /**
     * @see java.sql.Connection#rollback()
     */
    public void rollback() throws SQLException {
        jdbcConnection.rollback();
    }

    /**
     * @see java.sql.Connection#getMetaData()
     */
    public DatabaseMetaData getMetaData() throws SQLException {
        return jdbcConnection.getMetaData();
    }

    /**
     * @see java.sql.Connection#setReadOnly(boolean)
     */
    public void setReadOnly(boolean readOnly) throws SQLException {
        jdbcConnection.setReadOnly(readOnly);
    }

    /**
     * @see java.sql.Connection#isReadOnly()
     */
    public boolean isReadOnly() throws SQLException {
        return jdbcConnection.isReadOnly();
    }

    /**
     * @see java.sql.Connection#setCatalog(java.lang.String)
     */
    public void setCatalog(String catalog) throws SQLException {
        jdbcConnection.setCatalog(catalog);
    }

    /**
     * @see java.sql.Connection#getCatalog()
     */
    public String getCatalog() throws SQLException {
        return jdbcConnection.getCatalog();
    }

    /**
     * @see java.sql.Connection#setTransactionIsolation(int)
     */
    public void setTransactionIsolation(int level) throws SQLException {
        jdbcConnection.setTransactionIsolation(level);
    }

    /**
     * @see java.sql.Connection#getTransactionIsolation()
     */
    public int getTransactionIsolation() throws SQLException {
        return jdbcConnection.getTransactionIsolation();
    }

    /**
     * @see java.sql.Connection#getWarnings()
     */
    public SQLWarning getWarnings() throws SQLException {
        return jdbcConnection.getWarnings();
    }

    /**
     * @see java.sql.Connection#clearWarnings()
     */
    public void clearWarnings() throws SQLException {
        jdbcConnection.clearWarnings();
    }

    /**
     * @see java.sql.Connection#getTypeMap()
     */
    public Map getTypeMap() throws SQLException {
        return jdbcConnection.getTypeMap();
    }

    /**
     * @see java.sql.Connection#setTypeMap(java.util.Map)
     */
    public void setTypeMap(Map map) throws SQLException {
        jdbcConnection.setTypeMap(map);
    }

    /**
     * @see java.sql.Connection#getHoldability()
     */
    public int getHoldability() throws SQLException {
        return jdbcConnection.getHoldability();
    }

    /**
     * @see java.sql.Connection#setHoldability(int)
     */
    public void setHoldability(int holdability) throws SQLException {
        jdbcConnection.setHoldability(holdability);
    }

    /**
     * @see java.sql.Connection#setSavepoint()
     */
    public Savepoint setSavepoint() throws SQLException {
        return jdbcConnection.setSavepoint();
    }

    /**
     * @see java.sql.Connection#setSavepoint(java.lang.String)
     */
    public Savepoint setSavepoint(String name) throws SQLException {
        return jdbcConnection.setSavepoint(name);
    }

    /**
     * @see java.sql.Connection#rollback(java.sql.Savepoint)
     */
    public void rollback(Savepoint savepoint) throws SQLException {
        jdbcConnection.rollback(savepoint);
    }

    /**
     * @see java.sql.Connection#releaseSavepoint(java.sql.Savepoint)
     */
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        jdbcConnection.releaseSavepoint(savepoint);
    }

    /**
     * @see java.sql.Connection#createStatement(int, int, int)
     */
    public Statement createStatement(
        int resultSetType,
        int resultSetConcurrency,
        int resultSetHoldability)
        throws SQLException {
        return jdbcConnection.createStatement(
            resultSetType,
            resultSetConcurrency,
            resultSetHoldability);
    }

    /**
     * @see java.sql.Connection#prepareStatement(java.lang.String, int, int, int)
     */
    public PreparedStatement prepareStatement(
        String sql,
        int resultSetType,
        int resultSetConcurrency,
        int resultSetHoldability)
        throws SQLException {
        return jdbcConnection.prepareStatement(
            sql,
            resultSetType,
            resultSetConcurrency,
            resultSetHoldability);
    }

    /**
     * @see java.sql.Connection#prepareCall(java.lang.String, int, int, int)
     */
    public CallableStatement prepareCall(
        String sql,
        int resultSetType,
        int resultSetConcurrency,
        int resultSetHoldability)
        throws SQLException {
        return jdbcConnection.prepareCall(
            sql,
            resultSetType,
            resultSetConcurrency,
            resultSetHoldability);
    }

    /**
     * @see java.sql.Connection#prepareStatement(java.lang.String, int)
     */
    public PreparedStatement prepareStatement(String sql, int autoGenerateKeys)
        throws SQLException {
        return jdbcConnection.prepareStatement(sql, autoGenerateKeys);
    }

    /**
     * @see java.sql.Connection#prepareStatement(java.lang.String, int[])
     */
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes)
        throws SQLException {
        return jdbcConnection.prepareStatement(sql, columnIndexes);
    }

    /**
     * @see java.sql.Connection#prepareStatement(java.lang.String, java.lang.String[])
     */
    public PreparedStatement prepareStatement(String sql, String[] columnNames)
        throws SQLException {
        return jdbcConnection.prepareStatement(sql, columnNames);
    }
}
