/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;


/**
 * f[^x[XQƗp̃NXB
 * 
 */
class DBQueryObject extends DBObject {

    /**
     * ʃZbg̍s̍őlB
     */
    private static final int RESULT_ROW_MAX = 100000;

    /**
     * NG[(SQL SELECT)sB
     * 
     * @param sql sSQL
     * @return NG[ʂ̊i[ꂽXg
     * @throws SQLException
     */    
    public List query(String sql) throws SQLException {
        setSQL(sql);

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        List result = new ArrayList();

        try {
            // Xe[gg̎擾
            pstmt = getConnection().prepareStatement(sql);

            // p[^̐ݒ
            bindParams(pstmt);

            // SQLsʎ擾
            rs = pstmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int columns = rsmd.getColumnCount();
            String[] columnNames = new String[columns + 1]; // 0Ԗڂ͕sgp
            for (int i = 1; i <= columns; i++) {
                columnNames[i] = rsmd.getColumnLabel(i);
            }
            for (int i = 0; i < RESULT_ROW_MAX; i++) {
                if (!rs.next()) {
                    break;
                }
                Map row = new TreeMap();
                for (int j = 1; j <= columns; j++) {
                    if (rsmd.getColumnType(j) == java.sql.Types.DATE
                        || rsmd.getColumnType(j) == java.sql.Types.TIME
                        || rsmd.getColumnType(j) == java.sql.Types.TIMESTAMP) {

                        Timestamp ts = rs.getTimestamp(j);
                        String data = (ts != null) ? ts.toString() : null;
                        row.put(columnNames[j], data);
                    } else {
                        row.put(columnNames[j], rs.getString(j));
                    }
                }
                result.add(row);
            }
        } finally {
            params.clear();
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    // Ȃ
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                } catch (SQLException e) {
                    // Ȃ
                }
            }
        }
        return result;
    }
}
