// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Configuration;
using System.Net;
using TERASOLUNA.Fw.Client.Communication;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Client.BLogic
{
    /// <summary>
    /// T[oʐMsrWlXWbN̊NXłB
    /// </summary>
    /// <typeparam name="TParam">
    /// T[oɑMf[^IuWFNǧ^B
    /// <list type="bullet">
    /// <item>
    /// <paramref name="TParam"/> ́A<see cref="ICommunicator{TParam}.Communicate"/> 
    /// œnMf[^IuWFNǧ^ƂȂ܂B
    /// </item>
    /// <item>
    /// T[oƒʐMs <see cref="ICommunicator{TParam}"/> ́A<see cref="CommunicateBLogicBase{TParam}"/> hNX 
    /// <see cref="CreateCommunicator"/> I[o[ChĐ܂B
    /// </item>
    /// </list>
    /// </typeparam>
    public abstract class CommunicateBLogicBase<TParam> : ClientBLogicBase
        where TParam : class
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(CommunicateBLogicBase<TParam>));

        /// <summary>
        /// ʐMɒʒm郊NGXg̃L[lłB
        /// </summary>
        /// <remarks>̒萔̒l "RequestName" łB</remarks>
        public static readonly string REQUEST_NAME = "RequestName";

        /// <summary>
        /// AvP[V\t@CA܂ <see cref="Execute"/> \bḧ
        /// <see cref="BLogicParam.Items"/> ɐݒ肷ANGXg^CAEgԂ
        /// L[łB
        /// </summary>
        /// <remarks>̒萔̒l "ReqeustTimeout" łB</remarks>
        public static readonly string REQUEST_TIMEOUT = "RequestTimeout";

        /// <summary>
        /// <see cref="BLogicParam.Items"/> ɐݒ肳ꂽNGXgwb_擾邽߂̃L[łB
        /// </summary>
        /// <remarks>̒萔̒l "RequestHeaders" łB</remarks>
        public static readonly string REQUEST_HEADERS = "RequestHeaders";

        /// <summary>
        /// T[oőz肵ȂOꍇ̌ʕłB
        /// </summary>
        /// <remarks>̒萔̒l "serverException" łB</remarks>
        public static readonly string SERVER_EXCEPTION = "serverException";

        /// <summary>
        /// ʐMɗOꍇ̌ʕłB
        /// </summary>
        /// <remarks>̒萔̒l "communicationException" łB</remarks>
        public static readonly string COMMUNICATION_EXCEPTION = "communicationException";

        /// <summary>
        /// ʐM@\񋟂 <see cref="ICommunicator{TParam}"/> ێtB[hłB
        /// </summary>
        private ICommunicator<TParam> _communicator = null;

        /// <summary>
        /// <see cref="ClientBLogicBase.Cancelled"/> ̐ݒ莞ɗp铯p̃IuWFNgłB
        /// </summary>
        private object _syncRoot = new object();

        /// <summary>
        /// ʐM@\񋟂 <see cref="ICommunicator{TParam}"/> 擾܂B
        /// </summary>
        /// <value>
        /// ʐM@\񋟂 <see cref="ICommunicator{TParam}"/>B
        /// </value>
        protected ICommunicator<TParam> Communicator
        {
            get
            {
                return _communicator;
            }
        }

        /// <summary>
        /// <see cref="CommunicateBLogicBase{TParam}"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// <list type="bullet">
        /// <item>
        /// <see cref="CreateCommunicator"/> ŃT[oƒʐMs <see cref="ICommunicator{TParam}"/> 𐶐܂B
        /// </item>
        /// <item>
        /// <see cref="IProgressChangedEventInvoker.ProgressChanged"/>  <see cref="DoCommunicateProgressChanged"/> o^܂B
        /// </item>
        /// </list>
        /// </remarks>
        protected CommunicateBLogicBase()
        {
            _communicator = CreateCommunicator();
            _communicator.ProgressChanged += new ExecuteProgressChangedEventHandler(DoCommunicateProgressChanged);
        }

        /// <summary>
        /// ʐM@\񋟂 <see cref="ICommunicator{TParam}"/> 𐶐܂B
        /// </summary>
        /// <remarks>
        /// T[oƒʐMs <see cref="ICommunicator{TParam}"/> ́A<see cref="CommunicateBLogicBase{TParam}"/> hNX 
        /// <see cref="CreateCommunicator"/> I[o[ChĐ܂B
        /// </remarks>
        /// <returns>
        /// <see cref="ICommunicator{TParam}"/> NXB
        /// </returns>
        protected abstract ICommunicator<TParam> CreateCommunicator();

        /// <summary>
        /// <see cref="BLogicResult"/> hNX𐶐܂B
        /// </summary>
        /// <remarks>
        /// ftHg̒l <see cref="BLogicResult"/> łB
        /// </remarks>
        /// <returns>
        /// <see cref="BLogicResult"/> hNXB
        /// </returns>
        protected virtual BLogicResult CreateBLogicResult()
        {
            return new BLogicResult();
        }

        /// <summary>
        /// T[oƂ̒ʐMsrWlXWbNs܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// ȉ̏ŏs܂B
        /// <list type="number">
        /// <item>NGXgwb_̐ <seealso cref="CreateRequestHeaders"/></item>
        /// <item>ʐM̑O <seealso cref="BeforeCommunicate"/></item>
        /// <item>ʐMs <seealso cref="Communicate"/></item>
        /// <item>ʐM̌㏈ <seealso cref="AfterCommunicate"/></item>
        /// </list>
        /// ẽ\bhI[o[Ch邱ƂŁAʐM̑O㏈̊gł܂B
        /// </para>
        /// <para>
        /// T[oAvP[VƂ̒ʐMł́ANGXgwb_ɃNGXgKݒ肵܂B
        /// NGXg <see cref="BLogicParam.Items"/>  <see cref="REQUEST_NAME"/> 
        /// L[ƂĐݒ肵ĂB
        /// ̑̒lNGXgwb_ɐݒ肵ꍇ́ANGXg̃wb_\閼Oƒl̃yA
        /// i[ <see cref="IDictionary{String, String}"/> A<see cref="BLogicParam.Items"/>  
        /// <see cref="REQUEST_HEADERS"/> L[ƂĐݒ肵ĂB
        /// </para>
        /// <para>
        /// NGXgwb_̐ʐM̌㏈܂ł̊ԂŕߑȂOꍇ́A
        /// ȉ̂悤 <see cref="HandleException"/> ŗOnhO܂B
        /// <list type="bullet">
        /// <item>
        ///     O <see cref="CommunicationException"/> ̏ꍇ
        ///     <list type="bullet">
        ///     <item>
        ///     OߑărWlXWbNIB<see cref="BLogicResult"/>  
        ///     <see cref="BLogicResult.ResultString"/> ɂ <see cref="COMMUNICATION_EXCEPTION"/> ݒ肵A
        ///     <see cref="BLogicResult.Errors"/> ɂ͗ObZ[Wi[B
        ///     </item>
        ///     </list>
        /// </item>
        /// <item>
        ///     O <see cref="ServerException"/> ŁA<see cref="ServerException.ErrorType"/> 
        ///     <see cref="SERVER_EXCEPTION"/> ȊȌꍇ
        ///     <list type="bullet">
        ///     <item>
        ///     OߑărWlXWbNIB
        ///     <see cref="BLogicResult"/>  <see cref="BLogicResult.ResultString"/> ɂ́A
        ///     T[oAvP[Vœ͒l؃G[ꍇɂ 
        ///     <see cref="Communication.ReceiverBase.SERVER_VALIDATE_EXCEPTION"/> ݒ肷B
        ///     ̑AT[oAvP[VNCAgɒʒmׂG[Ăꍇ́A
        ///     T[oAvP[V瑗Mꂽ <see cref="ServerException.ErrorType"/> ݒ肷B
        ///     <see cref="BLogicResult"/>  <see cref="BLogicResult.Errors"/> ɂ́A
        ///     <see cref="ServerException"/>  <see cref="ServerException.Errors"/> i[B
        ///     </item>
        ///     </list>
        /// </item>
        /// <item>
        ///     O <see cref="ServerException"/> ŁA<see cref="ServerException.ErrorType"/> 
        ///     <see cref="SERVER_EXCEPTION"/> ̏ꍇ
        ///     <list type="bullet">
        ///     <item>
        ///     T[oőz肵ȂO߁AOߑȂōăX[B
        ///     </item>
        ///     </list>
        /// </item>
        /// <item>
        ///     ̗̑Ȍꍇ
        ///     <list type="bullet">
        ///     <item>
        ///     OߑȂōăX[B
        ///     </item>
        ///     </list>
        /// </item>
        /// </list>
        /// </para>
        /// </remarks>
        /// <param name="blogicParam">
        /// rWlXWbN̓͂ƂȂ <see cref="BLogicParam"/>B
        /// </param>
        /// <returns>
        /// rWlXWbN̎sʂi[ <see cref="BLogicResult"/>B
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="blogicParam"/>  null QƂłB
        /// </item>
        /// <item>
        /// ʐMŕKvȃf[^ null QƂłB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ArgumentException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <see cref="BLogicParam.Items"/>  <see cref="REQUEST_NAME"/> L[ƂăNGXgݒ肳Ă܂B
        /// </item>
        /// <item>
        /// <see cref="BLogicParam.Items"/>  <see cref="REQUEST_NAME"/> L[ƂĎ擾
        /// NGXg null QƂ܂͋󕶎łB
        /// </item>
        /// <item>
        /// <see cref="BLogicParam.Items"/>  <see cref="REQUEST_HEADERS"/> L[ƂĎ擾
        /// NGXgwb_̃RNVA<see cref="IDictionary{String, String}"/> ^ł͂܂B
        /// </item>
        /// <item>
        /// NGXgwb_̃L[Ƃċ󕶎܂͐twb_[ݒł܂B
        /// </item>
        /// <item>
        /// NGXgwb_̃L[ɖȕ܂܂Ă܂B
        /// </item>
        /// <item>
        /// <see cref="BLogicParam.Items"/>  <see cref="REQUEST_TIMEOUT"/> L[Ƃ
        /// 擾NGXg^CAEgԂlł͂܂B
        /// </item>
        /// <item>
        /// ʐMŕKvȃf[^słB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="System.IO.FileNotFoundException">
        /// ʐMŕKvȃt@C܂B
        /// </exception>
        /// <exception cref="ServerException">
        /// T[oAvP[Vőz肵ȂO܂B
        /// </exception>
        public override BLogicResult Execute(BLogicParam blogicParam)
        {
            if (blogicParam == null)
            {
                throw new ArgumentNullException("blogicParam");
            }

            if (blogicParam.ParamData == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.E_NULL_PARAMETER, "blogicParam.ParamData"));
            }

            // rWlXWbŇʃNX
            BLogicResult blogicResult = CreateBLogicResult();

            // LZ̍ۂ͌ʃIuWFNg͎gȂAnullł̓G[ƂȂB
            if (Cancelled)
            {
                return blogicResult;
            }

            try
            {
                // NGXgwb_̐
                IDictionary<string, string> requestHeaders = CreateRequestHeaders(blogicParam);

                // O
                BeforeCommunicate(blogicParam, requestHeaders);

                // ʐMs
                CommunicationResult communicationResult = Communicate(blogicParam, requestHeaders);

                // ㏈
                AfterCommunicate(communicationResult, blogicResult);
            }
            catch (Exception ex)
            {
                if (_log.IsWarnEnabled)
                {
                    _log.Warn(Properties.Resources.W_BLOGIC_EXCEPTION, ex);
                }

                lock (_syncRoot)
                {
                    if (Cancelled)
                    {
                        return blogicResult;
                    }
                }

                if (!HandleException(ex, blogicResult))
                {
                    throw;
                }
            }

            return blogicResult;
        }

        /// <summary>
        /// NGXgwb_𐶐܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// NGXg͕K{łB͒lƂȂ<see cref="BLogicParam.Items"/>  <see cref="REQUEST_NAME"/> 
        /// L[ƂăNGXgݒ肵ĂB
        /// </para>
        /// <para>
        /// ̑̒lNGXgwb_ɐݒ肵ꍇ́ANGXg̃wb_\閼Oƒl̃yA
        /// i[ <see cref="IDictionary{String, String}"/> A<see cref="BLogicParam.Items"/>  
        /// <see cref="REQUEST_HEADERS"/> L[ƂĐݒ肵ĂB
        /// </para>
        /// <para>
        /// <see cref="BLogicParam.Items"/>  <see cref="REQUEST_HEADERS"/> L[Ƃ null ݒ肵ꍇ́A
        /// NGXĝ݂NGXgwb_ɐݒ肵܂B
        /// </para>
        /// </remarks>
        /// <returns>
        /// NGXg̃wb_\閼Oƒl̃yAi[Ă <see cref="IDictionary{String, String}"/>B
        /// </returns>
        /// <exception cref="ArgumentException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <see cref="BLogicParam.Items"/>  <see cref="REQUEST_NAME"/> L[ƂăNGXgݒ肳Ă܂B
        /// </item>
        /// <item>
        /// <see cref="BLogicParam.Items"/>  <see cref="REQUEST_NAME"/> L[ƂĎ擾
        /// NGXg null QƂ܂͋󕶎łB
        /// </item>
        /// <item>
        /// <see cref="BLogicParam.Items"/>  <see cref="REQUEST_HEADERS"/> L[ƂĎ擾
        /// NGXgwb_̃RNVA<see cref="IDictionary{String, String}"/> ^ł͂܂B
        /// </item>
        /// <item>
        /// NGXgwb_̃L[Ƃċ󕶎܂͐twb_[ݒł܂B
        /// </item>
        /// <item>
        /// NGXgwb_̃L[ɖȕ܂܂Ă܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <param name="blogicParam">
        /// rWlXWbN̓ <see cref="BLogicParam"/>B
        /// </param>
        protected virtual IDictionary<string, string> CreateRequestHeaders(BLogicParam blogicParam)
        {
            IDictionary<string, string> requestHeaders = new Dictionary<string, string>();

            // NGXgwb_̐ݒ
            bool containsRequestHeaders = blogicParam.Items.ContainsKey(REQUEST_HEADERS) && blogicParam.Items[REQUEST_HEADERS] != null;
            if (containsRequestHeaders)
            {
                IDictionary<string, string> headers = blogicParam.Items[REQUEST_HEADERS] as IDictionary<string, string>;
                if (headers != null)
                {
                    // rWlXWbNItemsɐݒ肳ꂽNGXgwb_
                    // ʐMNX̃NGXgwb_ɐݒ
                    foreach (string key in headers.Keys)
                    {
                        if (string.IsNullOrEmpty(key))
                        {
                            throw new ArgumentException(Properties.Resources.E_EMPTY_REQUEST_HEADER_KEY);
                        }

                        bool isRestrictedKey = false; 
                        try
                        {
                            isRestrictedKey = WebHeaderCollection.IsRestricted(key);
                        }
                        catch (ArgumentException ex)
                        {
                            throw new ArgumentException(
                                string.Format(Properties.Resources.E_INVALID_REQUEST_HEADER_KEY, key), ex);
                        }

                        if (isRestrictedKey)
                        {
                            throw new ArgumentException(
                                string.Format(Properties.Resources.E_RESTRICTED_REQUEST_HEADER_KEY, key));
                        }

                        requestHeaders.Add(key, headers[key]);
                    }
                }
                else
                {
                    throw new ArgumentException(string.Format(Properties.Resources.E_REFERENCE_TYPE_INVALID_CAST,
                        REQUEST_HEADERS, blogicParam.Items[REQUEST_HEADERS].GetType().FullName, typeof(IDictionary<string, string>).FullName));
                }
            }

            // NGXg̐ݒ
            bool containsRequestName = blogicParam.Items.ContainsKey(REQUEST_NAME)
                && blogicParam.Items[REQUEST_NAME] != null && blogicParam.Items[REQUEST_NAME].ToString().Length != 0;
            if (containsRequestName)
            {
                requestHeaders[REQUEST_NAME] = blogicParam.Items[REQUEST_NAME].ToString();
            }
            else
            {
                throw new ArgumentException(Properties.Resources.E_REQUEST_NAME_NOT_FOUND);
            }

            return requestHeaders;
        }

        /// <summary>
        /// ʐM̑Os܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// ʐM̑Os܂BftHgł́Ap[^\t@C擾NGXg^CAEg
        /// Ԃ <see cref="ICommunicator{TParam}.RequestTimeout"/> ɐݒ肵܂B
        /// </para>
        /// <para>
        /// <see cref="ICommunicator{TParam}"/> ̊̃NGXg^CAEgԈȊO̒lݒ肵ꍇ́A
        /// <see cref="BLogicParam.Items"/> A邢͍\t@C<c>AppSettings</c>vf 
        /// <see cref="REQUEST_TIMEOUT"/> L[Ƃ 0 ȏ̐lݒ肵ĂB
        /// </para>
        /// <para>
        /// <see cref="BLogicParam.Items"/> ƍ\t@ĈǂɂNGXg^CAEgԂ̎w肪
        /// ꍇA<see cref="BLogicParam.Items"/> Ŏw肳ꂽlp܂BǂɂNGXg^CAEg
        /// Ԃw肳ĂȂꍇA<see cref="ICommunicator{TParam}"/> ̊̃NGXg^CAEgԂ
        /// p܂B
        /// </para>
        /// </remarks>
        /// <param name="blogicParam">
        /// rWlXWbN̓ <see cref="BLogicParam"/>B
        /// </param>
        /// <param name="requestHeaders">
        /// NGXg̃wb_\閼Oƒl̃yAi[Ă <see cref="IDictionary{String, String}"/>B
        /// </param>
        /// <exception cref="ArgumentException">
        /// <see cref="BLogicParam.Items"/>  <see cref="REQUEST_TIMEOUT"/> L[Ƃ
        /// 擾NGXg^CAEgԂlł͂܂B
        /// </exception>
        protected virtual void BeforeCommunicate(BLogicParam blogicParam, IDictionary<string, string> requestHeaders)
        {
            string requestTimeoutString = null;

            // NGXg^CAEgl擾
            if (blogicParam.Items.ContainsKey(REQUEST_TIMEOUT) && blogicParam.Items[REQUEST_TIMEOUT] != null)
            {
                requestTimeoutString = blogicParam.Items[REQUEST_TIMEOUT].ToString();
            }

            if (string.IsNullOrEmpty(requestTimeoutString))
            {
                requestTimeoutString = ConfigurationManager.AppSettings[REQUEST_TIMEOUT];
            }

            // NGXg^CAEgl擾ꍇAp[XăR~jP[^ɐݒ肷
            if (!string.IsNullOrEmpty(requestTimeoutString))
            {
                int requestTimeout = -1;
                if (!int.TryParse(requestTimeoutString, out requestTimeout))
                {
                    throw new ArgumentException(
                        string.Format(Properties.Resources.E_VALUE_TYPE_INVALID_CAST,
                        REQUEST_TIMEOUT, requestTimeoutString, requestTimeout.GetType().FullName));
                }

                Communicator.RequestTimeout = requestTimeout;
            }
        }

        /// <summary>
        /// ʐMs܂B
        /// </summary>
        /// <param name="blogicParam">rWlXWbN <see cref="BLogicParam"/>B</param>
        /// <param name="requestHeaders">NGXg̃wb_\閼Oƒl̃yAi[Ă <see cref="IDictionary{String, String}"/>B</param>
        /// <returns>ʐMʂi[ <see cref="CommunicationResult"/>B</returns>
        protected abstract CommunicationResult Communicate(BLogicParam blogicParam, IDictionary<string, string> requestHeaders);

        /// <summary>
        /// ʐM̌㏈s܂B
        /// </summary>
        /// <remarks>
        /// ʐMʂi[ <paramref name="communicationResult"/> 
        /// rWlXWbN̎sʂi[ <paramref name="blogicResult"/> ɒʐMʂ𔽉f܂B
        /// <see cref="AfterCommunicate"/> ͒ʐMɎs邽߁A
        /// <paramref name="blogicResult.ResultString"/> ɂ <see cref="BLogicResult.SUCCESS"/> ݒ肳܂B
        /// </remarks>
        /// <param name="communicationResult">ʐMʂi[ <see cref="CommunicationResult"/>B</param>
        /// <param name="blogicResult">rWlXWbN̎sʂi[ <see cref="BLogicResult"/>B</param>
        protected virtual void AfterCommunicate(CommunicationResult communicationResult, BLogicResult blogicResult)
        {
            blogicResult.ResultData = communicationResult.ResultData;
            blogicResult.ResultString = BLogicResult.SUCCESS;
        }

        /// <summary>
        /// NGXgwb_̐ʐM̌㏈܂ł̊ԂŕߑȂO
        /// ꍇɌĂ΂OnhłB
        /// </summary>
        /// <remarks>
        /// ÕnhO͈ȉ̂悤ɍs܂B
        /// <list type="bullet">
        /// <item>
        ///     O <see cref="CommunicationException"/> ̏ꍇ
        ///     <list type="bullet">
        ///     <item>
        ///     OߑărWlXWbNIB<see cref="BLogicResult"/>  
        ///     <see cref="BLogicResult.ResultString"/> ɂ <see cref="COMMUNICATION_EXCEPTION"/> ݒ肵A
        ///     <see cref="BLogicResult.Errors"/> ɂ͗ObZ[Wi[B
        ///     </item>
        ///     </list>
        /// </item>
        /// <item>
        ///     O <see cref="ServerException"/> ŁA<see cref="ServerException.ErrorType"/> 
        ///     <see cref="SERVER_EXCEPTION"/> ȊȌꍇ
        ///     <list type="bullet">
        ///     <item>
        ///     OߑărWlXWbNIB
        ///     <see cref="BLogicResult"/>  <see cref="BLogicResult.ResultString"/> ɂ́A
        ///     T[oAvP[Vœ͒l؃G[ꍇɂ 
        ///     <see cref="Communication.ReceiverBase.SERVER_VALIDATE_EXCEPTION"/> ݒ肷B
        ///     ̑AT[oAvP[VNCAgɒʒmׂG[Ăꍇ́A
        ///     T[oAvP[V瑗Mꂽ <see cref="ServerException.ErrorType"/> ݒ肷B
        ///     <see cref="BLogicResult"/>  <see cref="BLogicResult.Errors"/> ɂ́A
        ///     <see cref="ServerException"/>  <see cref="ServerException.Errors"/> i[B
        ///     </item>
        ///     </list>
        /// </item>
        /// <item>
        ///     O <see cref="ServerException"/> ŁA<see cref="ServerException.ErrorType"/> 
        ///     <see cref="SERVER_EXCEPTION"/> ̏ꍇ
        ///     <list type="bullet">
        ///     <item>
        ///     T[oőz肵ȂO߁AOߑȂōăX[B
        ///     </item>
        ///     </list>
        /// </item>
        /// <item>
        ///     ̗̑Ȍꍇ
        ///     <list type="bullet">
        ///     <item>
        ///     OߑȂōăX[B
        ///     </item>
        ///     </list>
        /// </item>
        /// </list>
        /// </remarks>
        /// <param name="ex">
        /// NGXgwb_̐ʐM̌㏈܂ł̊ԂŕߑȂOB
        /// </param>
        /// <param name="blogicResult">
        /// rWlXWbN̎sʂi[ <see cref="BLogicResult"/>B
        /// </param>
        /// <returns>
        /// <paramref name="ex"/> ߑărWlXWbNɏ߂ꍇ trueB
        /// <paramref name="ex"/> ăX[ꍇ falseB
        /// </returns>
        protected virtual bool HandleException(Exception ex, BLogicResult blogicResult)
        {
            if (ex is CommunicationException)
            {
                MessageInfo messageInfo = new MessageInfo(COMMUNICATION_EXCEPTION, ex.Message);
                blogicResult.ResultString = COMMUNICATION_EXCEPTION;
                blogicResult.Errors.Add(messageInfo);
                return true;
            }

            ServerException serverException = ex as ServerException;
            if (serverException != null)
            {
                if (SERVER_EXCEPTION.Equals(serverException.ErrorType))
                {
                    // T[oőzO̗O
                    return false;
                }
                else
                {
                    // T[o͒lOyуT[oƖO
                    blogicResult.ResultString = serverException.ErrorType;
                    blogicResult.AddErrors(serverException.Errors);
                    return true;
                }
            }

            // ̑̑zO̗O
            return false;
        }

        /// <summary>
        /// ʐMLZ܂B
        /// </summary>
        public override void Cancel()
        {
            lock (_syncRoot)
            {
                _communicator.Cancel();
                Cancelled = true;
            }
        }

        /// <summary>
        /// <see cref="Communicator"/> ̐is󋵃Cxg̒ʒm󂯁A
        /// <see cref="ClientBLogicBase.ProgressChanged"/> ɓo^ꂽCxgnhɑ΂Ēʒm܂B
        /// </summary>
        /// <param name="sender">CxgIuWFNgB</param>
        /// <param name="e">Cxgf[^i[Ă <see cref="ExecuteProgressChangedEventArgs"/>B</param>
        protected virtual void DoCommunicateProgressChanged(object sender, ExecuteProgressChangedEventArgs e)
        {
            OnProgressChanged(e);
        }
    }
}
